package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Tue Jun 10 11:30:04 CEST 2014")
public abstract class EmailAbstract extends AbstractTopiaEntity implements Email {

    /**
     * Nom de l'attribut en BD : receptionDate
     */
    protected Date receptionDate;

    /**
     * Nom de l'attribut en BD : ediCodeNumber
     */
    protected String ediCodeNumber;

    /**
     * Nom de l'attribut en BD : projectReference
     */
    protected String projectReference;

    /**
     * Nom de l'attribut en BD : sender
     */
    protected String sender;

    /**
     * Nom de l'attribut en BD : fax
     */
    protected boolean fax;

    /**
     * Nom de l'attribut en BD : recipient
     */
    protected String recipient;

    /**
     * Nom de l'attribut en BD : object
     */
    protected String object;

    /**
     * Nom de l'attribut en BD : archiveDate
     */
    protected Date archiveDate;

    /**
     * Nom de l'attribut en BD : companyReference
     */
    protected String companyReference;

    /**
     * Nom de l'attribut en BD : originalEmail
     */
    protected String originalEmail;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : mailFolder
     */
    protected MailFolder mailFolder;

    /**
     * Nom de l'attribut en BD : attachment
     */
    protected Collection<Attachment> attachment;

    /**
     * Nom de l'attribut en BD : demandType
     */
    protected DemandType demandType;

    /**
     * Nom de l'attribut en BD : priority
     */
    protected Priority priority;

    /**
     * Nom de l'attribut en BD : history
     */
    protected Collection<History> history;

    /**
     * Nom de l'attribut en BD : etatAttente
     */
    protected EtatAttente etatAttente;

    /**
     * Nom de l'attribut en BD : takenBy
     */
    protected FaxToMailUser takenBy;

    /**
     * Nom de l'attribut en BD : rangeRow
     */
    protected Collection<RangeRow> rangeRow;

    /**
     * Nom de l'attribut en BD : client
     */
    protected Client client;

    /**
     * Nom de l'attribut en BD : demandStatus
     */
    protected DemandStatus demandStatus;

    /**
     * Nom de l'attribut en BD : emailGroup
     */
    protected EmailGroup emailGroup;

    /**
     * Nom de l'attribut en BD : replies
     */
    protected Collection<Reply> replies;

    private static final long serialVersionUID = 3977302110440272435L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_RECEPTION_DATE, Date.class, receptionDate);
        visitor.visit(this, PROPERTY_EDI_CODE_NUMBER, String.class, ediCodeNumber);
        visitor.visit(this, PROPERTY_PROJECT_REFERENCE, String.class, projectReference);
        visitor.visit(this, PROPERTY_SENDER, String.class, sender);
        visitor.visit(this, PROPERTY_FAX, boolean.class, fax);
        visitor.visit(this, PROPERTY_RECIPIENT, String.class, recipient);
        visitor.visit(this, PROPERTY_OBJECT, String.class, object);
        visitor.visit(this, PROPERTY_ARCHIVE_DATE, Date.class, archiveDate);
        visitor.visit(this, PROPERTY_COMPANY_REFERENCE, String.class, companyReference);
        visitor.visit(this, PROPERTY_ORIGINAL_EMAIL, String.class, originalEmail);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_MAIL_FOLDER, MailFolder.class, mailFolder);
        visitor.visit(this, PROPERTY_ATTACHMENT, Collection.class, Attachment.class, attachment);
        visitor.visit(this, PROPERTY_DEMAND_TYPE, DemandType.class, demandType);
        visitor.visit(this, PROPERTY_PRIORITY, Priority.class, priority);
        visitor.visit(this, PROPERTY_HISTORY, Collection.class, History.class, history);
        visitor.visit(this, PROPERTY_ETAT_ATTENTE, EtatAttente.class, etatAttente);
        visitor.visit(this, PROPERTY_TAKEN_BY, FaxToMailUser.class, takenBy);
        visitor.visit(this, PROPERTY_RANGE_ROW, Collection.class, RangeRow.class, rangeRow);
        visitor.visit(this, PROPERTY_CLIENT, Client.class, client);
        visitor.visit(this, PROPERTY_DEMAND_STATUS, DemandStatus.class, demandStatus);
        visitor.visit(this, PROPERTY_EMAIL_GROUP, EmailGroup.class, emailGroup);
        visitor.visit(this, PROPERTY_REPLIES, Collection.class, Reply.class, replies);
        visitor.end(this);
    }

    @Override
    public void setReceptionDate(Date receptionDate) {
        Date oldValue = this.receptionDate;
        fireOnPreWrite(PROPERTY_RECEPTION_DATE, oldValue, receptionDate);
        this.receptionDate = receptionDate;
        fireOnPostWrite(PROPERTY_RECEPTION_DATE, oldValue, receptionDate);
    }

    @Override
    public Date getReceptionDate() {
        fireOnPreRead(PROPERTY_RECEPTION_DATE, receptionDate);
        Date result = this.receptionDate;
        fireOnPostRead(PROPERTY_RECEPTION_DATE, receptionDate);
        return result;
    }

    @Override
    public void setEdiCodeNumber(String ediCodeNumber) {
        String oldValue = this.ediCodeNumber;
        fireOnPreWrite(PROPERTY_EDI_CODE_NUMBER, oldValue, ediCodeNumber);
        this.ediCodeNumber = ediCodeNumber;
        fireOnPostWrite(PROPERTY_EDI_CODE_NUMBER, oldValue, ediCodeNumber);
    }

    @Override
    public String getEdiCodeNumber() {
        fireOnPreRead(PROPERTY_EDI_CODE_NUMBER, ediCodeNumber);
        String result = this.ediCodeNumber;
        fireOnPostRead(PROPERTY_EDI_CODE_NUMBER, ediCodeNumber);
        return result;
    }

    @Override
    public void setProjectReference(String projectReference) {
        String oldValue = this.projectReference;
        fireOnPreWrite(PROPERTY_PROJECT_REFERENCE, oldValue, projectReference);
        this.projectReference = projectReference;
        fireOnPostWrite(PROPERTY_PROJECT_REFERENCE, oldValue, projectReference);
    }

    @Override
    public String getProjectReference() {
        fireOnPreRead(PROPERTY_PROJECT_REFERENCE, projectReference);
        String result = this.projectReference;
        fireOnPostRead(PROPERTY_PROJECT_REFERENCE, projectReference);
        return result;
    }

    @Override
    public void setSender(String sender) {
        String oldValue = this.sender;
        fireOnPreWrite(PROPERTY_SENDER, oldValue, sender);
        this.sender = sender;
        fireOnPostWrite(PROPERTY_SENDER, oldValue, sender);
    }

    @Override
    public String getSender() {
        fireOnPreRead(PROPERTY_SENDER, sender);
        String result = this.sender;
        fireOnPostRead(PROPERTY_SENDER, sender);
        return result;
    }

    @Override
    public void setFax(boolean fax) {
        boolean oldValue = this.fax;
        fireOnPreWrite(PROPERTY_FAX, oldValue, fax);
        this.fax = fax;
        fireOnPostWrite(PROPERTY_FAX, oldValue, fax);
    }

    @Override
    public boolean isFax() {
        fireOnPreRead(PROPERTY_FAX, fax);
        boolean result = this.fax;
        fireOnPostRead(PROPERTY_FAX, fax);
        return result;
    }

    @Override
    public boolean getFax() {
        fireOnPreRead(PROPERTY_FAX, fax);
        boolean result = this.fax;
        fireOnPostRead(PROPERTY_FAX, fax);
        return result;
    }

    @Override
    public void setRecipient(String recipient) {
        String oldValue = this.recipient;
        fireOnPreWrite(PROPERTY_RECIPIENT, oldValue, recipient);
        this.recipient = recipient;
        fireOnPostWrite(PROPERTY_RECIPIENT, oldValue, recipient);
    }

    @Override
    public String getRecipient() {
        fireOnPreRead(PROPERTY_RECIPIENT, recipient);
        String result = this.recipient;
        fireOnPostRead(PROPERTY_RECIPIENT, recipient);
        return result;
    }

    @Override
    public void setObject(String object) {
        String oldValue = this.object;
        fireOnPreWrite(PROPERTY_OBJECT, oldValue, object);
        this.object = object;
        fireOnPostWrite(PROPERTY_OBJECT, oldValue, object);
    }

    @Override
    public String getObject() {
        fireOnPreRead(PROPERTY_OBJECT, object);
        String result = this.object;
        fireOnPostRead(PROPERTY_OBJECT, object);
        return result;
    }

    @Override
    public void setArchiveDate(Date archiveDate) {
        Date oldValue = this.archiveDate;
        fireOnPreWrite(PROPERTY_ARCHIVE_DATE, oldValue, archiveDate);
        this.archiveDate = archiveDate;
        fireOnPostWrite(PROPERTY_ARCHIVE_DATE, oldValue, archiveDate);
    }

    @Override
    public Date getArchiveDate() {
        fireOnPreRead(PROPERTY_ARCHIVE_DATE, archiveDate);
        Date result = this.archiveDate;
        fireOnPostRead(PROPERTY_ARCHIVE_DATE, archiveDate);
        return result;
    }

    @Override
    public void setCompanyReference(String companyReference) {
        String oldValue = this.companyReference;
        fireOnPreWrite(PROPERTY_COMPANY_REFERENCE, oldValue, companyReference);
        this.companyReference = companyReference;
        fireOnPostWrite(PROPERTY_COMPANY_REFERENCE, oldValue, companyReference);
    }

    @Override
    public String getCompanyReference() {
        fireOnPreRead(PROPERTY_COMPANY_REFERENCE, companyReference);
        String result = this.companyReference;
        fireOnPostRead(PROPERTY_COMPANY_REFERENCE, companyReference);
        return result;
    }

    @Override
    public void setOriginalEmail(String originalEmail) {
        String oldValue = this.originalEmail;
        fireOnPreWrite(PROPERTY_ORIGINAL_EMAIL, oldValue, originalEmail);
        this.originalEmail = originalEmail;
        fireOnPostWrite(PROPERTY_ORIGINAL_EMAIL, oldValue, originalEmail);
    }

    @Override
    public String getOriginalEmail() {
        fireOnPreRead(PROPERTY_ORIGINAL_EMAIL, originalEmail);
        String result = this.originalEmail;
        fireOnPostRead(PROPERTY_ORIGINAL_EMAIL, originalEmail);
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        fireOnPreRead(PROPERTY_COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(PROPERTY_COMMENT, comment);
        return result;
    }

    @Override
    public void setMailFolder(MailFolder mailFolder) {
        MailFolder oldValue = this.mailFolder;
        fireOnPreWrite(PROPERTY_MAIL_FOLDER, oldValue, mailFolder);
        this.mailFolder = mailFolder;
        fireOnPostWrite(PROPERTY_MAIL_FOLDER, oldValue, mailFolder);
    }

    @Override
    public MailFolder getMailFolder() {
        fireOnPreRead(PROPERTY_MAIL_FOLDER, mailFolder);
        MailFolder result = this.mailFolder;
        fireOnPostRead(PROPERTY_MAIL_FOLDER, mailFolder);
        return result;
    }

    @Override
    public void addAttachment(Attachment attachment) {
        fireOnPreWrite(PROPERTY_ATTACHMENT, null, attachment);
        if (this.attachment == null) {
            this.attachment = new LinkedList<Attachment>();
        }

        this.attachment.add(attachment);
        fireOnPostWrite(PROPERTY_ATTACHMENT, this.attachment.size(), null, attachment);
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachment) {
        if (attachment == null) {
            return;
        }
        for (Attachment item : attachment) {
            addAttachment(item);
        }
    }

    @Override
    public void setAttachment(Collection<Attachment> attachment) {
        // Copy elements to keep data for fire with new reference
        Collection<Attachment> oldValue = this.attachment != null ? new LinkedList<Attachment>(this.attachment) : null;
        fireOnPreWrite(PROPERTY_ATTACHMENT, oldValue, attachment);
        this.attachment = attachment;
        fireOnPostWrite(PROPERTY_ATTACHMENT, oldValue, attachment);
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        fireOnPreWrite(PROPERTY_ATTACHMENT, attachment, null);
        if (this.attachment == null || !this.attachment.remove(attachment)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_ATTACHMENT, this.attachment.size() + 1, attachment, null);
    }

    @Override
    public void clearAttachment() {
        if (this.attachment == null) {
            return;
        }
        Collection<Attachment> oldValue = new LinkedList<Attachment>(this.attachment);
        fireOnPreWrite(PROPERTY_ATTACHMENT, oldValue, this.attachment);
        this.attachment.clear();
        fireOnPostWrite(PROPERTY_ATTACHMENT, oldValue, this.attachment);
    }

    @Override
    public Collection<Attachment> getAttachment() {
        return attachment;
    }

    @Override
    public Attachment getAttachmentByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(attachment, topiaId);
    }

    @Override
    public Collection<String> getAttachmentTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.Attachment> tmp = getAttachment();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeAttachment() {
        if (attachment == null) {
            return 0;
        }
        return attachment.size();
    }

    @Override
    public boolean isAttachmentEmpty() {
        int size = sizeAttachment();
        return size == 0;
    }

    @Override
    public boolean isAttachmentNotEmpty() {
        boolean empty = isAttachmentEmpty();
        return ! empty;
    }

    @Override
    public boolean containsAttachment(Attachment attachment) {
        boolean contains = this.attachment !=null && this.attachment.contains(attachment);
        return contains;
    }

    @Override
    public void setDemandType(DemandType demandType) {
        DemandType oldValue = this.demandType;
        fireOnPreWrite(PROPERTY_DEMAND_TYPE, oldValue, demandType);
        this.demandType = demandType;
        fireOnPostWrite(PROPERTY_DEMAND_TYPE, oldValue, demandType);
    }

    @Override
    public DemandType getDemandType() {
        fireOnPreRead(PROPERTY_DEMAND_TYPE, demandType);
        DemandType result = this.demandType;
        fireOnPostRead(PROPERTY_DEMAND_TYPE, demandType);
        return result;
    }

    @Override
    public void setPriority(Priority priority) {
        Priority oldValue = this.priority;
        fireOnPreWrite(PROPERTY_PRIORITY, oldValue, priority);
        this.priority = priority;
        fireOnPostWrite(PROPERTY_PRIORITY, oldValue, priority);
    }

    @Override
    public Priority getPriority() {
        fireOnPreRead(PROPERTY_PRIORITY, priority);
        Priority result = this.priority;
        fireOnPostRead(PROPERTY_PRIORITY, priority);
        return result;
    }

    @Override
    public void addHistory(History history) {
        fireOnPreWrite(PROPERTY_HISTORY, null, history);
        if (this.history == null) {
            this.history = new LinkedList<History>();
        }

        this.history.add(history);
        fireOnPostWrite(PROPERTY_HISTORY, this.history.size(), null, history);
    }

    @Override
    public void addAllHistory(Collection<History> history) {
        if (history == null) {
            return;
        }
        for (History item : history) {
            addHistory(item);
        }
    }

    @Override
    public void setHistory(Collection<History> history) {
        // Copy elements to keep data for fire with new reference
        Collection<History> oldValue = this.history != null ? new LinkedList<History>(this.history) : null;
        fireOnPreWrite(PROPERTY_HISTORY, oldValue, history);
        this.history = history;
        fireOnPostWrite(PROPERTY_HISTORY, oldValue, history);
    }

    @Override
    public void removeHistory(History history) {
        fireOnPreWrite(PROPERTY_HISTORY, history, null);
        if (this.history == null || !this.history.remove(history)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_HISTORY, this.history.size() + 1, history, null);
    }

    @Override
    public void clearHistory() {
        if (this.history == null) {
            return;
        }
        Collection<History> oldValue = new LinkedList<History>(this.history);
        fireOnPreWrite(PROPERTY_HISTORY, oldValue, this.history);
        this.history.clear();
        fireOnPostWrite(PROPERTY_HISTORY, oldValue, this.history);
    }

    @Override
    public Collection<History> getHistory() {
        return history;
    }

    @Override
    public History getHistoryByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(history, topiaId);
    }

    @Override
    public Collection<String> getHistoryTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.History> tmp = getHistory();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeHistory() {
        if (history == null) {
            return 0;
        }
        return history.size();
    }

    @Override
    public boolean isHistoryEmpty() {
        int size = sizeHistory();
        return size == 0;
    }

    @Override
    public boolean isHistoryNotEmpty() {
        boolean empty = isHistoryEmpty();
        return ! empty;
    }

    @Override
    public boolean containsHistory(History history) {
        boolean contains = this.history !=null && this.history.contains(history);
        return contains;
    }

    @Override
    public void setEtatAttente(EtatAttente etatAttente) {
        EtatAttente oldValue = this.etatAttente;
        fireOnPreWrite(PROPERTY_ETAT_ATTENTE, oldValue, etatAttente);
        this.etatAttente = etatAttente;
        fireOnPostWrite(PROPERTY_ETAT_ATTENTE, oldValue, etatAttente);
    }

    @Override
    public EtatAttente getEtatAttente() {
        fireOnPreRead(PROPERTY_ETAT_ATTENTE, etatAttente);
        EtatAttente result = this.etatAttente;
        fireOnPostRead(PROPERTY_ETAT_ATTENTE, etatAttente);
        return result;
    }

    @Override
    public void setTakenBy(FaxToMailUser takenBy) {
        FaxToMailUser oldValue = this.takenBy;
        fireOnPreWrite(PROPERTY_TAKEN_BY, oldValue, takenBy);
        this.takenBy = takenBy;
        fireOnPostWrite(PROPERTY_TAKEN_BY, oldValue, takenBy);
    }

    @Override
    public FaxToMailUser getTakenBy() {
        fireOnPreRead(PROPERTY_TAKEN_BY, takenBy);
        FaxToMailUser result = this.takenBy;
        fireOnPostRead(PROPERTY_TAKEN_BY, takenBy);
        return result;
    }

    @Override
    public void addRangeRow(RangeRow rangeRow) {
        fireOnPreWrite(PROPERTY_RANGE_ROW, null, rangeRow);
        if (this.rangeRow == null) {
            this.rangeRow = new LinkedList<RangeRow>();
        }

        this.rangeRow.add(rangeRow);
        fireOnPostWrite(PROPERTY_RANGE_ROW, this.rangeRow.size(), null, rangeRow);
    }

    @Override
    public void addAllRangeRow(Collection<RangeRow> rangeRow) {
        if (rangeRow == null) {
            return;
        }
        for (RangeRow item : rangeRow) {
            addRangeRow(item);
        }
    }

    @Override
    public void setRangeRow(Collection<RangeRow> rangeRow) {
        // Copy elements to keep data for fire with new reference
        Collection<RangeRow> oldValue = this.rangeRow != null ? new LinkedList<RangeRow>(this.rangeRow) : null;
        fireOnPreWrite(PROPERTY_RANGE_ROW, oldValue, rangeRow);
        this.rangeRow = rangeRow;
        fireOnPostWrite(PROPERTY_RANGE_ROW, oldValue, rangeRow);
    }

    @Override
    public void removeRangeRow(RangeRow rangeRow) {
        fireOnPreWrite(PROPERTY_RANGE_ROW, rangeRow, null);
        if (this.rangeRow == null || !this.rangeRow.remove(rangeRow)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_RANGE_ROW, this.rangeRow.size() + 1, rangeRow, null);
    }

    @Override
    public void clearRangeRow() {
        if (this.rangeRow == null) {
            return;
        }
        Collection<RangeRow> oldValue = new LinkedList<RangeRow>(this.rangeRow);
        fireOnPreWrite(PROPERTY_RANGE_ROW, oldValue, this.rangeRow);
        this.rangeRow.clear();
        fireOnPostWrite(PROPERTY_RANGE_ROW, oldValue, this.rangeRow);
    }

    @Override
    public Collection<RangeRow> getRangeRow() {
        return rangeRow;
    }

    @Override
    public RangeRow getRangeRowByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(rangeRow, topiaId);
    }

    @Override
    public Collection<String> getRangeRowTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.RangeRow> tmp = getRangeRow();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeRangeRow() {
        if (rangeRow == null) {
            return 0;
        }
        return rangeRow.size();
    }

    @Override
    public boolean isRangeRowEmpty() {
        int size = sizeRangeRow();
        return size == 0;
    }

    @Override
    public boolean isRangeRowNotEmpty() {
        boolean empty = isRangeRowEmpty();
        return ! empty;
    }

    @Override
    public boolean containsRangeRow(RangeRow rangeRow) {
        boolean contains = this.rangeRow !=null && this.rangeRow.contains(rangeRow);
        return contains;
    }

    @Override
    public void setClient(Client client) {
        Client oldValue = this.client;
        fireOnPreWrite(PROPERTY_CLIENT, oldValue, client);
        this.client = client;
        fireOnPostWrite(PROPERTY_CLIENT, oldValue, client);
    }

    @Override
    public Client getClient() {
        fireOnPreRead(PROPERTY_CLIENT, client);
        Client result = this.client;
        fireOnPostRead(PROPERTY_CLIENT, client);
        return result;
    }

    @Override
    public void setDemandStatus(DemandStatus demandStatus) {
        DemandStatus oldValue = this.demandStatus;
        fireOnPreWrite(PROPERTY_DEMAND_STATUS, oldValue, demandStatus);
        this.demandStatus = demandStatus;
        fireOnPostWrite(PROPERTY_DEMAND_STATUS, oldValue, demandStatus);
    }

    @Override
    public DemandStatus getDemandStatus() {
        fireOnPreRead(PROPERTY_DEMAND_STATUS, demandStatus);
        DemandStatus result = this.demandStatus;
        fireOnPostRead(PROPERTY_DEMAND_STATUS, demandStatus);
        return result;
    }

    @Override
    public void setEmailGroup(EmailGroup emailGroup) {
        EmailGroup oldValue = this.emailGroup;
        fireOnPreWrite(PROPERTY_EMAIL_GROUP, oldValue, emailGroup);
        this.emailGroup = emailGroup;
        fireOnPostWrite(PROPERTY_EMAIL_GROUP, oldValue, emailGroup);
    }

    @Override
    public EmailGroup getEmailGroup() {
        fireOnPreRead(PROPERTY_EMAIL_GROUP, emailGroup);
        EmailGroup result = this.emailGroup;
        fireOnPostRead(PROPERTY_EMAIL_GROUP, emailGroup);
        return result;
    }

    @Override
    public void addReplies(Reply replies) {
        fireOnPreWrite(PROPERTY_REPLIES, null, replies);
        if (this.replies == null) {
            this.replies = new LinkedList<Reply>();
        }

        this.replies.add(replies);
        fireOnPostWrite(PROPERTY_REPLIES, this.replies.size(), null, replies);
    }

    @Override
    public void addAllReplies(Collection<Reply> replies) {
        if (replies == null) {
            return;
        }
        for (Reply item : replies) {
            addReplies(item);
        }
    }

    @Override
    public void setReplies(Collection<Reply> replies) {
        // Copy elements to keep data for fire with new reference
        Collection<Reply> oldValue = this.replies != null ? new LinkedList<Reply>(this.replies) : null;
        fireOnPreWrite(PROPERTY_REPLIES, oldValue, replies);
        this.replies = replies;
        fireOnPostWrite(PROPERTY_REPLIES, oldValue, replies);
    }

    @Override
    public void removeReplies(Reply replies) {
        fireOnPreWrite(PROPERTY_REPLIES, replies, null);
        if (this.replies == null || !this.replies.remove(replies)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_REPLIES, this.replies.size() + 1, replies, null);
    }

    @Override
    public void clearReplies() {
        if (this.replies == null) {
            return;
        }
        Collection<Reply> oldValue = new LinkedList<Reply>(this.replies);
        fireOnPreWrite(PROPERTY_REPLIES, oldValue, this.replies);
        this.replies.clear();
        fireOnPostWrite(PROPERTY_REPLIES, oldValue, this.replies);
    }

    @Override
    public Collection<Reply> getReplies() {
        return replies;
    }

    @Override
    public Reply getRepliesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(replies, topiaId);
    }

    @Override
    public Collection<String> getRepliesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.Reply> tmp = getReplies();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeReplies() {
        if (replies == null) {
            return 0;
        }
        return replies.size();
    }

    @Override
    public boolean isRepliesEmpty() {
        int size = sizeReplies();
        return size == 0;
    }

    @Override
    public boolean isRepliesNotEmpty() {
        boolean empty = isRepliesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsReplies(Reply replies) {
        boolean contains = this.replies !=null && this.replies.contains(replies);
        return contains;
    }

} //EmailAbstract
