package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Tue Jun 10 11:30:03 CEST 2014")
public abstract class ConfigurationAbstract extends AbstractTopiaEntity implements Configuration {

    /**
     * size in bytes
     * Nom de l'attribut en BD : emailMaxSize
     */
    protected long emailMaxSize;

    /**
     * Nom de l'attribut en BD : searchDisplayColumns
     */
    protected List<MailField> searchDisplayColumns;

    /**
     * Nom de l'attribut en BD : extensionCommands
     */
    protected Collection<ExtensionCommand> extensionCommands;

    /**
     * Nom de l'attribut en BD : chefs
     */
    protected Collection<GroupChef> chefs;

    private static final long serialVersionUID = 4122259729876739426L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_EMAIL_MAX_SIZE, long.class, emailMaxSize);
        visitor.visit(this, PROPERTY_SEARCH_DISPLAY_COLUMNS, List.class, MailField.class, searchDisplayColumns);
        visitor.visit(this, PROPERTY_EXTENSION_COMMANDS, Collection.class, ExtensionCommand.class, extensionCommands);
        visitor.visit(this, PROPERTY_CHEFS, Collection.class, GroupChef.class, chefs);
        visitor.end(this);
    }

    @Override
    public void setEmailMaxSize(long emailMaxSize) {
        long oldValue = this.emailMaxSize;
        fireOnPreWrite(PROPERTY_EMAIL_MAX_SIZE, oldValue, emailMaxSize);
        this.emailMaxSize = emailMaxSize;
        fireOnPostWrite(PROPERTY_EMAIL_MAX_SIZE, oldValue, emailMaxSize);
    }

    @Override
    public long getEmailMaxSize() {
        fireOnPreRead(PROPERTY_EMAIL_MAX_SIZE, emailMaxSize);
        long result = this.emailMaxSize;
        fireOnPostRead(PROPERTY_EMAIL_MAX_SIZE, emailMaxSize);
        return result;
    }

    @Override
    public void addSearchDisplayColumns(MailField searchDisplayColumns) {
        fireOnPreWrite(PROPERTY_SEARCH_DISPLAY_COLUMNS, null, searchDisplayColumns);
        if (this.searchDisplayColumns == null) {
            this.searchDisplayColumns = new LinkedList<MailField>();
        }

        this.searchDisplayColumns.add(searchDisplayColumns);
        fireOnPostWrite(PROPERTY_SEARCH_DISPLAY_COLUMNS, this.searchDisplayColumns.size(), null, searchDisplayColumns);
    }

    @Override
    public void addSearchDisplayColumns(int index, MailField searchDisplayColumns) {
        fireOnPreWrite(PROPERTY_SEARCH_DISPLAY_COLUMNS, null, searchDisplayColumns);
        if (this.searchDisplayColumns == null) {
            this.searchDisplayColumns = new LinkedList<MailField>();
        }

        this.searchDisplayColumns.add(index, searchDisplayColumns);
        fireOnPostWrite(PROPERTY_SEARCH_DISPLAY_COLUMNS, index, null, searchDisplayColumns);
    }

    @Override
    public void addAllSearchDisplayColumns(List<MailField> searchDisplayColumns) {
        if (searchDisplayColumns == null) {
            return;
        }
        for (MailField item : searchDisplayColumns) {
            addSearchDisplayColumns(item);
        }
    }

    @Override
    public void setSearchDisplayColumns(List<MailField> searchDisplayColumns) {
        // Copy elements to keep data for fire with new reference
        List<MailField> oldValue = this.searchDisplayColumns != null ? new LinkedList<MailField>(this.searchDisplayColumns) : null;
        fireOnPreWrite(PROPERTY_SEARCH_DISPLAY_COLUMNS, oldValue, searchDisplayColumns);
        this.searchDisplayColumns = searchDisplayColumns;
        fireOnPostWrite(PROPERTY_SEARCH_DISPLAY_COLUMNS, oldValue, searchDisplayColumns);
    }

    @Override
    public void removeSearchDisplayColumns(MailField searchDisplayColumns) {
        fireOnPreWrite(PROPERTY_SEARCH_DISPLAY_COLUMNS, searchDisplayColumns, null);
        if (this.searchDisplayColumns == null || !this.searchDisplayColumns.remove(searchDisplayColumns)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_SEARCH_DISPLAY_COLUMNS, this.searchDisplayColumns.size() + 1, searchDisplayColumns, null);
    }

    @Override
    public void removeSearchDisplayColumns(int index) {
        fireOnPreWrite(PROPERTY_SEARCH_DISPLAY_COLUMNS, searchDisplayColumns, null);
        if (this.searchDisplayColumns == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        MailField oldValue = this.searchDisplayColumns.remove(index);
        if (oldValue == null) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_SEARCH_DISPLAY_COLUMNS, index, oldValue, null);
    }

    @Override
    public void clearSearchDisplayColumns() {
        if (this.searchDisplayColumns == null) {
            return;
        }
        List<MailField> oldValue = new LinkedList<MailField>(this.searchDisplayColumns);
        fireOnPreWrite(PROPERTY_SEARCH_DISPLAY_COLUMNS, oldValue, this.searchDisplayColumns);
        this.searchDisplayColumns.clear();
        fireOnPostWrite(PROPERTY_SEARCH_DISPLAY_COLUMNS, oldValue, this.searchDisplayColumns);
    }

    @Override
    public List<MailField> getSearchDisplayColumns() {
        return searchDisplayColumns;
    }

    @Override
    public MailField getSearchDisplayColumns(int index) {
        return TopiaEntityHelper.getEntityByIndex(searchDisplayColumns, index);
    }

    @Override
    public int sizeSearchDisplayColumns() {
        if (searchDisplayColumns == null) {
            return 0;
        }
        return searchDisplayColumns.size();
    }

    @Override
    public boolean isSearchDisplayColumnsEmpty() {
        int size = sizeSearchDisplayColumns();
        return size == 0;
    }

    @Override
    public boolean isSearchDisplayColumnsNotEmpty() {
        boolean empty = isSearchDisplayColumnsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsSearchDisplayColumns(MailField searchDisplayColumns) {
        boolean contains = this.searchDisplayColumns !=null && this.searchDisplayColumns.contains(searchDisplayColumns);
        return contains;
    }

    @Override
    public void addExtensionCommands(ExtensionCommand extensionCommands) {
        fireOnPreWrite(PROPERTY_EXTENSION_COMMANDS, null, extensionCommands);
        if (this.extensionCommands == null) {
            this.extensionCommands = new LinkedList<ExtensionCommand>();
        }

        this.extensionCommands.add(extensionCommands);
        fireOnPostWrite(PROPERTY_EXTENSION_COMMANDS, this.extensionCommands.size(), null, extensionCommands);
    }

    @Override
    public void addAllExtensionCommands(Collection<ExtensionCommand> extensionCommands) {
        if (extensionCommands == null) {
            return;
        }
        for (ExtensionCommand item : extensionCommands) {
            addExtensionCommands(item);
        }
    }

    @Override
    public void setExtensionCommands(Collection<ExtensionCommand> extensionCommands) {
        // Copy elements to keep data for fire with new reference
        Collection<ExtensionCommand> oldValue = this.extensionCommands != null ? new LinkedList<ExtensionCommand>(this.extensionCommands) : null;
        fireOnPreWrite(PROPERTY_EXTENSION_COMMANDS, oldValue, extensionCommands);
        this.extensionCommands = extensionCommands;
        fireOnPostWrite(PROPERTY_EXTENSION_COMMANDS, oldValue, extensionCommands);
    }

    @Override
    public void removeExtensionCommands(ExtensionCommand extensionCommands) {
        fireOnPreWrite(PROPERTY_EXTENSION_COMMANDS, extensionCommands, null);
        if (this.extensionCommands == null || !this.extensionCommands.remove(extensionCommands)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_EXTENSION_COMMANDS, this.extensionCommands.size() + 1, extensionCommands, null);
    }

    @Override
    public void clearExtensionCommands() {
        if (this.extensionCommands == null) {
            return;
        }
        Collection<ExtensionCommand> oldValue = new LinkedList<ExtensionCommand>(this.extensionCommands);
        fireOnPreWrite(PROPERTY_EXTENSION_COMMANDS, oldValue, this.extensionCommands);
        this.extensionCommands.clear();
        fireOnPostWrite(PROPERTY_EXTENSION_COMMANDS, oldValue, this.extensionCommands);
    }

    @Override
    public Collection<ExtensionCommand> getExtensionCommands() {
        return extensionCommands;
    }

    @Override
    public ExtensionCommand getExtensionCommandsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(extensionCommands, topiaId);
    }

    @Override
    public Collection<String> getExtensionCommandsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.ExtensionCommand> tmp = getExtensionCommands();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeExtensionCommands() {
        if (extensionCommands == null) {
            return 0;
        }
        return extensionCommands.size();
    }

    @Override
    public boolean isExtensionCommandsEmpty() {
        int size = sizeExtensionCommands();
        return size == 0;
    }

    @Override
    public boolean isExtensionCommandsNotEmpty() {
        boolean empty = isExtensionCommandsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsExtensionCommands(ExtensionCommand extensionCommands) {
        boolean contains = this.extensionCommands !=null && this.extensionCommands.contains(extensionCommands);
        return contains;
    }

    @Override
    public void addChefs(GroupChef chefs) {
        fireOnPreWrite(PROPERTY_CHEFS, null, chefs);
        if (this.chefs == null) {
            this.chefs = new LinkedList<GroupChef>();
        }

        this.chefs.add(chefs);
        fireOnPostWrite(PROPERTY_CHEFS, this.chefs.size(), null, chefs);
    }

    @Override
    public void addAllChefs(Collection<GroupChef> chefs) {
        if (chefs == null) {
            return;
        }
        for (GroupChef item : chefs) {
            addChefs(item);
        }
    }

    @Override
    public void setChefs(Collection<GroupChef> chefs) {
        // Copy elements to keep data for fire with new reference
        Collection<GroupChef> oldValue = this.chefs != null ? new LinkedList<GroupChef>(this.chefs) : null;
        fireOnPreWrite(PROPERTY_CHEFS, oldValue, chefs);
        this.chefs = chefs;
        fireOnPostWrite(PROPERTY_CHEFS, oldValue, chefs);
    }

    @Override
    public void removeChefs(GroupChef chefs) {
        fireOnPreWrite(PROPERTY_CHEFS, chefs, null);
        if (this.chefs == null || !this.chefs.remove(chefs)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_CHEFS, this.chefs.size() + 1, chefs, null);
    }

    @Override
    public void clearChefs() {
        if (this.chefs == null) {
            return;
        }
        Collection<GroupChef> oldValue = new LinkedList<GroupChef>(this.chefs);
        fireOnPreWrite(PROPERTY_CHEFS, oldValue, this.chefs);
        this.chefs.clear();
        fireOnPostWrite(PROPERTY_CHEFS, oldValue, this.chefs);
    }

    @Override
    public Collection<GroupChef> getChefs() {
        return chefs;
    }

    @Override
    public GroupChef getChefsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(chefs, topiaId);
    }

    @Override
    public Collection<String> getChefsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.GroupChef> tmp = getChefs();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeChefs() {
        if (chefs == null) {
            return 0;
        }
        return chefs.size();
    }

    @Override
    public boolean isChefsEmpty() {
        int size = sizeChefs();
        return size == 0;
    }

    @Override
    public boolean isChefsNotEmpty() {
        boolean empty = isChefsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsChefs(GroupChef chefs) {
        boolean contains = this.chefs !=null && this.chefs.contains(chefs);
        return contains;
    }

} //ConfigurationAbstract
