/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.impl.AnyReader;
import com.fasterxml.jackson.jr.ob.impl.ArrayReader;
import com.fasterxml.jackson.jr.ob.impl.BeanDefinition;
import com.fasterxml.jackson.jr.ob.impl.BeanProperty;
import com.fasterxml.jackson.jr.ob.impl.ClassKey;
import com.fasterxml.jackson.jr.ob.impl.CollectionReader;
import com.fasterxml.jackson.jr.ob.impl.EnumReader;
import com.fasterxml.jackson.jr.ob.impl.MapReader;
import com.fasterxml.jackson.jr.ob.impl.SimpleValueReader;
import com.fasterxml.jackson.jr.ob.impl.ValueReader;
import com.fasterxml.jackson.jr.type.ResolvedType;
import com.fasterxml.jackson.jr.type.TypeBindings;
import com.fasterxml.jackson.jr.type.TypeResolver;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class TypeDetector {
    protected final BeanProperty[] NO_PROPS = new BeanProperty[0];
    public static final int SER_UNKNOWN = 0;
    public static final int SER_MAP = 1;
    public static final int SER_LIST = 2;
    public static final int SER_COLLECTION = 3;
    public static final int SER_OBJECT_ARRAY = 4;
    public static final int SER_INT_ARRAY = 5;
    public static final int SER_LONG_ARRAY = 6;
    public static final int SER_BOOLEAN_ARRAY = 7;
    public static final int SER_TREE_NODE = 8;
    public static final int SER_STRING = 9;
    public static final int SER_CHARACTER_SEQUENCE = 10;
    public static final int SER_CHAR_ARRAY = 11;
    public static final int SER_BYTE_ARRAY = 12;
    public static final int SER_NUMBER_BYTE = 13;
    public static final int SER_NUMBER_SHORT = 14;
    public static final int SER_NUMBER_INTEGER = 15;
    public static final int SER_NUMBER_LONG = 16;
    public static final int SER_NUMBER_FLOAT = 17;
    public static final int SER_NUMBER_DOUBLE = 18;
    public static final int SER_NUMBER_BIG_INTEGER = 19;
    public static final int SER_NUMBER_BIG_DECIMAL = 20;
    public static final int SER_BOOLEAN = 21;
    public static final int SER_CHAR = 22;
    public static final int SER_ENUM = 23;
    public static final int SER_DATE = 24;
    public static final int SER_CALENDAR = 25;
    public static final int SER_CLASS = 26;
    public static final int SER_FILE = 27;
    public static final int SER_UUID = 28;
    public static final int SER_URL = 29;
    public static final int SER_URI = 30;
    public static final int SER_ITERABLE = 31;
    protected final ConcurrentHashMap<ClassKey, Integer> _knownSerTypes;
    protected final CopyOnWriteArrayList<BeanDefinition> _knownBeans;
    protected final TypeResolver _typeResolver;
    protected final ConcurrentHashMap<ClassKey, ValueReader> _knownReaders;
    protected Map<ClassKey, ValueReader> _incompleteReaders;
    protected final Object _readerLock;
    protected ClassKey _key = new ClassKey();
    protected Class<?> _prevClass;
    protected int _prevType;
    protected int _features;

    protected TypeDetector(int n, ConcurrentHashMap<ClassKey, Integer> concurrentHashMap, CopyOnWriteArrayList<BeanDefinition> copyOnWriteArrayList) {
        this._features = n;
        this._knownSerTypes = concurrentHashMap;
        this._knownBeans = copyOnWriteArrayList;
        this._knownReaders = null;
        this._typeResolver = null;
        this._readerLock = null;
    }

    protected TypeDetector(int n, ConcurrentHashMap<ClassKey, ValueReader> concurrentHashMap) {
        this._features = n;
        this._knownSerTypes = null;
        this._knownBeans = null;
        this._knownReaders = concurrentHashMap;
        this._typeResolver = new TypeResolver();
        this._readerLock = new Object();
    }

    protected TypeDetector(TypeDetector typeDetector, int n) {
        this._features = n;
        this._knownSerTypes = typeDetector._knownSerTypes;
        this._knownBeans = typeDetector._knownBeans;
        this._knownReaders = typeDetector._knownReaders;
        this._typeResolver = typeDetector._typeResolver;
        this._readerLock = typeDetector._readerLock;
    }

    public static final TypeDetector forReader(int n) {
        return new TypeDetector(n, new ConcurrentHashMap<ClassKey, ValueReader>(50, 0.75f, 4));
    }

    public static final TypeDetector forWriter(int n) {
        return new TypeDetector(n, new ConcurrentHashMap<ClassKey, Integer>(50, 0.75f, 4), new CopyOnWriteArrayList<BeanDefinition>());
    }

    public TypeDetector perOperationInstance(int n) {
        return new TypeDetector(this, n);
    }

    private boolean forSer() {
        return this._knownSerTypes != null;
    }

    /*
     * WARNING - void declaration
     */
    protected BeanDefinition resolveBean(Class<?> clazz) {
        void var7_15;
        List<BeanProperty> list;
        boolean bl = JSON.Feature.FORCE_REFLECTION_ACCESS.isEnabled(this._features);
        boolean bl2 = this.forSer();
        try {
            list = this._introspectBean(clazz, bl2, bl);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to introspect BeanInfo for type '" + clazz.getName() + "': " + exception.getMessage(), exception);
        }
        if (bl2) {
            ArrayList<BeanProperty> arrayList = new ArrayList<BeanProperty>(list.size());
            for (BeanProperty constructor3 : list) {
                BeanProperty beanPropertyArray2 = constructor3.withTypeId(this._findSimple(constructor3.rawGetterType()));
                arrayList.add(beanPropertyArray2);
            }
            int n = arrayList.size();
            BeanProperty[] beanPropertyArray = n == 0 ? this.NO_PROPS : arrayList.toArray(new BeanProperty[n]);
            return new BeanDefinition(clazz, beanPropertyArray);
        }
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        Object var7_14 = null;
        for (Constructor<?> constructor3 : clazz.getDeclaredConstructors()) {
            Class<?>[] classArray = constructor3.getParameterTypes();
            if (classArray.length == 0) {
                constructor = constructor3;
            } else {
                if (classArray.length != 1) continue;
                Class<?> clazz2 = classArray[0];
                if (clazz2 == String.class) {
                    constructor2 = constructor3;
                } else {
                    if (clazz2 != Long.class && clazz2 != Long.TYPE) continue;
                    Constructor<?> constructor4 = constructor3;
                }
            }
            if (!bl) continue;
            constructor3.setAccessible(true);
        }
        HashMap hashMap = new HashMap();
        for (BeanProperty beanProperty : list) {
            hashMap.put(beanProperty.getName().toString(), beanProperty);
        }
        return new BeanDefinition(clazz, hashMap, constructor, constructor2, (Constructor<?>)var7_15);
    }

    protected List<BeanProperty> _introspectBean(Class<?> clazz, boolean bl, boolean bl2) {
        TreeMap<String, BeanProperty> treeMap = new TreeMap<String, BeanProperty>();
        this._introspect(clazz, treeMap);
        ArrayList<BeanProperty> arrayList = new ArrayList<BeanProperty>(treeMap.size());
        for (BeanProperty beanProperty : treeMap.values()) {
            if (!bl ? !beanProperty.hasSetter() : !beanProperty.hasGetter()) continue;
            if (bl2) {
                beanProperty.forceAccess();
            }
            arrayList.add(beanProperty);
        }
        return arrayList;
    }

    protected void _introspect(Class<?> clazz, Map<String, BeanProperty> map) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        this._introspect(clazz.getSuperclass(), map);
        for (Method method : clazz.getDeclaredMethods()) {
            Object object;
            Object object2;
            int n = method.getModifiers();
            if (Modifier.isStatic(n)) continue;
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length == 0) {
                BeanProperty beanProperty;
                if (!Modifier.isPublic(n) || (object2 = method.getReturnType()) == Void.class) continue;
                object = method.getName();
                if (((String)object).startsWith("get")) {
                    if (((String)object).length() <= 3) continue;
                    object = TypeDetector.decap(((String)object).substring(3));
                    beanProperty = this._propFrom(map, (String)object);
                    map.put((String)object, beanProperty.withGetter(method));
                    continue;
                }
                if (!((String)object).startsWith("is") || ((String)object).length() <= 2 || !JSON.Feature.USE_IS_GETTERS.isEnabled(this._features) || !JSON.Feature.USE_IS_SETTERS.isEnabled(this._features)) continue;
                beanProperty = map.get(object);
                if (beanProperty == null) {
                    object = TypeDetector.decap(((String)object).substring(2));
                    map.put((String)object, new BeanProperty((String)object).withGetter(method));
                    continue;
                }
                if (beanProperty.hasGetter()) continue;
                object = TypeDetector.decap(((String)object).substring(2));
                map.put((String)object, beanProperty.withGetter(method));
                continue;
            }
            if (classArray.length != 1 || !Modifier.isPublic(n) && !JSON.Feature.FORCE_REFLECTION_ACCESS.isEnabled(this._features) || !((String)(object2 = method.getName())).startsWith("set") || ((String)object2).length() == 3) continue;
            object2 = TypeDetector.decap(((String)object2).substring(3));
            object = this._propFrom(map, (String)object2);
            map.put((String)object2, ((BeanProperty)object).withSetter(method));
        }
    }

    private BeanProperty _propFrom(Map<String, BeanProperty> map, String string) {
        BeanProperty beanProperty = map.get(string);
        if (beanProperty == null) {
            beanProperty = new BeanProperty(string);
        }
        return beanProperty;
    }

    public BeanDefinition getBeanDefinition(int n) {
        if (n < 0) {
            n = -(n + 1);
        }
        return this._knownBeans.get(n);
    }

    public final int findFullType(Class<?> clazz) {
        int n;
        if (clazz == this._prevClass) {
            return this._prevType;
        }
        ClassKey classKey = this._key.with(clazz);
        Integer n2 = this._knownSerTypes.get(classKey);
        if (n2 == null) {
            n = this._findFull(clazz);
            this._knownSerTypes.put(new ClassKey(clazz), n);
        } else {
            n = n2;
        }
        this._prevType = n;
        this._prevClass = clazz;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _findFull(Class<?> clazz) {
        int n = this._findSimple(clazz);
        if (n == 0 && JSON.Feature.HANDLE_JAVA_BEANS.isEnabled(this._features)) {
            BeanDefinition beanDefinition = this.resolveBean(clazz);
            CopyOnWriteArrayList<BeanDefinition> copyOnWriteArrayList = this._knownBeans;
            synchronized (copyOnWriteArrayList) {
                ClassKey classKey = new ClassKey(clazz);
                Integer n2 = this._knownSerTypes.get(classKey);
                if (n2 != null) {
                    return n2;
                }
                this._knownBeans.add(beanDefinition);
                int n3 = -this._knownBeans.size();
                this._knownSerTypes.put(classKey, n3);
                return n3;
            }
        }
        return n;
    }

    protected int _findSimple(Class<?> clazz) {
        if (clazz == String.class) {
            return 9;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                if (clazz == byte[].class) {
                    return 12;
                }
                if (clazz == char[].class) {
                    return 11;
                }
                if (clazz == int[].class) {
                    return 5;
                }
                if (clazz == long[].class) {
                    return 6;
                }
                if (clazz == boolean[].class) {
                    return 7;
                }
                return 0;
            }
            return 4;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return 21;
            }
            if (clazz == Integer.TYPE) {
                return 15;
            }
            if (clazz == Long.TYPE) {
                return 16;
            }
            if (clazz == Byte.TYPE) {
                return 13;
            }
            if (clazz == Short.TYPE) {
                return 14;
            }
            if (clazz == Double.TYPE) {
                return 18;
            }
            if (clazz == Float.TYPE) {
                return 17;
            }
            if (clazz == Character.TYPE) {
                return 22;
            }
            throw new IllegalArgumentException("Unrecognized primitive type: " + clazz.getName());
        }
        if (clazz == Boolean.class) {
            return 21;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if (clazz == Integer.class) {
                return 15;
            }
            if (clazz == Long.class) {
                return 16;
            }
            if (clazz == Byte.class) {
                return 13;
            }
            if (clazz == Short.class) {
                return 14;
            }
            if (clazz == Double.class) {
                return 18;
            }
            if (clazz == Float.class) {
                return 17;
            }
            if (clazz == BigDecimal.class) {
                return 20;
            }
            if (clazz == BigInteger.class) {
                return 19;
            }
            return 0;
        }
        if (clazz == Character.class) {
            return 22;
        }
        if (clazz.isEnum()) {
            return 23;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (List.class.isAssignableFrom(clazz) && RandomAccess.class.isAssignableFrom(clazz)) {
                return 2;
            }
            return 3;
        }
        if (TreeNode.class.isAssignableFrom(clazz)) {
            return 8;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return 25;
        }
        if (clazz == Class.class) {
            return 26;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return 24;
        }
        if (File.class.isAssignableFrom(clazz)) {
            return 27;
        }
        if (URL.class.isAssignableFrom(clazz)) {
            return 29;
        }
        if (URI.class.isAssignableFrom(clazz)) {
            return 30;
        }
        if (UUID.class.isAssignableFrom(clazz)) {
            return 28;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return 10;
        }
        if (this.forSer() && Iterable.class.isAssignableFrom(clazz)) {
            return 31;
        }
        return 0;
    }

    public ValueReader findReader(Class<?> clazz) {
        ClassKey classKey = this._key.with(clazz);
        ValueReader valueReader = this._knownReaders.get(classKey);
        if (valueReader != null) {
            return valueReader;
        }
        valueReader = this.createReader(null, clazz, clazz);
        this._knownReaders.putIfAbsent(new ClassKey(clazz), valueReader);
        return valueReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueReader createReader(Class<?> clazz, Class<?> clazz2, Type type) {
        if (clazz2 == Object.class) {
            return AnyReader.std;
        }
        if (clazz2.isArray()) {
            Class<?> clazz3 = clazz2.getComponentType();
            if (!clazz3.isPrimitive()) {
                return new ArrayReader(clazz3, this.createReader(clazz, clazz3, clazz3));
            }
            int n = this._findSimple(clazz2);
            if (n > 0) {
                return new SimpleValueReader(n, clazz2);
            }
            throw new IllegalArgumentException("Deserialization of " + clazz2.getName() + " not (yet) supported");
        }
        if (clazz2.isEnum()) {
            return TypeDetector.enumReader(clazz2);
        }
        if (Collection.class.isAssignableFrom(clazz2)) {
            return this.collectionReader(clazz, type);
        }
        if (Map.class.isAssignableFrom(clazz2)) {
            return this.mapReader(clazz, type);
        }
        int n = this._findSimple(clazz2);
        if (n > 0) {
            return new SimpleValueReader(n, clazz2);
        }
        ClassKey classKey = new ClassKey(clazz2);
        Object object = this._readerLock;
        synchronized (object) {
            ValueReader valueReader;
            if (this._incompleteReaders == null) {
                this._incompleteReaders = new HashMap<ClassKey, ValueReader>();
            } else {
                valueReader = this._incompleteReaders.get(new ClassKey(clazz2));
                if (valueReader != null) {
                    return valueReader;
                }
            }
            valueReader = this.resolveBean(clazz2);
            try {
                this._incompleteReaders.put(classKey, valueReader);
                for (Map.Entry<String, BeanProperty> entry : ((BeanDefinition)valueReader).propertiesByName().entrySet()) {
                    BeanProperty beanProperty = entry.getValue();
                    entry.setValue(beanProperty.withReader(this.createReader(clazz, beanProperty.rawSetterType(), beanProperty.genericSetterType())));
                }
            }
            finally {
                this._incompleteReaders.remove(classKey);
            }
            return valueReader;
        }
    }

    private TypeBindings bindings(Class<?> clazz) {
        if (clazz == null) {
            return TypeBindings.emptyBindings();
        }
        return TypeBindings.create(clazz, (ResolvedType[])null);
    }

    public static ValueReader enumReader(Class<?> clazz) {
        Object[] objectArray = clazz.getEnumConstants();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object obj : objectArray) {
            hashMap.put(obj.toString(), obj);
        }
        return new EnumReader(objectArray, hashMap);
    }

    protected ValueReader collectionReader(Class<?> clazz, Type type) {
        ResolvedType resolvedType = this._typeResolver.resolve(this.bindings(clazz), type);
        List<ResolvedType> list = resolvedType.typeParametersFor(Collection.class);
        return this.collectionReader(resolvedType.erasedType(), list.get(0));
    }

    protected ValueReader collectionReader(Class<?> clazz, ResolvedType resolvedType) {
        Class<?> clazz2 = resolvedType.erasedType();
        if (Collection.class.isAssignableFrom(clazz2)) {
            List<ResolvedType> list = resolvedType.typeParametersFor(Collection.class);
            return this.collectionReader(clazz2, list.get(0));
        }
        if (Map.class.isAssignableFrom(clazz2)) {
            List<ResolvedType> list = resolvedType.typeParametersFor(Map.class);
            return this.mapReader(clazz2, list.get(1));
        }
        return new CollectionReader(clazz, this.createReader(null, clazz2, clazz2));
    }

    protected ValueReader mapReader(Class<?> clazz, Type type) {
        ResolvedType resolvedType = this._typeResolver.resolve(this.bindings(clazz), type);
        List<ResolvedType> list = resolvedType.typeParametersFor(Map.class);
        return this.mapReader(resolvedType.erasedType(), list.get(1));
    }

    protected ValueReader mapReader(Class<?> clazz, ResolvedType resolvedType) {
        Class<?> clazz2 = resolvedType.erasedType();
        if (Collection.class.isAssignableFrom(clazz2)) {
            List<ResolvedType> list = resolvedType.typeParametersFor(Collection.class);
            return this.collectionReader(clazz2, list.get(0));
        }
        if (Map.class.isAssignableFrom(clazz2)) {
            List<ResolvedType> list = resolvedType.typeParametersFor(Map.class);
            return this.mapReader(clazz2, list.get(1));
        }
        return new MapReader(clazz, this.createReader(null, clazz2, clazz2));
    }

    private static String decap(String string) {
        char c = string.charAt(0);
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(c)) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(c);
        return new String(cArray);
    }
}

