/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.ContentReference;
import com.fasterxml.jackson.core.json.DupDetector;
import java.util.Set;

public final class XmlReadContext
extends JsonStreamContext {
    protected final XmlReadContext _parent;
    protected final DupDetector _dups;
    protected int _lineNr;
    protected int _columnNr;
    protected String _currentName;
    protected Object _currentValue;
    protected Set<String> _namesToWrap;
    protected String _wrappedName;
    protected XmlReadContext _child = null;

    public XmlReadContext(XmlReadContext parent, DupDetector dups, int nestingDepth, int type, int lineNr, int colNr) {
        this._type = type;
        this._parent = parent;
        this._dups = dups;
        this._lineNr = lineNr;
        this._columnNr = colNr;
        this._index = -1;
        this._nestingDepth = nestingDepth;
    }

    @Deprecated
    public XmlReadContext(XmlReadContext parent, int nestingDepth, int type, int lineNr, int colNr) {
        this(parent, null, nestingDepth, type, lineNr, colNr);
    }

    protected final void reset(int type, int lineNr, int colNr) {
        this._type = type;
        this._index = -1;
        this._lineNr = lineNr;
        this._columnNr = colNr;
        this._currentName = null;
        this._currentValue = null;
        this._namesToWrap = null;
        if (this._dups != null) {
            this._dups.reset();
        }
    }

    public Object getCurrentValue() {
        return this._currentValue;
    }

    public void setCurrentValue(Object v) {
        this._currentValue = v;
    }

    public static XmlReadContext createRootContext(DupDetector dups, int lineNr, int colNr) {
        return new XmlReadContext(null, dups, 0, 0, lineNr, colNr);
    }

    @Deprecated
    public static XmlReadContext createRootContext(int lineNr, int colNr) {
        return XmlReadContext.createRootContext(null, lineNr, colNr);
    }

    @Deprecated
    public static XmlReadContext createRootContext() {
        return XmlReadContext.createRootContext(null, 1, 0);
    }

    public final XmlReadContext createChildArrayContext(int lineNr, int colNr) {
        ++this._index;
        XmlReadContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new XmlReadContext(this, this._dups == null ? null : this._dups.child(), this._nestingDepth + 1, 1, lineNr, colNr);
            return ctxt;
        }
        ctxt.reset(1, lineNr, colNr);
        return ctxt;
    }

    public final XmlReadContext createChildObjectContext(int lineNr, int colNr) {
        ++this._index;
        XmlReadContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new XmlReadContext(this, this._dups == null ? null : this._dups.child(), this._nestingDepth + 1, 2, lineNr, colNr);
        } else {
            ctxt.reset(2, lineNr, colNr);
        }
        return ctxt;
    }

    public final String getCurrentName() {
        return this._currentName;
    }

    public boolean hasCurrentName() {
        return this._currentName != null;
    }

    public final XmlReadContext getParent() {
        return this._parent;
    }

    public final JsonLocation startLocation(ContentReference srcRef) {
        long totalChars = -1L;
        return new JsonLocation(srcRef, totalChars, this._lineNr, this._columnNr);
    }

    public final void valueStarted() {
        ++this._index;
    }

    public void setCurrentName(String name) throws JsonProcessingException {
        this._currentName = name;
        if (this._dups != null) {
            XmlReadContext._checkDup(this._dups, name);
        }
    }

    private static void _checkDup(DupDetector dd, String name) throws JsonProcessingException {
        if (dd.isDup(name)) {
            throw new JsonParseException(null, "Duplicate field '" + name + "'", dd.findLocation());
        }
    }

    public void setNamesToWrap(Set<String> namesToWrap) {
        this._namesToWrap = namesToWrap;
    }

    public boolean shouldWrap(String localName) {
        return this._namesToWrap != null && this._namesToWrap.contains(localName);
    }

    protected void convertToArray() {
        this._type = 1;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                sb.append("/");
                break;
            }
            case 1: {
                sb.append('[');
                sb.append(this.getCurrentIndex());
                sb.append(']');
                break;
            }
            case 2: {
                sb.append('{');
                if (this._currentName != null) {
                    sb.append('\"');
                    CharTypes.appendQuoted((StringBuilder)sb, (String)this._currentName);
                    sb.append('\"');
                } else {
                    sb.append('?');
                }
                sb.append('}');
            }
        }
        return sb.toString();
    }
}

