/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.parquetio.helper;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.TimeZone;
import scala.Tuple2;

public final class DateTimeHelper$ {
    public static final DateTimeHelper$ MODULE$ = new DateTimeHelper$();
    private static final LocalDateTime UnixEpochDateTime = LocalDateTime.of(1970, 1, 1, 0, 0, 0);
    private static final long JULIAN_DAY_OF_EPOCH = 2440588L;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MILLIS_PER_DAY = MODULE$.SECONDS_PER_DAY() * MODULE$.MILLIS_PER_SECOND();
    private static final long MICROS_PER_MILLIS = 1000L;
    private static final long MICROS_PER_SECOND = MODULE$.MICROS_PER_MILLIS() * MODULE$.MILLIS_PER_SECOND();
    private static final long MICROS_PER_DAY = MODULE$.MICROS_PER_SECOND() * MODULE$.SECONDS_PER_DAY();

    public LocalDateTime UnixEpochDateTime() {
        return UnixEpochDateTime;
    }

    public long JULIAN_DAY_OF_EPOCH() {
        return JULIAN_DAY_OF_EPOCH;
    }

    public long SECONDS_PER_DAY() {
        return SECONDS_PER_DAY;
    }

    public long MILLIS_PER_SECOND() {
        return MILLIS_PER_SECOND;
    }

    public long MILLIS_PER_DAY() {
        return MILLIS_PER_DAY;
    }

    public long MICROS_PER_MILLIS() {
        return MICROS_PER_MILLIS;
    }

    public long MICROS_PER_SECOND() {
        return MICROS_PER_SECOND;
    }

    public long MICROS_PER_DAY() {
        return MICROS_PER_DAY;
    }

    public Timestamp getTimestampFromMicros(long us) {
        long seconds = us / this.MICROS_PER_SECOND();
        long micros = us % this.MICROS_PER_SECOND();
        if (micros < 0L) {
            micros += this.MICROS_PER_SECOND();
            --seconds;
        }
        Timestamp ts = new Timestamp(seconds * 1000L);
        ts.setNanos((int)micros * 1000);
        return ts;
    }

    public Timestamp getTimestampFromMillis(long millis) {
        return new Timestamp(millis);
    }

    public long getMicrosFromTimestamp(Timestamp ts) {
        if (ts != null) {
            return ts.getTime() * 1000L + (long)ts.getNanos() / 1000L % 1000L;
        }
        return 0L;
    }

    public Tuple2<Object, Object> getJulianDayAndNanos(long us) {
        long julianUs = us + this.JULIAN_DAY_OF_EPOCH() * this.MICROS_PER_DAY();
        long day = julianUs / this.MICROS_PER_DAY();
        long micros = julianUs % this.MICROS_PER_DAY();
        return new Tuple2.mcIJ.sp((int)day, micros * 1000L);
    }

    public long getMicrosFromJulianDay(int day, long nanos) {
        long seconds = ((long)day - this.JULIAN_DAY_OF_EPOCH()) * this.SECONDS_PER_DAY();
        return seconds * this.MICROS_PER_SECOND() + nanos / 1000L;
    }

    public long daysSinceEpoch(Date date) {
        long millisUtc = date.getTime();
        long millis = millisUtc + (long)TimeZone.getTimeZone(ZoneId.systemDefault()).getOffset(millisUtc);
        return (long)Math.floor((double)millis / (double)this.MILLIS_PER_DAY());
    }

    public Date daysToDate(long days) {
        LocalDateTime date = this.UnixEpochDateTime().plusDays(days);
        long millis = date.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return new Date(millis);
    }

    private DateTimeHelper$() {
    }
}

