/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(description="Contains information about the method used for authentication.")
public class AuthenticationMethod
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="authenticationType")
    private String authenticationType = null;
    @JsonProperty(value="lastProvider")
    private String lastProvider = null;
    @JsonProperty(value="lastTimestamp")
    private String lastTimestamp = null;
    @JsonProperty(value="totalCount")
    private String totalCount = null;

    public AuthenticationMethod authenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    @Schema(description="Indicates the type of authentication. Valid values are: PhoneAuth, STAN, ISCheck, OFAC, AccessCode, AgeVerify, or SSOAuth. ")
    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public AuthenticationMethod lastProvider(String lastProvider) {
        this.lastProvider = lastProvider;
        return this;
    }

    @Schema(description="The last provider that authenticated the user. ")
    public String getLastProvider() {
        return this.lastProvider;
    }

    public void setLastProvider(String lastProvider) {
        this.lastProvider = lastProvider;
    }

    public AuthenticationMethod lastTimestamp(String lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
        return this;
    }

    @Schema(description=" The data and time the user last used the authentication method. ")
    public String getLastTimestamp() {
        return this.lastTimestamp;
    }

    public void setLastTimestamp(String lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
    }

    public AuthenticationMethod totalCount(String totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @Schema(description="The number of times the authentication method was used. ")
    public String getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(String totalCount) {
        this.totalCount = totalCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationMethod authenticationMethod = (AuthenticationMethod)o;
        return Objects.equals(this.authenticationType, authenticationMethod.authenticationType) && Objects.equals(this.lastProvider, authenticationMethod.lastProvider) && Objects.equals(this.lastTimestamp, authenticationMethod.lastTimestamp) && Objects.equals(this.totalCount, authenticationMethod.totalCount);
    }

    public int hashCode() {
        return Objects.hash(this.authenticationType, this.lastProvider, this.lastTimestamp, this.totalCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationMethod {\n");
        sb.append("    authenticationType: ").append(this.toIndentedString(this.authenticationType)).append("\n");
        sb.append("    lastProvider: ").append(this.toIndentedString(this.lastProvider)).append("\n");
        sb.append("    lastTimestamp: ").append(this.toIndentedString(this.lastTimestamp)).append("\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

