/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.ApiResponse;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.PageImages;
import com.docusign.esign.model.Workspace;
import com.docusign.esign.model.WorkspaceFolderContents;
import com.docusign.esign.model.WorkspaceItem;
import com.docusign.esign.model.WorkspaceItemList;
import com.docusign.esign.model.WorkspaceList;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class WorkspacesApi {
    private ApiClient apiClient;

    public WorkspacesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkspacesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Workspace createWorkspace(String accountId, Workspace workspace) throws ApiException {
        ApiResponse<Workspace> localVarResponse = this.createWorkspaceWithHttpInfo(accountId, workspace);
        return localVarResponse.getData();
    }

    public ApiResponse<Workspace> createWorkspaceWithHttpInfo(String accountId, Workspace workspace) throws ApiException {
        Workspace localVarPostBody = workspace;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createWorkspace");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/workspaces".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Workspace> localVarReturnType = new GenericType<Workspace>(){};
        Workspace localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Workspace>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WorkspaceItem createWorkspaceFile(String accountId, String workspaceId, String folderId) throws ApiException {
        ApiResponse<WorkspaceItem> localVarResponse = this.createWorkspaceFileWithHttpInfo(accountId, workspaceId, folderId);
        return localVarResponse.getData();
    }

    public ApiResponse<WorkspaceItem> createWorkspaceFileWithHttpInfo(String accountId, String workspaceId, String folderId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createWorkspaceFile");
        }
        if (workspaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'workspaceId' when calling createWorkspaceFile");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling createWorkspaceFile");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workspaceId\\}", this.apiClient.escapeString(workspaceId.toString())).replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WorkspaceItem> localVarReturnType = new GenericType<WorkspaceItem>(){};
        WorkspaceItem localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WorkspaceItem>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Workspace deleteWorkspace(String accountId, String workspaceId) throws ApiException {
        ApiResponse<Workspace> localVarResponse = this.deleteWorkspaceWithHttpInfo(accountId, workspaceId);
        return localVarResponse.getData();
    }

    public ApiResponse<Workspace> deleteWorkspaceWithHttpInfo(String accountId, String workspaceId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteWorkspace");
        }
        if (workspaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'workspaceId' when calling deleteWorkspace");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workspaceId\\}", this.apiClient.escapeString(workspaceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Workspace> localVarReturnType = new GenericType<Workspace>(){};
        Workspace localVarResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Workspace>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void deleteWorkspaceFolderItems(String accountId, String workspaceId, String folderId, WorkspaceItemList workspaceItemList) throws ApiException {
        this.deleteWorkspaceFolderItemsWithHttpInfo(accountId, workspaceId, folderId, workspaceItemList);
    }

    public ApiResponse<Object> deleteWorkspaceFolderItemsWithHttpInfo(String accountId, String workspaceId, String folderId, WorkspaceItemList workspaceItemList) throws ApiException {
        WorkspaceItemList localVarPostBody = workspaceItemList;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteWorkspaceFolderItems");
        }
        if (workspaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'workspaceId' when calling deleteWorkspaceFolderItems");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling deleteWorkspaceFolderItems");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workspaceId\\}", this.apiClient.escapeString(workspaceId.toString())).replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public Workspace getWorkspace(String accountId, String workspaceId) throws ApiException {
        ApiResponse<Workspace> localVarResponse = this.getWorkspaceWithHttpInfo(accountId, workspaceId);
        return localVarResponse.getData();
    }

    public ApiResponse<Workspace> getWorkspaceWithHttpInfo(String accountId, String workspaceId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getWorkspace");
        }
        if (workspaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'workspaceId' when calling getWorkspace");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workspaceId\\}", this.apiClient.escapeString(workspaceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Workspace> localVarReturnType = new GenericType<Workspace>(){};
        Workspace localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Workspace>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public void getWorkspaceFile(String accountId, String workspaceId, String folderId, String fileId) throws ApiException {
        this.getWorkspaceFile(accountId, workspaceId, folderId, fileId, null);
    }

    public void getWorkspaceFile(String accountId, String workspaceId, String folderId, String fileId, GetWorkspaceFileOptions options) throws ApiException {
        this.getWorkspaceFileWithHttpInfo(accountId, workspaceId, folderId, fileId, options);
    }

    public ApiResponse<Object> getWorkspaceFileWithHttpInfo(String accountId, String workspaceId, String folderId, String fileId, GetWorkspaceFileOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getWorkspaceFile");
        }
        if (workspaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'workspaceId' when calling getWorkspaceFile");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling getWorkspaceFile");
        }
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling getWorkspaceFile");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workspaceId\\}", this.apiClient.escapeString(workspaceId.toString())).replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString())).replaceAll("\\{fileId\\}", this.apiClient.escapeString(fileId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("is_download", options.isDownload));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pdf_version", options.pdfVersion));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public PageImages listWorkspaceFilePages(String accountId, String workspaceId, String folderId, String fileId) throws ApiException {
        return this.listWorkspaceFilePages(accountId, workspaceId, folderId, fileId, null);
    }

    public PageImages listWorkspaceFilePages(String accountId, String workspaceId, String folderId, String fileId, ListWorkspaceFilePagesOptions options) throws ApiException {
        ApiResponse<PageImages> localVarResponse = this.listWorkspaceFilePagesWithHttpInfo(accountId, workspaceId, folderId, fileId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<PageImages> listWorkspaceFilePagesWithHttpInfo(String accountId, String workspaceId, String folderId, String fileId, ListWorkspaceFilePagesOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listWorkspaceFilePages");
        }
        if (workspaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'workspaceId' when calling listWorkspaceFilePages");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling listWorkspaceFilePages");
        }
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling listWorkspaceFilePages");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}/pages".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workspaceId\\}", this.apiClient.escapeString(workspaceId.toString())).replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString())).replaceAll("\\{fileId\\}", this.apiClient.escapeString(fileId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("dpi", options.dpi));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_height", options.maxHeight));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_width", options.maxWidth));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<PageImages> localVarReturnType = new GenericType<PageImages>(){};
        PageImages localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<PageImages>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WorkspaceFolderContents listWorkspaceFolderItems(String accountId, String workspaceId, String folderId) throws ApiException {
        return this.listWorkspaceFolderItems(accountId, workspaceId, folderId, null);
    }

    public WorkspaceFolderContents listWorkspaceFolderItems(String accountId, String workspaceId, String folderId, ListWorkspaceFolderItemsOptions options) throws ApiException {
        ApiResponse<WorkspaceFolderContents> localVarResponse = this.listWorkspaceFolderItemsWithHttpInfo(accountId, workspaceId, folderId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<WorkspaceFolderContents> listWorkspaceFolderItemsWithHttpInfo(String accountId, String workspaceId, String folderId, ListWorkspaceFolderItemsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listWorkspaceFolderItems");
        }
        if (workspaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'workspaceId' when calling listWorkspaceFolderItems");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling listWorkspaceFolderItems");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workspaceId\\}", this.apiClient.escapeString(workspaceId.toString())).replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("count", options.count));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_files", options.includeFiles));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_sub_folders", options.includeSubFolders));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_thumbnails", options.includeThumbnails));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_user_detail", options.includeUserDetail));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("start_position", options.startPosition));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("workspace_user_id", options.workspaceUserId));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WorkspaceFolderContents> localVarReturnType = new GenericType<WorkspaceFolderContents>(){};
        WorkspaceFolderContents localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WorkspaceFolderContents>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WorkspaceList listWorkspaces(String accountId) throws ApiException {
        ApiResponse<WorkspaceList> localVarResponse = this.listWorkspacesWithHttpInfo(accountId);
        return localVarResponse.getData();
    }

    public ApiResponse<WorkspaceList> listWorkspacesWithHttpInfo(String accountId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listWorkspaces");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/workspaces".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WorkspaceList> localVarReturnType = new GenericType<WorkspaceList>(){};
        WorkspaceList localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WorkspaceList>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public Workspace updateWorkspace(String accountId, String workspaceId, Workspace workspace) throws ApiException {
        ApiResponse<Workspace> localVarResponse = this.updateWorkspaceWithHttpInfo(accountId, workspaceId, workspace);
        return localVarResponse.getData();
    }

    public ApiResponse<Workspace> updateWorkspaceWithHttpInfo(String accountId, String workspaceId, Workspace workspace) throws ApiException {
        Workspace localVarPostBody = workspace;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateWorkspace");
        }
        if (workspaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'workspaceId' when calling updateWorkspace");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workspaceId\\}", this.apiClient.escapeString(workspaceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<Workspace> localVarReturnType = new GenericType<Workspace>(){};
        Workspace localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<Workspace>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public WorkspaceItem updateWorkspaceFile(String accountId, String workspaceId, String folderId, String fileId) throws ApiException {
        ApiResponse<WorkspaceItem> localVarResponse = this.updateWorkspaceFileWithHttpInfo(accountId, workspaceId, folderId, fileId);
        return localVarResponse.getData();
    }

    public ApiResponse<WorkspaceItem> updateWorkspaceFileWithHttpInfo(String accountId, String workspaceId, String folderId, String fileId) throws ApiException {
        String localVarPostBody = "{}";
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateWorkspaceFile");
        }
        if (workspaceId == null) {
            throw new ApiException(400, "Missing the required parameter 'workspaceId' when calling updateWorkspaceFile");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling updateWorkspaceFile");
        }
        if (fileId == null) {
            throw new ApiException(400, "Missing the required parameter 'fileId' when calling updateWorkspaceFile");
        }
        String localVarPath = "/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}".replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{workspaceId\\}", this.apiClient.escapeString(workspaceId.toString())).replaceAll("\\{folderId\\}", this.apiClient.escapeString(folderId.toString())).replaceAll("\\{fileId\\}", this.apiClient.escapeString(fileId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<WorkspaceItem> localVarReturnType = new GenericType<WorkspaceItem>(){};
        WorkspaceItem localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<WorkspaceItem>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class ListWorkspaceFolderItemsOptions {
        private String count = null;
        private String includeFiles = null;
        private String includeSubFolders = null;
        private String includeThumbnails = null;
        private String includeUserDetail = null;
        private String startPosition = null;
        private String workspaceUserId = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setIncludeFiles(String includeFiles) {
            this.includeFiles = includeFiles;
        }

        public String getIncludeFiles() {
            return this.includeFiles;
        }

        public void setIncludeSubFolders(String includeSubFolders) {
            this.includeSubFolders = includeSubFolders;
        }

        public String getIncludeSubFolders() {
            return this.includeSubFolders;
        }

        public void setIncludeThumbnails(String includeThumbnails) {
            this.includeThumbnails = includeThumbnails;
        }

        public String getIncludeThumbnails() {
            return this.includeThumbnails;
        }

        public void setIncludeUserDetail(String includeUserDetail) {
            this.includeUserDetail = includeUserDetail;
        }

        public String getIncludeUserDetail() {
            return this.includeUserDetail;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }

        public void setWorkspaceUserId(String workspaceUserId) {
            this.workspaceUserId = workspaceUserId;
        }

        public String getWorkspaceUserId() {
            return this.workspaceUserId;
        }
    }

    public class ListWorkspaceFilePagesOptions {
        private String count = null;
        private String dpi = null;
        private String maxHeight = null;
        private String maxWidth = null;
        private String startPosition = null;

        public void setCount(String count) {
            this.count = count;
        }

        public String getCount() {
            return this.count;
        }

        public void setDpi(String dpi) {
            this.dpi = dpi;
        }

        public String getDpi() {
            return this.dpi;
        }

        public void setMaxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
        }

        public String getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
        }

        public String getMaxWidth() {
            return this.maxWidth;
        }

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }

    public class GetWorkspaceFileOptions {
        private String isDownload = null;
        private String pdfVersion = null;

        public void setIsDownload(String isDownload) {
            this.isDownload = isDownload;
        }

        public String getIsDownload() {
            return this.isDownload;
        }

        public void setPdfVersion(String pdfVersion) {
            this.pdfVersion = pdfVersion;
        }

        public String getPdfVersion() {
            return this.pdfVersion;
        }
    }
}

