/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.config;

import com.dangdang.ddframe.job.exception.JobConfigurationException;
import com.dangdang.ddframe.job.exception.JobExecutionEnvironmentException;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.config.LiteJobConfigurationGsonFactory;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.util.env.TimeService;
import com.google.common.base.Optional;

public final class ConfigurationService {
    private final TimeService timeService;
    private final JobNodeStorage jobNodeStorage;

    public ConfigurationService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
        this.timeService = new TimeService();
    }

    public LiteJobConfiguration load(boolean fromCache) {
        String result;
        if (fromCache) {
            result = this.jobNodeStorage.getJobNodeData("config");
            if (null == result) {
                result = this.jobNodeStorage.getJobNodeDataDirectly("config");
            }
        } else {
            result = this.jobNodeStorage.getJobNodeDataDirectly("config");
        }
        return LiteJobConfigurationGsonFactory.fromJson(result);
    }

    public void persist(LiteJobConfiguration liteJobConfig) {
        this.checkConflictJob(liteJobConfig);
        if (!this.jobNodeStorage.isJobNodeExisted("config") || liteJobConfig.isOverwrite()) {
            this.jobNodeStorage.replaceJobNode("config", LiteJobConfigurationGsonFactory.toJson(liteJobConfig));
        }
    }

    private void checkConflictJob(LiteJobConfiguration liteJobConfig) {
        Optional<LiteJobConfiguration> liteJobConfigFromZk = this.find();
        if (liteJobConfigFromZk.isPresent() && !((LiteJobConfiguration)liteJobConfigFromZk.get()).getTypeConfig().getJobClass().equals(liteJobConfig.getTypeConfig().getJobClass())) {
            throw new JobConfigurationException("Job conflict with register center. The job '%s' in register center's class is '%s', your job class is '%s'", new Object[]{liteJobConfig.getJobName(), ((LiteJobConfiguration)liteJobConfigFromZk.get()).getTypeConfig().getJobClass(), liteJobConfig.getTypeConfig().getJobClass()});
        }
    }

    private Optional<LiteJobConfiguration> find() {
        if (!this.jobNodeStorage.isJobNodeExisted("config")) {
            return Optional.absent();
        }
        LiteJobConfiguration result = LiteJobConfigurationGsonFactory.fromJson(this.jobNodeStorage.getJobNodeDataDirectly("config"));
        if (null == result) {
            this.jobNodeStorage.removeJobNodeIfExisted("config");
        }
        return Optional.fromNullable((Object)result);
    }

    public void checkMaxTimeDiffSecondsTolerable() throws JobExecutionEnvironmentException {
        int maxTimeDiffSeconds = this.load(true).getMaxTimeDiffSeconds();
        if (-1 == maxTimeDiffSeconds) {
            return;
        }
        long timeDiff = Math.abs(this.timeService.getCurrentMillis() - this.jobNodeStorage.getRegistryCenterTime());
        if (timeDiff > (long)maxTimeDiffSeconds * 1000L) {
            throw new JobExecutionEnvironmentException("Time different between job server and register center exceed '%s' seconds, max time different is '%s' seconds.", new Object[]{timeDiff / 1000L, maxTimeDiffSeconds});
        }
    }
}

