/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.maven.plugins.crx;

import com.btmatthews.maven.plugins.crx.ArchiveHelper;
import com.btmatthews.maven.plugins.crx.CRXArchive;
import com.btmatthews.maven.plugins.crx.SignatureHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="crx-verify", defaultPhase=LifecyclePhase.PACKAGE)
public class CRXVerifyMojo
extends AbstractMojo {
    @Parameter(required=false)
    private File crxPath;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter
    private String classifier;
    @Component
    private ArchiveHelper archiveHelper;
    @Component
    private SignatureHelper signatureHelper;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        File crxFile;
        if (this.crxPath == null) {
            StringBuilder crxFilename = new StringBuilder();
            crxFilename.append(this.finalName);
            if (StringUtils.isNotEmpty((String)this.classifier)) {
                crxFilename.append('-');
                crxFilename.append(this.classifier);
            }
            crxFilename.append(".crx");
            crxFile = new File(this.outputDirectory, crxFilename.toString());
        } else {
            crxFile = this.crxPath;
        }
        try {
            CRXArchive archive = this.archiveHelper.readArchive(crxFile);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(archive.getPublicKey());
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            if (!this.signatureHelper.check(archive.getData(), publicKey, archive.getSignature())) {
                throw new MojoFailureException("The signature is not valid");
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Could not find CRX archive", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load CRX archive", (Exception)e);
        }
        catch (GeneralSecurityException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

