/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import com.browseengine.bobo.util.BigSegmentedArray;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.lucene.util.OpenBitSet;

public class LazyBigIntArray
extends BigSegmentedArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[][] _array = new int[this._numrows][];
    private static final int BLOCK_SIZE = 1024;
    private static final int SHIFT_SIZE = 10;
    private static final int MASK = 1023;
    private int _fillValue = 0;

    public LazyBigIntArray(int size) {
        super(size);
    }

    @Override
    int getBlockSize() {
        return 1024;
    }

    @Override
    int getShiftSize() {
        return 10;
    }

    @Override
    public int get(int id) {
        int i = id >> 10;
        if (this._array[i] == null) {
            return this._fillValue;
        }
        return this._array[i][id & 0x3FF];
    }

    @Override
    public void add(int id, int val) {
        int i = id >> 10;
        if (this._array[i] == null) {
            this._array[i] = new int[1024];
            if (this._fillValue != 0) {
                Arrays.fill(this._array[i], this._fillValue);
            }
        }
        this._array[i][id & 0x3FF] = val;
    }

    @Override
    public void fill(int val) {
        for (int[] block : this._array) {
            if (block == null) continue;
            Arrays.fill(block, val);
        }
        this._fillValue = val;
    }

    @Override
    public void ensureCapacity(int size) {
        int newNumrows = (size >> 10) + 1;
        if (newNumrows > this._array.length) {
            int[][] newArray = new int[newNumrows][];
            System.arraycopy(this._array, 0, newArray, 0, this._array.length);
            this._array = newArray;
        }
        this._numrows = newNumrows;
    }

    @Override
    public int maxValue() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int findValue(int val, int id, int maxId) {
        while (id <= maxId) {
            int i = id >> 10;
            if (this._array[i] == null) {
                if (val == this._fillValue) {
                    return id;
                }
                id = i + 1 << 10;
                continue;
            }
            if (this._array[i][id & 0x3FF] == val) {
                return id;
            }
            ++id;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int findValues(OpenBitSet bitset, int id, int maxId) {
        while (id <= maxId) {
            int i = id >> 10;
            if (this._array[i] == null) {
                if (bitset.fastGet(this._fillValue)) {
                    return id;
                }
                id = i + 1 << 10;
                continue;
            }
            if (bitset.fastGet(this._array[i][id & 0x3FF])) {
                return id;
            }
            ++id;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int findValueRange(int minVal, int maxVal, int id, int maxId) {
        while (id <= maxId) {
            int i = id >> 10;
            if (this._array[i] == null) {
                if (this._fillValue >= minVal && this._fillValue <= maxVal) {
                    return id;
                }
                id = i + 1 << 10;
                continue;
            }
            int val = this._array[i][id & 0x3FF];
            if (val >= minVal && val <= maxVal) {
                return id;
            }
            ++id;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int findBits(int bits, int id, int maxId) {
        while (id <= maxId) {
            int i = id >> 10;
            if (this._array[i] == null) {
                if ((this._fillValue & bits) != 0) {
                    return id;
                }
                id = i + 1 << 10;
                continue;
            }
            int val = this._array[i][id & 0x3FF];
            if ((val & bits) != 0) {
                return id;
            }
            ++id;
        }
        return Integer.MAX_VALUE;
    }
}

