/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;

public class IntBoundedPriorityQueue
extends PriorityQueue<Integer> {
    private static final long serialVersionUID = 1L;
    private final int _capacity;
    private final int[] _items;
    private int _size = 0;
    private final IntComparator _comp;
    private final int _forbiddenValue;

    public IntBoundedPriorityQueue(IntComparator comparator, int capacity, int forbiddenValue) {
        this._capacity = capacity;
        this._comp = comparator;
        this._items = new int[capacity];
        this._forbiddenValue = forbiddenValue;
    }

    @Override
    public Integer element() throws NoSuchElementException {
        if (this._size == 0) {
            throw new NoSuchElementException("empty queue");
        }
        return this._items[0];
    }

    public int intElement() throws NoSuchElementException {
        if (this._size == 0) {
            throw new NoSuchElementException("empty queue");
        }
        return this._items[0];
    }

    public IntIterator iterator() {
        return new IntIterator(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < IntBoundedPriorityQueue.this._size;
            }

            @Override
            public Integer next() throws NoSuchElementException {
                if (this.i >= IntBoundedPriorityQueue.this._size) {
                    throw new NoSuchElementException("last element reached in queue");
                }
                return IntBoundedPriorityQueue.this._items[this.i++];
            }

            @Override
            public int nextInt() throws NoSuchElementException {
                if (this.i >= IntBoundedPriorityQueue.this._size) {
                    throw new NoSuchElementException("last element reached in queue");
                }
                return IntBoundedPriorityQueue.this._items[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("not supported");
            }
        };
    }

    @Override
    public boolean offer(Integer item) {
        int itm = item;
        return this.offer(itm);
    }

    @Override
    public boolean offer(int item) {
        if (this._size < this._capacity) {
            this._items[this._size] = item;
            this.percolateUp(this._size);
            ++this._size;
            return true;
        }
        if (this._items[0] < item) {
            this._items[0] = item;
            this.percolateDown();
            return true;
        }
        return false;
    }

    @Override
    public Integer peek() {
        if (this._size == 0) {
            return null;
        }
        return this._items[0];
    }

    public int peekInt() {
        if (this._size == 0) {
            return this._forbiddenValue;
        }
        return this._items[0];
    }

    @Override
    public Integer poll() {
        if (this._size == 0) {
            return null;
        }
        int ret = this._items[0];
        --this._size;
        this._items[0] = this._items[this._size];
        this._items[this._size] = 0;
        if (this._size > 1) {
            this.percolateDown();
        }
        return ret;
    }

    public int pollInt() {
        if (this._size == 0) {
            return this._forbiddenValue;
        }
        int ret = this._items[0];
        --this._size;
        this._items[0] = this._items[this._size];
        this._items[this._size] = 0;
        if (this._size > 1) {
            this.percolateDown();
        }
        return ret;
    }

    @Override
    public int size() {
        return this._size;
    }

    private void percolateDown() {
        block4: {
            int temp = this._items[0];
            int index = 0;
            while (true) {
                int left;
                int right;
                if ((right = (left = (index << 1) + 1) + 1) < this._size) {
                    left = this._comp.compare(this._items[left], this._items[right]) < 0 ? left : right;
                } else if (left >= this._size) {
                    this._items[index] = temp;
                    break block4;
                }
                if (this._comp.compare(this._items[left], temp) >= 0) break;
                this._items[index] = this._items[left];
                index = left;
            }
            this._items[index] = temp;
        }
    }

    private void percolateUp(int index) {
        int i;
        int temp = this._items[index];
        while ((i = index - 1 >> 1) >= 0 && this._comp.compare(temp, this._items[i]) < 0) {
            this._items[index] = this._items[i];
            index = i;
        }
        this._items[index] = temp;
    }

    public static abstract class IntComparator
    implements Comparator<Integer> {
        @Override
        public int compare(int int1, int int2) {
            return this.compare(Integer.valueOf(int1), Integer.valueOf(int2));
        }
    }

    public static interface IntIterator
    extends Iterator<Integer> {
        public int nextInt();
    }
}

