/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import com.browseengine.bobo.util.BigSegmentedArray;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.lucene.util.OpenBitSet;

public class BigByteArray
extends BigSegmentedArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[][] _array;
    private static final int BLOCK_SIZE = 4096;
    private static final int SHIFT_SIZE = 12;
    private static final int MASK = 4095;

    public BigByteArray(int size) {
        super(size);
        this._array = new byte[this._numrows][];
        for (int i = 0; i < this._numrows; ++i) {
            this._array[i] = new byte[4096];
        }
    }

    @Override
    public final void add(int docId, int val) {
        this._array[docId >> 12][docId & 0xFFF] = (byte)val;
    }

    @Override
    public final int get(int docId) {
        return this._array[docId >> 12][docId & 0xFFF];
    }

    @Override
    public final int findValue(int val, int docId, int maxId) {
        do {
            if (this._array[docId >> 12][docId & 0xFFF] != val) continue;
            return docId;
        } while (docId++ < maxId);
        return Integer.MAX_VALUE;
    }

    @Override
    public final int findValues(OpenBitSet bitset, int docId, int maxId) {
        do {
            if (!bitset.fastGet((int)this._array[docId >> 12][docId & 0xFFF])) continue;
            return docId;
        } while (docId++ < maxId);
        return Integer.MAX_VALUE;
    }

    @Override
    public final int findValueRange(int minVal, int maxVal, int docId, int maxId) {
        do {
            byte val;
            if ((val = this._array[docId >> 12][docId & 0xFFF]) < minVal || val > maxVal) continue;
            return docId;
        } while (docId++ < maxId);
        return Integer.MAX_VALUE;
    }

    @Override
    public final int findBits(int bits, int docId, int maxId) {
        do {
            if ((this._array[docId >> 12][docId & 0xFFF] & bits) == 0) continue;
            return docId;
        } while (docId++ < maxId);
        return Integer.MAX_VALUE;
    }

    @Override
    public final void fill(int val) {
        byte byteVal = (byte)val;
        for (byte[] block : this._array) {
            Arrays.fill(block, byteVal);
        }
    }

    @Override
    public void ensureCapacity(int size) {
        int newNumrows = (size >> 12) + 1;
        if (newNumrows > this._array.length) {
            byte[][] newArray = new byte[newNumrows][];
            System.arraycopy(this._array, 0, newArray, 0, this._array.length);
            for (int i = this._array.length; i < newNumrows; ++i) {
                newArray[i] = new byte[4096];
            }
            this._array = newArray;
        }
        this._numrows = newNumrows;
    }

    @Override
    final int getBlockSize() {
        return 4096;
    }

    @Override
    final int getShiftSize() {
        return 12;
    }

    @Override
    public int maxValue() {
        return 127;
    }
}

