/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.sort;

import com.browseengine.bobo.sort.DocComparator;
import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.util.BytesRef;

public abstract class DocComparatorSource {
    boolean _reverse = false;

    public DocComparatorSource setReverse(boolean reverse) {
        this._reverse = reverse;
        return this;
    }

    public final boolean isReverse() {
        return this._reverse;
    }

    public abstract DocComparator getComparator(AtomicReader var1, int var2) throws IOException;

    public static class ByteDocComparatorSource
    extends DocComparatorSource {
        private final String field;

        public ByteDocComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(AtomicReader reader, int docbase) throws IOException {
            final FieldCache.Bytes values = FieldCache.DEFAULT.getBytes(reader, this.field, true);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    return values.get(doc1.doc) - values.get(doc2.doc);
                }

                @Override
                public Byte value(ScoreDoc doc) {
                    return values.get(doc.doc);
                }
            };
        }
    }

    public static class DocIdDocComparatorSource
    extends DocComparatorSource {
        @Override
        public DocComparator getComparator(AtomicReader reader, int docbase) throws IOException {
            final int _docbase = docbase;
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    return doc1.doc - doc2.doc;
                }

                @Override
                public Integer value(ScoreDoc doc) {
                    return doc.doc + _docbase;
                }
            };
        }
    }

    public static class RelevanceDocComparatorSource
    extends DocComparatorSource {
        @Override
        public DocComparator getComparator(AtomicReader reader, int docbase) throws IOException {
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    if (doc1.score < doc2.score) {
                        return -1;
                    }
                    if (doc1.score > doc2.score) {
                        return 1;
                    }
                    return 0;
                }

                @Override
                public Float value(ScoreDoc doc) {
                    return Float.valueOf(doc.score);
                }
            };
        }
    }

    public static class DoubleDocComparatorSource
    extends DocComparatorSource {
        private final String field;

        public DoubleDocComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(AtomicReader reader, int docbase) throws IOException {
            final FieldCache.Doubles values = FieldCache.DEFAULT.getDoubles(reader, this.field, true);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    if (values.get(doc1.doc) < values.get(doc2.doc)) {
                        return -1;
                    }
                    if (values.get(doc1.doc) > values.get(doc2.doc)) {
                        return 1;
                    }
                    return 0;
                }

                @Override
                public Double value(ScoreDoc doc) {
                    return values.get(doc.doc);
                }
            };
        }
    }

    public static class FloatDocComparatorSource
    extends DocComparatorSource {
        private final String field;

        public FloatDocComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(AtomicReader reader, int docbase) throws IOException {
            final FieldCache.Floats values = FieldCache.DEFAULT.getFloats(reader, this.field, true);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    if (values.get(doc1.doc) < values.get(doc2.doc)) {
                        return -1;
                    }
                    if (values.get(doc1.doc) > values.get(doc2.doc)) {
                        return 1;
                    }
                    return 0;
                }

                @Override
                public Float value(ScoreDoc doc) {
                    return Float.valueOf(values.get(doc.doc));
                }
            };
        }
    }

    public static class LongDocComparatorSource
    extends DocComparatorSource {
        private final String field;

        public LongDocComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(AtomicReader reader, int docbase) throws IOException {
            final FieldCache.Longs values = FieldCache.DEFAULT.getLongs(reader, this.field, true);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    if (values.get(doc1.doc) < values.get(doc2.doc)) {
                        return -1;
                    }
                    if (values.get(doc1.doc) > values.get(doc2.doc)) {
                        return 1;
                    }
                    return 0;
                }

                @Override
                public Long value(ScoreDoc doc) {
                    return values.get(doc.doc);
                }
            };
        }
    }

    public static class ShortDocComparatorSource
    extends DocComparatorSource {
        private final String field;

        public ShortDocComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(AtomicReader reader, int docbase) throws IOException {
            final FieldCache.Shorts values = FieldCache.DEFAULT.getShorts(reader, this.field, true);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    return values.get(doc1.doc) - values.get(doc2.doc);
                }

                @Override
                public Short value(ScoreDoc doc) {
                    return values.get(doc.doc);
                }
            };
        }
    }

    public static class StringOrdComparatorSource
    extends DocComparatorSource {
        private final String field;

        public StringOrdComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(AtomicReader reader, int docbase) throws IOException {
            final SortedDocValues values = FieldCache.DEFAULT.getTermsIndex(reader, this.field);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    return values.getOrd(doc1.doc) - values.getOrd(doc2.doc);
                }

                public String value(ScoreDoc doc) {
                    int ord = values.getOrd(doc.doc);
                    BytesRef term = new BytesRef();
                    values.lookupOrd(ord, term);
                    return term.utf8ToString();
                }
            };
        }
    }

    public static class StringValComparatorSource
    extends DocComparatorSource {
        private final String field;

        public StringValComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(AtomicReader reader, int docbase) throws IOException {
            final BinaryDocValues values = FieldCache.DEFAULT.getTerms(reader, this.field);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    BytesRef result1 = new BytesRef();
                    BytesRef result2 = new BytesRef();
                    values.get(doc1.doc, result1);
                    values.get(doc2.doc, result2);
                    if (result1.length == 0) {
                        if (result2.length == 0) {
                            return 0;
                        }
                        return -1;
                    }
                    if (result2.length == 0) {
                        return 1;
                    }
                    return result1.utf8ToString().compareTo(result2.utf8ToString());
                }

                public String value(ScoreDoc doc) {
                    BytesRef result = new BytesRef();
                    values.get(doc.doc, result);
                    return result.utf8ToString();
                }
            };
        }
    }

    public static class IntDocComparatorSource
    extends DocComparatorSource {
        private final String field;

        public IntDocComparatorSource(String field) {
            this.field = field;
        }

        @Override
        public DocComparator getComparator(AtomicReader reader, int docbase) throws IOException {
            final FieldCache.Ints values = FieldCache.DEFAULT.getInts(reader, this.field, true);
            return new DocComparator(){

                @Override
                public int compare(ScoreDoc doc1, ScoreDoc doc2) {
                    if (values.get(doc1.doc) < values.get(doc2.doc)) {
                        return -1;
                    }
                    if (values.get(doc1.doc) > values.get(doc2.doc)) {
                        return 1;
                    }
                    return 0;
                }

                @Override
                public Integer value(ScoreDoc doc) {
                    return values.get(doc.doc);
                }
            };
        }
    }
}

