/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.search.section;

import com.browseengine.bobo.search.section.SectionSearchQueryPlan;
import com.browseengine.bobo.search.section.SectionSearchQueryPlanBuilder;
import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public class SectionSearchQuery
extends Query {
    private final Query _query;

    public SectionSearchQuery(Query query) {
        this._query = query;
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SECTION(" + this._query.toString() + ")");
        return buffer.toString();
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        return new SectionSearchWeight(searcher, this._query);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        this._query.rewrite(reader);
        return this;
    }

    public class SectionSearchScorer
    extends Scorer {
        private int _curDoc;
        private final float _curScr;
        private final SectionSearchQueryPlan _plan;

        public SectionSearchScorer(Weight weight, float score, AtomicReader reader) throws IOException {
            super(weight);
            this._curDoc = -1;
            this._curScr = score;
            SectionSearchQueryPlanBuilder builer = new SectionSearchQueryPlanBuilder(reader);
            this._plan = builer.getPlan(SectionSearchQuery.this._query);
            this._curDoc = this._plan != null ? -1 : Integer.MAX_VALUE;
        }

        public int docID() {
            return this._curDoc;
        }

        public int nextDoc() throws IOException {
            return this.advance(0);
        }

        public float score() throws IOException {
            return this._curScr;
        }

        public int advance(int target) throws IOException {
            if (this._curDoc < Integer.MAX_VALUE) {
                if (target <= this._curDoc) {
                    target = this._curDoc + 1;
                }
                return this._plan.fetch(target);
            }
            return this._curDoc;
        }

        public int freq() throws IOException {
            return 0;
        }

        public long cost() {
            return 0L;
        }
    }

    private class SectionSearchWeight
    extends Weight {
        Weight _weight;

        public SectionSearchWeight(IndexSearcher searcher, Query query) throws IOException {
            this._weight = searcher.createNormalizedWeight(query);
        }

        public String toString() {
            return "weight(" + (Object)((Object)SectionSearchQuery.this) + ")";
        }

        public Query getQuery() {
            return SectionSearchQuery.this;
        }

        public float getValue() {
            return SectionSearchQuery.this.getBoost();
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            Explanation result = new Explanation();
            result.setValue(SectionSearchQuery.this.getBoost());
            result.setDescription(SectionSearchQuery.this.toString());
            return result;
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            SectionSearchScorer scorer = new SectionSearchScorer(this._weight, this.getValue(), context.reader());
            return scorer;
        }

        public float getValueForNormalization() throws IOException {
            return this._weight.getValueForNormalization();
        }

        public void normalize(float norm, float topLevelBoost) {
            this._weight.normalize(norm, topLevelBoost);
        }
    }
}

