/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.query;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;

public class MatchAllDocIdSetIterator
extends DocIdSetIterator {
    private final Bits _acceptDocs;
    private final int _maxDoc;
    private int _docID;

    public MatchAllDocIdSetIterator(AtomicReader reader, Bits acceptDocs) throws IOException {
        this._acceptDocs = acceptDocs;
        this._maxDoc = reader.maxDoc();
        this._docID = -1;
    }

    public int advance(int target) throws IOException {
        this._docID = target;
        while (this._docID < this._maxDoc) {
            if (this._acceptDocs == null || this._acceptDocs.get(this._docID)) {
                return this._docID;
            }
            ++this._docID;
        }
        return Integer.MAX_VALUE;
    }

    public int docID() {
        return this._docID;
    }

    public int nextDoc() throws IOException {
        return this.advance(this._docID + 1);
    }

    public long cost() {
        return 0L;
    }
}

