/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.index.digest;

import com.browseengine.bobo.facets.FacetHandler;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;

public abstract class DataDigester {
    protected DataDigester() {
    }

    public static void populateDocument(Document doc, Collection<FacetHandler<?>> handlers) {
        StringBuilder tokenBuffer = new StringBuilder();
        for (FacetHandler<?> handler : handlers) {
            String name = handler.getName();
            String[] values = doc.getValues(name);
            if (values == null) continue;
            doc.removeFields(name);
            for (String value : values) {
                doc.add((IndexableField)new StringField(name, value, Field.Store.NO));
                tokenBuffer.append(' ').append(value);
            }
        }
    }

    public abstract void digest(DataHandler var1) throws IOException;

    public static interface DataHandler {
        public void handleDocument(Document var1) throws IOException;
    }
}

