/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.index;

import com.browseengine.bobo.index.digest.DataDigester;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public class BoboIndexer {
    private final Directory _index;
    private final DataDigester _digester;
    private IndexWriter _writer;
    private Analyzer _analyzer;

    public void setAnalyzer(Analyzer analyzer) {
        this._analyzer = analyzer;
    }

    private Analyzer getAnalyzer() {
        return this._analyzer == null ? new StandardAnalyzer(Version.LUCENE_43) : this._analyzer;
    }

    public BoboIndexer(DataDigester digester, Directory index) {
        this._index = index;
        this._digester = digester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index() throws IOException {
        this._writer = null;
        try {
            IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_43, this.getAnalyzer());
            this._writer = new IndexWriter(this._index, config);
            MyDataHandler handler = new MyDataHandler(this._writer);
            this._digester.digest(handler);
            this._writer.forceMerge(1);
        }
        finally {
            if (this._writer != null) {
                this._writer.close();
            }
        }
    }

    private static class MyDataHandler
    implements DataDigester.DataHandler {
        private final IndexWriter _writer;

        MyDataHandler(IndexWriter writer) {
            this._writer = writer;
        }

        @Override
        public void handleDocument(Document doc) throws IOException {
            this._writer.addDocument((Iterable)doc);
        }
    }
}

