/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.range;

import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.filter.FacetValueConverter;
import com.browseengine.bobo.facets.range.BitSetBuilder;
import org.apache.lucene.util.OpenBitSet;

public class ValueConverterBitSetBuilder
implements BitSetBuilder {
    private final FacetValueConverter facetValueConverter;
    private final String[] vals;
    private final boolean takeCompliment;

    public ValueConverterBitSetBuilder(FacetValueConverter facetValueConverter, String[] vals, boolean takeCompliment) {
        this.facetValueConverter = facetValueConverter;
        this.vals = vals;
        this.takeCompliment = takeCompliment;
    }

    @Override
    public OpenBitSet bitSet(FacetDataCache<?> dataCache) {
        int[] index = this.facetValueConverter.convert(dataCache, this.vals);
        OpenBitSet bitset = new OpenBitSet((long)dataCache.valArray.size());
        for (int i : index) {
            bitset.fastSet(i);
        }
        if (this.takeCompliment) {
            for (int i = 0; i < index.length; ++i) {
                bitset.fastFlip(i);
            }
        }
        return bitset;
    }
}

