/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.range;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.data.MultiValueFacetDataCache;
import com.browseengine.bobo.facets.data.TermListFactory;
import com.browseengine.bobo.facets.filter.FacetRangeFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.impl.MultiValueFacetHandler;
import com.browseengine.bobo.facets.impl.RangeFacetCountCollector;
import com.browseengine.bobo.facets.impl.RangeFacetHandler;
import com.browseengine.bobo.facets.range.MultiDataCacheBuilder;
import com.browseengine.bobo.query.scoring.BoboDocScorer;
import com.browseengine.bobo.query.scoring.FacetTermScoringFunctionFactory;
import com.browseengine.bobo.sort.DocComparatorSource;
import com.browseengine.bobo.util.BigNestedIntArray;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.Term;

public class MultiRangeFacetHandler
extends RangeFacetHandler {
    private final Term sizePayloadTerm;
    private int maxItems = 1024;

    public MultiRangeFacetHandler(String name, String indexFieldName, Term sizePayloadTerm, TermListFactory termListFactory, List<String> predefinedRanges) {
        super(name, indexFieldName, termListFactory, predefinedRanges);
        this.sizePayloadTerm = sizePayloadTerm;
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        return new MultiValueFacetDataCache.MultiFacetDocComparatorSource(new MultiDataCacheBuilder(this.getName(), this._indexFieldName));
    }

    @Override
    public String[] getFieldValues(BoboSegmentReader reader, int id) {
        MultiValueFacetDataCache dataCache = this.getFacetData(reader);
        if (dataCache != null) {
            return dataCache._nestedArray.getTranslatedData(id, dataCache.valArray);
        }
        return new String[0];
    }

    @Override
    public Object[] getRawFieldValues(BoboSegmentReader reader, int id) {
        MultiValueFacetDataCache dataCache = this.getFacetData(reader);
        if (dataCache != null) {
            return dataCache._nestedArray.getRawData(id, dataCache.valArray);
        }
        return new String[0];
    }

    @Override
    public MultiValueFacetDataCache getFacetData(BoboSegmentReader reader) {
        return (MultiValueFacetDataCache)reader.getFacetData(this._name);
    }

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String value, Properties prop) throws IOException {
        return new FacetRangeFilter(this, value);
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(BrowseSelection sel, final FacetSpec ospec) {
        return new FacetCountCollectorSource(){

            @Override
            public FacetCountCollector getFacetCountCollector(BoboSegmentReader reader, int docBase) {
                MultiValueFacetDataCache dataCache = MultiRangeFacetHandler.this.getFacetData(reader);
                final BigNestedIntArray _nestedArray = dataCache._nestedArray;
                return new RangeFacetCountCollector(MultiRangeFacetHandler.this._name, dataCache, docBase, ospec, MultiRangeFacetHandler.this._predefinedRanges){

                    @Override
                    public void collect(int docid) {
                        _nestedArray.countNoReturn(docid, this._count);
                    }
                };
            }
        };
    }

    @Override
    public BoboDocScorer getDocScorer(BoboSegmentReader reader, FacetTermScoringFunctionFactory scoringFunctionFactory, Map<String, Float> boostMap) {
        MultiValueFacetDataCache dataCache = this.getFacetData(reader);
        float[] boostList = BoboDocScorer.buildBoostList(dataCache.valArray, boostMap);
        return new MultiValueFacetHandler.MultiValueDocScorer(dataCache, scoringFunctionFactory, boostList);
    }

    @Override
    public MultiValueFacetDataCache load(BoboSegmentReader reader) throws IOException {
        return this.load(reader, new BoboSegmentReader.WorkArea());
    }

    @Override
    public MultiValueFacetDataCache load(BoboSegmentReader reader, BoboSegmentReader.WorkArea workArea) throws IOException {
        MultiValueFacetDataCache dataCache = new MultiValueFacetDataCache();
        dataCache.setMaxItems(this.maxItems);
        if (this.sizePayloadTerm == null) {
            dataCache.load(this._indexFieldName, (AtomicReader)reader, this._termListFactory, workArea);
        } else {
            dataCache.load(this._indexFieldName, (AtomicReader)reader, this._termListFactory, this.sizePayloadTerm);
        }
        return dataCache;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }
}

