/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.ComparatorFactory;
import com.browseengine.bobo.api.FieldValueAccessor;
import com.browseengine.bobo.util.BigSegmentedArray;
import com.browseengine.bobo.util.IntBoundedPriorityQueue;
import java.util.Comparator;

public class FacetHitcountComparatorFactory
implements ComparatorFactory {
    public static final Comparator<BrowseFacet> FACET_HITS_COMPARATOR = new Comparator<BrowseFacet>(){

        @Override
        public int compare(BrowseFacet f1, BrowseFacet f2) {
            int val = f2.getFacetValueHitCount() - f1.getFacetValueHitCount();
            if (val == 0) {
                val = f1.getValue().compareTo(f2.getValue());
            }
            return val;
        }
    };

    @Override
    public IntBoundedPriorityQueue.IntComparator newComparator(FieldValueAccessor valueList, final BigSegmentedArray counts) {
        return new IntBoundedPriorityQueue.IntComparator(){

            @Override
            public int compare(Integer f1, Integer f2) {
                int val = counts.get(f1) - counts.get(f2);
                if (val == 0) {
                    val = f2 - f1;
                }
                return val;
            }

            @Override
            public int compare(int f1, int f2) {
                int val = counts.get(f1) - counts.get(f2);
                if (val == 0) {
                    val = f2 - f1;
                }
                return val;
            }
        };
    }

    @Override
    public Comparator<BrowseFacet> newComparator() {
        return FACET_HITS_COMPARATOR;
    }
}

