/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.RuntimeFacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.impl.PathFacetIterator;
import com.browseengine.bobo.facets.impl.RangeFacetCountCollector;
import com.browseengine.bobo.facets.impl.RangeFacetHandler;
import com.browseengine.bobo.sort.DocComparatorSource;
import com.browseengine.bobo.util.ListMerger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public abstract class DynamicRangeFacetHandler
extends RuntimeFacetHandler<FacetHandler.FacetDataNone> {
    protected final String _dataFacetName;
    protected RangeFacetHandler _dataFacetHandler;

    public DynamicRangeFacetHandler(String name, String dataFacetName) {
        super(name, new HashSet<String>(Arrays.asList(dataFacetName)));
        this._dataFacetName = dataFacetName;
    }

    protected abstract String buildRangeString(String var1);

    protected abstract List<String> buildAllRangeStrings();

    protected abstract String getValueFromRangeString(String var1);

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String val, Properties props) throws IOException {
        return this._dataFacetHandler.buildRandomAccessFilter(this.buildRangeString(val), props);
    }

    @Override
    public RandomAccessFilter buildRandomAccessAndFilter(String[] vals, Properties prop) throws IOException {
        ArrayList<String> valList = new ArrayList<String>(vals.length);
        for (String val : vals) {
            valList.add(this.buildRangeString(val));
        }
        return this._dataFacetHandler.buildRandomAccessAndFilter(valList.toArray(new String[valList.size()]), prop);
    }

    @Override
    public RandomAccessFilter buildRandomAccessOrFilter(String[] vals, Properties prop, boolean isNot) throws IOException {
        ArrayList<String> valList = new ArrayList<String>(vals.length);
        for (String val : vals) {
            valList.add(this.buildRangeString(val));
        }
        return this._dataFacetHandler.buildRandomAccessOrFilter(valList.toArray(new String[valList.size()]), prop, isNot);
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(BrowseSelection sel, final FacetSpec fspec) {
        final List<String> list = this.buildAllRangeStrings();
        return new FacetCountCollectorSource(){

            @Override
            public FacetCountCollector getFacetCountCollector(BoboSegmentReader reader, int docBase) {
                FacetDataCache dataCache = (FacetDataCache)DynamicRangeFacetHandler.this._dataFacetHandler.getFacetData(reader);
                return new DynamicRangeFacetCountCollector(DynamicRangeFacetHandler.this.getName(), dataCache, docBase, fspec, list);
            }
        };
    }

    @Override
    public String[] getFieldValues(BoboSegmentReader reader, int docid) {
        return this._dataFacetHandler.getFieldValues(reader, docid);
    }

    @Override
    public Object[] getRawFieldValues(BoboSegmentReader reader, int docid) {
        return this._dataFacetHandler.getRawFieldValues(reader, docid);
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        return this._dataFacetHandler.getDocComparatorSource();
    }

    @Override
    public FacetHandler.FacetDataNone load(BoboSegmentReader reader) throws IOException {
        this._dataFacetHandler = (RangeFacetHandler)this.getDependedFacetHandler(this._dataFacetName);
        return FacetHandler.FacetDataNone.instance;
    }

    private class DynamicRangeFacetCountCollector
    extends RangeFacetCountCollector {
        DynamicRangeFacetCountCollector(String name, FacetDataCache<?> dataCache, int docBase, FacetSpec fspec, List<String> predefinedList) {
            super(name, dataCache, docBase, fspec, predefinedList);
        }

        @Override
        public BrowseFacet getFacet(String value) {
            String rangeString = DynamicRangeFacetHandler.this.buildRangeString(value);
            BrowseFacet facet = super.getFacet(rangeString);
            if (facet != null) {
                return new BrowseFacet(value, facet.getFacetValueHitCount());
            }
            return null;
        }

        @Override
        public int getFacetHitsCount(Object value) {
            String rangeString = DynamicRangeFacetHandler.this.buildRangeString((String)value);
            return super.getFacetHitsCount(rangeString);
        }

        @Override
        public List<BrowseFacet> getFacets() {
            List<BrowseFacet> list = super.getFacets();
            ArrayList<BrowseFacet> retList = new ArrayList<BrowseFacet>(list.size());
            for (BrowseFacet facet : list) {
                String val = facet.getValue();
                String rangeString = DynamicRangeFacetHandler.this.getValueFromRangeString(val);
                if (rangeString == null) continue;
                BrowseFacet convertedFacet = new BrowseFacet(rangeString, facet.getFacetValueHitCount());
                retList.add(convertedFacet);
            }
            return retList;
        }

        @Override
        public FacetIterator iterator() {
            FacetIterator iter = super.iterator();
            ArrayList<BrowseFacet> facets = new ArrayList<BrowseFacet>();
            while (iter.hasNext()) {
                Object facet = iter.next();
                int count = iter.count;
                facets.add(new BrowseFacet(DynamicRangeFacetHandler.this.getValueFromRangeString(String.valueOf(facet)), count));
            }
            Collections.sort(facets, ListMerger.FACET_VAL_COMPARATOR);
            return new PathFacetIterator(facets);
        }
    }
}

