/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.DoubleFacetIterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CombinedDoubleFacetIterator
extends DoubleFacetIterator {
    public double facet;
    private final DoubleFacetPriorityQueue _queue = new DoubleFacetPriorityQueue();
    private List<DoubleFacetIterator> _iterators;

    private CombinedDoubleFacetIterator(int length) {
        this._queue.initialize(length);
    }

    public CombinedDoubleFacetIterator(List<DoubleFacetIterator> iterators) {
        this(iterators.size());
        this._iterators = iterators;
        for (DoubleFacetIterator iterator : iterators) {
            DoubleIteratorNode node = new DoubleIteratorNode(iterator);
            if (!node.fetch(1)) continue;
            this._queue.add(node);
        }
        this.facet = Double.MIN_VALUE;
        this.count = 0;
    }

    public CombinedDoubleFacetIterator(List<DoubleFacetIterator> iterators, int minHits) {
        this(iterators.size());
        this._iterators = iterators;
        for (DoubleFacetIterator iterator : iterators) {
            DoubleIteratorNode node = new DoubleIteratorNode(iterator);
            if (!node.fetch(minHits)) continue;
            this._queue.add(node);
        }
        this.facet = Double.MIN_VALUE;
        this.count = 0;
    }

    public String getFacet() {
        if (this.facet == Double.MIN_VALUE) {
            return null;
        }
        return this.format(this.facet);
    }

    @Override
    public String format(double val) {
        return this._iterators.get(0).format(val);
    }

    @Override
    public String format(Object val) {
        return this._iterators.get(0).format(val);
    }

    public int getFacetCount() {
        return this.count;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more facets in this iteration");
        }
        DoubleIteratorNode node = this._queue.top();
        this.facet = node._curFacet;
        double next = Double.MIN_VALUE;
        this.count = 0;
        while (this.hasNext()) {
            node = this._queue.top();
            next = node._curFacet;
            if (next != Double.MIN_VALUE && next != this.facet) {
                return this.format(this.facet);
            }
            this.count += node._curFacetCount;
            if (node.fetch(1)) {
                this._queue.updateTop();
                continue;
            }
            this._queue.pop();
        }
        return null;
    }

    public String next(int minHits) {
        int qsize = this._queue.size();
        if (qsize == 0) {
            this.facet = Double.MIN_VALUE;
            this.count = 0;
            return null;
        }
        DoubleIteratorNode node = this._queue.top();
        this.facet = node._curFacet;
        this.count = node._curFacetCount;
        while (true) {
            if (node.fetch(minHits)) {
                node = this._queue.updateTop();
            } else {
                this._queue.pop();
                if (--qsize > 0) {
                    node = this._queue.top();
                } else {
                    if (this.count >= minHits) break;
                    this.facet = Double.MIN_VALUE;
                    this.count = 0;
                    return null;
                }
            }
            double next = node._curFacet;
            if (next != this.facet) {
                if (this.count >= minHits) break;
                this.facet = next;
                this.count = node._curFacetCount;
                continue;
            }
            this.count += node._curFacetCount;
        }
        return this.format(this.facet);
    }

    @Override
    public boolean hasNext() {
        return this._queue.size() > 0;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method not supported for Facet Iterators");
    }

    @Override
    public double nextDouble() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more facets in this iteration");
        }
        DoubleIteratorNode node = this._queue.top();
        this.facet = node._curFacet;
        double next = Double.MIN_VALUE;
        this.count = 0;
        while (this.hasNext()) {
            node = this._queue.top();
            next = node._curFacet;
            if (next != Double.MIN_VALUE && next != this.facet) {
                return this.facet;
            }
            this.count += node._curFacetCount;
            if (node.fetch(1)) {
                this._queue.updateTop();
                continue;
            }
            this._queue.pop();
        }
        return Double.MIN_VALUE;
    }

    @Override
    public double nextDouble(int minHits) {
        int qsize = this._queue.size();
        if (qsize == 0) {
            this.facet = Double.MIN_VALUE;
            this.count = 0;
            return Double.MIN_VALUE;
        }
        DoubleIteratorNode node = this._queue.top();
        this.facet = node._curFacet;
        this.count = node._curFacetCount;
        while (true) {
            if (node.fetch(minHits)) {
                node = this._queue.updateTop();
            } else {
                this._queue.pop();
                if (--qsize > 0) {
                    node = this._queue.top();
                } else {
                    if (this.count >= minHits) break;
                    this.facet = Double.MIN_VALUE;
                    this.count = 0;
                    break;
                }
            }
            double next = node._curFacet;
            if (next != this.facet) {
                if (this.count >= minHits) break;
                this.facet = next;
                this.count = node._curFacetCount;
                continue;
            }
            this.count += node._curFacetCount;
        }
        return this.facet;
    }

    public static class DoubleFacetPriorityQueue {
        private int size;
        private int maxSize;
        protected DoubleIteratorNode[] heap;

        protected final void initialize(int maxSize) {
            this.size = 0;
            int heapSize = 0 == maxSize ? 2 : maxSize + 1;
            this.heap = new DoubleIteratorNode[heapSize];
            this.maxSize = maxSize;
        }

        public final void put(DoubleIteratorNode element) {
            ++this.size;
            this.heap[this.size] = element;
            this.upHeap();
        }

        public final DoubleIteratorNode add(DoubleIteratorNode element) {
            ++this.size;
            this.heap[this.size] = element;
            this.upHeap();
            return this.heap[1];
        }

        public boolean insert(DoubleIteratorNode element) {
            return this.insertWithOverflow(element) != element;
        }

        public DoubleIteratorNode insertWithOverflow(DoubleIteratorNode element) {
            if (this.size < this.maxSize) {
                this.put(element);
                return null;
            }
            if (this.size > 0 && !(element._curFacet < this.heap[1]._curFacet)) {
                DoubleIteratorNode ret = this.heap[1];
                this.heap[1] = element;
                this.adjustTop();
                return ret;
            }
            return element;
        }

        public final DoubleIteratorNode top() {
            return this.heap[1];
        }

        public final DoubleIteratorNode pop() {
            if (this.size > 0) {
                DoubleIteratorNode result = this.heap[1];
                this.heap[1] = this.heap[this.size];
                this.heap[this.size] = null;
                --this.size;
                this.downHeap();
                return result;
            }
            return null;
        }

        public final void adjustTop() {
            this.downHeap();
        }

        public final DoubleIteratorNode updateTop() {
            this.downHeap();
            return this.heap[1];
        }

        public final int size() {
            return this.size;
        }

        public final void clear() {
            for (int i = 0; i <= this.size; ++i) {
                this.heap[i] = null;
            }
            this.size = 0;
        }

        private final void upHeap() {
            int i = this.size;
            DoubleIteratorNode node = this.heap[i];
            for (int j = i >>> 1; j > 0 && node._curFacet < this.heap[j]._curFacet; j >>>= 1) {
                this.heap[i] = this.heap[j];
                i = j;
            }
            this.heap[i] = node;
        }

        private final void downHeap() {
            int i = 1;
            DoubleIteratorNode node = this.heap[i];
            int j = i << 1;
            int k = j + 1;
            if (k <= this.size && this.heap[k]._curFacet < this.heap[j]._curFacet) {
                j = k;
            }
            while (j <= this.size && this.heap[j]._curFacet < node._curFacet) {
                this.heap[i] = this.heap[j];
                i = j;
                k = (j = i << 1) + 1;
                if (k > this.size || !(this.heap[k]._curFacet < this.heap[j]._curFacet)) continue;
                j = k;
            }
            this.heap[i] = node;
        }
    }

    private static class DoubleIteratorNode {
        public DoubleFacetIterator _iterator;
        public double _curFacet;
        public int _curFacetCount;

        public DoubleIteratorNode(DoubleFacetIterator iterator) {
            this._iterator = iterator;
            this._curFacet = Double.MIN_VALUE;
            this._curFacetCount = 0;
        }

        public boolean fetch(int minHits) {
            if (minHits > 0) {
                minHits = 1;
            }
            if ((this._curFacet = this._iterator.nextDouble(minHits)) != Double.MIN_VALUE) {
                this._curFacetCount = this._iterator.count;
                return true;
            }
            this._curFacet = Double.MIN_VALUE;
            this._curFacetCount = 0;
            return false;
        }
    }
}

