/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.docidset.NotDocIdSet;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;

public class RandomAccessNotFilter
extends RandomAccessFilter {
    protected final RandomAccessFilter _innerFilter;

    public RandomAccessNotFilter(RandomAccessFilter innerFilter) {
        this._innerFilter = innerFilter;
    }

    @Override
    public double getFacetSelectivity(BoboSegmentReader reader) {
        double selectivity = this._innerFilter.getFacetSelectivity(reader);
        selectivity = selectivity > 0.999 ? 0.0 : 1.0 - selectivity;
        return selectivity;
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboSegmentReader reader) throws IOException {
        final RandomAccessDocIdSet innerDocIdSet = this._innerFilter.getRandomAccessDocIdSet(reader);
        final NotDocIdSet notInnerDocIdSet = new NotDocIdSet(innerDocIdSet, reader.maxDoc());
        return new RandomAccessDocIdSet(){

            @Override
            public boolean get(int docId) {
                return !innerDocIdSet.get(docId);
            }

            public DocIdSetIterator iterator() throws IOException {
                return notInnerDocIdSet.iterator();
            }
        };
    }
}

