/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.filter.FacetRangeFilter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.impl.GeoSimpleFacetHandler;
import com.browseengine.bobo.util.BigSegmentedArray;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;

public final class GeoSimpleFacetFilter
extends RandomAccessFilter {
    private final FacetHandler<FacetDataCache<?>> _latFacetHandler;
    private final FacetHandler<FacetDataCache<?>> _longFacetHandler;
    private final String _latRangeString;
    private final String _longRangeString;

    public GeoSimpleFacetFilter(FacetHandler<FacetDataCache<?>> latHandler, FacetHandler<FacetDataCache<?>> longHandler, String latRangeString, String longRangeString) {
        this._latFacetHandler = latHandler;
        this._longFacetHandler = longHandler;
        this._latRangeString = latRangeString;
        this._longRangeString = longRangeString;
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboSegmentReader reader) throws IOException {
        final FacetDataCache<?> latDataCache = this._latFacetHandler.getFacetData(reader);
        final FacetDataCache<?> longDataCache = this._longFacetHandler.getFacetData(reader);
        final int[] latRange = FacetRangeFilter.parse(latDataCache, this._latRangeString);
        final int[] longRange = FacetRangeFilter.parse(longDataCache, this._longRangeString);
        if (latRange == null || longRange == null) {
            return null;
        }
        return new RandomAccessDocIdSet(){
            int _latStart;
            int _latEnd;
            int _longStart;
            int _longEnd;
            {
                this._latStart = latRange[0];
                this._latEnd = latRange[1];
                this._longStart = longRange[0];
                this._longEnd = longRange[1];
            }

            @Override
            public final boolean get(int docid) {
                int latIndex = latDataCache.orderArray.get(docid);
                int longIndex = longDataCache.orderArray.get(docid);
                return latIndex >= this._latStart && latIndex <= this._latEnd && longIndex >= this._longStart && longIndex <= this._longEnd;
            }

            public DocIdSetIterator iterator() {
                return new GeoSimpleDocIdSetIterator(this._latStart, this._latEnd, this._longStart, this._longEnd, latDataCache, longDataCache);
            }
        };
    }

    public static int[] parse(FacetDataCache<?> latDataCache, FacetDataCache<?> longDataCache, String rangeString) {
        int longEnd;
        int latEnd;
        int longStart;
        int latStart;
        GeoSimpleFacetHandler.GeoLatLonRange range = GeoSimpleFacetHandler.GeoLatLonRange.parse(rangeString);
        String latLower = String.valueOf(range.latStart);
        String latUpper = String.valueOf(range.latEnd);
        String longLower = String.valueOf(range.lonStart);
        String longUpper = String.valueOf(range.lonEnd);
        if (latLower == null) {
            latStart = 1;
        } else {
            latStart = latDataCache.valArray.indexOf(latLower);
            if (latStart < 0) {
                latStart = -(latStart + 1);
            }
        }
        if (longLower == null) {
            longStart = 1;
        } else {
            longStart = longDataCache.valArray.indexOf(longLower);
            if (longStart < 0) {
                longStart = -(longStart + 1);
            }
        }
        if (latUpper == null) {
            latEnd = latDataCache.valArray.size() - 1;
        } else {
            latEnd = latDataCache.valArray.indexOf(latUpper);
            if (latEnd < 0) {
                latEnd = -(latEnd + 1);
                latEnd = Math.max(0, latEnd - 1);
            }
        }
        if (longUpper == null) {
            longEnd = longDataCache.valArray.size() - 1;
        } else {
            longEnd = longDataCache.valArray.indexOf(longUpper);
            if (longEnd < 0) {
                longEnd = -(longEnd + 1);
                longEnd = Math.max(0, longEnd - 1);
            }
        }
        return new int[]{latStart, latEnd, longStart, longEnd};
    }

    private static final class GeoSimpleDocIdSetIterator
    extends DocIdSetIterator {
        private int _doc = -1;
        private int _minID = Integer.MAX_VALUE;
        private int _maxID = -1;
        private final int _latStart;
        private final int _latEnd;
        private final int _longStart;
        private final int _longEnd;
        private final BigSegmentedArray _latOrderArray;

        GeoSimpleDocIdSetIterator(int latStart, int latEnd, int longStart, int longEnd, FacetDataCache<?> latDataCache, FacetDataCache<?> longDataCache) {
            int i;
            this._latStart = latStart;
            this._longStart = longStart;
            this._latEnd = latEnd;
            this._longEnd = longEnd;
            for (i = latStart; i <= latEnd; ++i) {
                this._minID = Math.min(this._minID, latDataCache.minIDs[i]);
                this._maxID = Math.max(this._maxID, latDataCache.maxIDs[i]);
            }
            for (i = longStart; i <= longEnd; ++i) {
                this._minID = Math.min(this._minID, longDataCache.minIDs[i]);
                this._maxID = Math.max(this._maxID, longDataCache.maxIDs[i]);
            }
            this._doc = Math.max(-1, this._minID - 1);
            this._latOrderArray = latDataCache.orderArray;
        }

        public final int docID() {
            return this._doc;
        }

        public final int nextDoc() throws IOException {
            while (++this._doc < this._maxID) {
                int latIndex = this._latOrderArray.get(this._doc);
                int longIndex = this._latOrderArray.get(this._doc);
                if (latIndex < this._latStart || latIndex > this._latEnd || longIndex < this._longStart || longIndex > this._longEnd) continue;
                return this._doc;
            }
            return Integer.MAX_VALUE;
        }

        public final int advance(int id) throws IOException {
            if (this._doc < id) {
                this._doc = id - 1;
            }
            while (++this._doc < this._maxID) {
                int latIndex = this._latOrderArray.get(this._doc);
                int longIndex = this._latOrderArray.get(this._doc);
                if (latIndex < this._latStart || latIndex > this._latEnd || longIndex < this._longStart || longIndex > this._longEnd) continue;
                return this._doc;
            }
            return Integer.MAX_VALUE;
        }

        public long cost() {
            return 0L;
        }
    }
}

