/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.filter;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.docidset.EmptyDocIdSet;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.MultiValueFacetDataCache;
import com.browseengine.bobo.facets.filter.FacetValueConverter;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.util.BigNestedIntArray;
import com.browseengine.bobo.util.BigSegmentedArray;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;

public final class FacetRangeFilter
extends RandomAccessFilter {
    private final FacetHandler<FacetDataCache<?>> _facetHandler;
    private final String _rangeString;

    public FacetRangeFilter(FacetHandler<FacetDataCache<?>> facetHandler, String rangeString) {
        this._facetHandler = facetHandler;
        this._rangeString = rangeString;
    }

    @Override
    public double getFacetSelectivity(BoboSegmentReader reader) {
        double selectivity = 0.0;
        FacetDataCache<?> dataCache = this._facetHandler.getFacetData(reader);
        int[] range = FacetRangeFilter.parse(dataCache, this._rangeString);
        if (range != null) {
            int accumFreq = 0;
            for (int idx = range[0]; idx <= range[1]; ++idx) {
                accumFreq += dataCache.freqs[idx];
            }
            int total = reader.maxDoc();
            selectivity = (double)accumFreq / (double)total;
        }
        if (selectivity > 0.999) {
            selectivity = 1.0;
        }
        return selectivity;
    }

    public static int[] convertIndexes(FacetDataCache<?> dataCache, String[] vals) {
        IntArrayList list = new IntArrayList();
        for (String val : vals) {
            int[] range = FacetRangeFilter.parse(dataCache, val);
            if (range == null) continue;
            for (int i = range[0]; i <= range[1]; ++i) {
                list.add(i);
            }
        }
        return list.toIntArray();
    }

    public static int[] parse(FacetDataCache<?> dataCache, String rangeString) {
        int end;
        int start;
        String[] ranges = FacetRangeFilter.getRangeStrings(rangeString);
        String lower = ranges[0];
        String upper = ranges[1];
        String includeLower = ranges[2];
        String includeUpper = ranges[3];
        boolean incLower = true;
        boolean incUpper = true;
        if ("false".equals(includeLower)) {
            incLower = false;
        }
        if ("false".equals(includeUpper)) {
            incUpper = false;
        }
        if ("*".equals(lower)) {
            lower = null;
        }
        if ("*".equals(upper)) {
            upper = null;
        }
        if (lower == null) {
            start = 1;
        } else {
            start = dataCache.valArray.indexOf(lower);
            if (start < 0) {
                start = -(start + 1);
            } else if (!incLower) {
                ++start;
            }
        }
        if (upper == null) {
            end = dataCache.valArray.size() - 1;
        } else {
            end = dataCache.valArray.indexOf(upper);
            if (end < 0) {
                end = -(end + 1) - 1;
            } else if (!incUpper) {
                // empty if block
            }
        }
        return new int[]{start, --end};
    }

    public static String[] getRangeStrings(String rangeString) {
        int index2 = rangeString.indexOf(" TO ");
        boolean incLower = true;
        boolean incUpper = true;
        if (rangeString.trim().startsWith("(")) {
            incLower = false;
        }
        if (rangeString.trim().endsWith(")")) {
            incUpper = false;
        }
        int index = -1;
        int index3 = -1;
        if (incLower) {
            index = rangeString.indexOf(91);
        } else if (!incLower) {
            index = rangeString.indexOf(40);
        }
        if (incUpper) {
            index3 = rangeString.indexOf(93);
        } else if (!incUpper) {
            index3 = rangeString.indexOf(41);
        }
        String lower = rangeString.substring(index + 1, index2).trim();
        String upper = rangeString.substring(index2 + 4, index3).trim();
        return new String[]{lower, upper, String.valueOf(incLower), String.valueOf(incUpper)};
    }

    @Override
    public RandomAccessDocIdSet getRandomAccessDocIdSet(BoboSegmentReader reader) throws IOException {
        final FacetDataCache<?> dataCache = this._facetHandler.getFacetData(reader);
        final boolean multi = dataCache instanceof MultiValueFacetDataCache;
        final BigNestedIntArray nestedArray = multi ? ((MultiValueFacetDataCache)dataCache)._nestedArray : null;
        final int[] range = FacetRangeFilter.parse(dataCache, this._rangeString);
        if (range == null) {
            return null;
        }
        if (range[0] > range[1]) {
            return EmptyDocIdSet.getInstance();
        }
        return new RandomAccessDocIdSet(){
            int _start;
            int _end;
            {
                this._start = range[0];
                this._end = range[1];
            }

            @Override
            public final boolean get(int docId) {
                int index;
                if (multi) {
                    nestedArray.containsValueInRange(docId, this._start, this._end);
                }
                return (index = dataCache.orderArray.get(docId)) >= this._start && index <= this._end;
            }

            public DocIdSetIterator iterator() {
                if (multi) {
                    return new MultiFacetRangeDocIdSetIterator(this._start, this._end, (MultiValueFacetDataCache)dataCache);
                }
                return new FacetRangeDocIdSetIterator(this._start, this._end, dataCache);
            }
        };
    }

    public static class FacetRangeValueConverter
    implements FacetValueConverter {
        public static FacetRangeValueConverter instance = new FacetRangeValueConverter();

        private FacetRangeValueConverter() {
        }

        @Override
        public int[] convert(FacetDataCache<String> dataCache, String[] vals) {
            return FacetRangeFilter.convertIndexes(dataCache, vals);
        }
    }

    private static final class MultiFacetRangeDocIdSetIterator
    extends DocIdSetIterator {
        private int _doc = -1;
        private int _minID = Integer.MAX_VALUE;
        private int _maxID = -1;
        private final int _start;
        private final int _end;
        private final BigNestedIntArray nestedArray;

        MultiFacetRangeDocIdSetIterator(int start, int end, MultiValueFacetDataCache<?> dataCache) {
            this._start = start;
            this._end = end;
            for (int i = start; i <= end; ++i) {
                this._minID = Math.min(this._minID, dataCache.minIDs[i]);
                this._maxID = Math.max(this._maxID, dataCache.maxIDs[i]);
            }
            this._doc = Math.max(-1, this._minID - 1);
            this.nestedArray = dataCache._nestedArray;
        }

        public final int docID() {
            return this._doc;
        }

        public final int nextDoc() throws IOException {
            this._doc = this._doc < this._maxID ? this.nestedArray.findValuesInRange(this._start, this._end, this._doc + 1, this._maxID) : Integer.MAX_VALUE;
            return this._doc;
        }

        public final int advance(int id) throws IOException {
            if (this._doc < id) {
                this._doc = id <= this._maxID ? this.nestedArray.findValuesInRange(this._start, this._end, id, this._maxID) : Integer.MAX_VALUE;
                return this._doc;
            }
            return this.nextDoc();
        }

        public long cost() {
            return 0L;
        }
    }

    private static final class FacetRangeDocIdSetIterator
    extends DocIdSetIterator {
        private int _doc = -1;
        private int _minID = Integer.MAX_VALUE;
        private int _maxID = -1;
        private final int _start;
        private final int _end;
        private final BigSegmentedArray _orderArray;

        FacetRangeDocIdSetIterator(int start, int end, FacetDataCache<?> dataCache) {
            this._start = start;
            this._end = end;
            for (int i = start; i <= end; ++i) {
                this._minID = Math.min(this._minID, dataCache.minIDs[i]);
                this._maxID = Math.max(this._maxID, dataCache.maxIDs[i]);
            }
            this._doc = Math.max(-1, this._minID - 1);
            this._orderArray = dataCache.orderArray;
        }

        public final int docID() {
            return this._doc;
        }

        public final int nextDoc() throws IOException {
            this._doc = this._doc < this._maxID ? this._orderArray.findValueRange(this._start, this._end, this._doc + 1, this._maxID) : Integer.MAX_VALUE;
            return this._doc;
        }

        public final int advance(int id) throws IOException {
            if (this._doc < id) {
                this._doc = id <= this._maxID ? this._orderArray.findValueRange(this._start, this._end, id, this._maxID) : Integer.MAX_VALUE;
                return this._doc;
            }
            return this.nextDoc();
        }

        public long cost() {
            return 0L;
        }
    }
}

