/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.facets.data.TermIntList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class TermValueList<T>
implements List<String> {
    protected Class<T> _type;
    protected List<?> _innerList;

    protected abstract List<?> buildPrimitiveList(int var1);

    public abstract String format(Object var1);

    public abstract void seal();

    protected TermValueList() {
        this._innerList = this.buildPrimitiveList(-1);
    }

    protected TermValueList(int capacity) {
        this._innerList = this.buildPrimitiveList(capacity);
    }

    public List<?> getInnerList() {
        return this._innerList;
    }

    @Override
    public abstract boolean add(String var1);

    @Override
    public void add(int index, String element) {
        throw new IllegalStateException("not supported");
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        boolean ret = true;
        for (String string : c) {
            ret &= this.add(string);
        }
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c) {
        throw new IllegalStateException("not supported");
    }

    @Override
    public void clear() {
        this._innerList.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    public abstract boolean containsWithType(T var1);

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new IllegalStateException("not supported");
    }

    public Class<T> getType() {
        return this._type;
    }

    @Override
    public String get(int index) {
        return this.format(this._innerList.get(index));
    }

    public T getRawValue(int index) {
        return (T)this._innerList.get(index);
    }

    public Comparable<?> getComparableValue(int index) {
        return (Comparable)this._innerList.get(index);
    }

    @Override
    public abstract int indexOf(Object var1);

    public int indexOfWithOffset(Object value, int offset) {
        throw new IllegalStateException("not supported");
    }

    public abstract int indexOfWithType(T var1);

    @Override
    public boolean isEmpty() {
        return this._innerList.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        final Iterator<?> iter = this._innerList.iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public String next() {
                return TermValueList.this.format(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public ListIterator<String> listIterator() {
        throw new IllegalStateException("not supported");
    }

    @Override
    public ListIterator<String> listIterator(int index) {
        throw new IllegalStateException("not supported");
    }

    @Override
    public boolean remove(Object o) {
        throw new IllegalStateException("not supported");
    }

    @Override
    public String remove(int index) {
        throw new IllegalStateException("not supported");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new IllegalStateException("not supported");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new IllegalStateException("not supported");
    }

    @Override
    public String set(int index, String element) {
        throw new IllegalStateException("not supported");
    }

    @Override
    public int size() {
        return this._innerList.size();
    }

    @Override
    public List<String> subList(int fromIndex, int toIndex) {
        throw new IllegalStateException("not supported");
    }

    @Override
    public Object[] toArray() {
        Object[] array = this._innerList.toArray();
        Object[] retArray = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            retArray[i] = this.format(array[i]);
        }
        return retArray;
    }

    @Override
    public <R> R[] toArray(R[] a) {
        List<String> l = this.subList(0, this.size());
        return l.toArray(a);
    }

    public static void main(String[] args) {
        int numIter = 20000;
        TermIntList list = new TermIntList();
        for (int i = 0; i < numIter; ++i) {
            list.add(String.valueOf(i));
        }
        long start = System.currentTimeMillis();
        List<?> rawList = list.getInnerList();
        for (int i = 0; i < numIter; ++i) {
            rawList.get(i);
        }
        long end = System.currentTimeMillis();
        System.out.println("took: " + (end - start));
    }
}

