/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.facets.data.TermNumberList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;

public class TermLongList
extends TermNumberList<Long> {
    protected long[] _elements = null;
    private boolean withDummy = true;
    public static final long VALUE_MISSING = Long.MIN_VALUE;

    protected long parse(String s) {
        if (s == null || s.length() == 0) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    public TermLongList() {
    }

    public TermLongList(int capacity, String formatString) {
        super(capacity, formatString);
    }

    public TermLongList(String formatString) {
        super(formatString);
    }

    @Override
    public boolean add(String o) {
        if (this._innerList.size() == 0 && o != null) {
            this.withDummy = false;
        }
        long item = this.parse(o);
        return ((LongArrayList)this._innerList).add(item);
    }

    @Override
    protected List<?> buildPrimitiveList(int capacity) {
        this._type = Long.class;
        return capacity > 0 ? new LongArrayList(capacity) : new LongArrayList();
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public String get(int index) {
        DecimalFormat formatter = (DecimalFormat)this._formatter.get();
        long val = this._elements[index];
        if (this.withDummy && index == 0) {
            val = 0L;
        }
        if (formatter == null) {
            return String.valueOf(val);
        }
        return formatter.format(val);
    }

    public long getPrimitiveValue(int index) {
        if (index < this._elements.length) {
            return this._elements[index];
        }
        return Long.MIN_VALUE;
    }

    @Override
    public int indexOf(Object o) {
        if (this.withDummy) {
            if (o == null) {
                return -1;
            }
            long val = o instanceof String ? this.parse((String)o) : ((Long)o).longValue();
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        long val = o instanceof String ? this.parse((String)o) : ((Long)o).longValue();
        return Arrays.binarySearch(this._elements, val);
    }

    public int indexOf(Long value) {
        if (this.withDummy) {
            if (value == null) {
                return -1;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, value);
        }
        return Arrays.binarySearch(this._elements, value);
    }

    public int indexOf(long val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public int indexOfWithType(Long val) {
        if (this.withDummy) {
            if (val == null) {
                return -1;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public int indexOfWithType(long val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public void seal() {
        int negativeIndexCheck;
        ((LongArrayList)this._innerList).trim();
        this._elements = ((LongArrayList)this._innerList).elements();
        int n = negativeIndexCheck = this.withDummy ? 1 : 0;
        if (this._elements.length > negativeIndexCheck && this._elements[negativeIndexCheck] < 0L) {
            int endPosition = this.indexOfWithType(0L);
            if (endPosition < 0) {
                endPosition = -1 * endPosition - 1;
            }
            for (int i = 0; i < (endPosition - negativeIndexCheck) / 2; ++i) {
                long tmp = this._elements[i + negativeIndexCheck];
                this._elements[i + negativeIndexCheck] = this._elements[endPosition - i - 1];
                this._elements[endPosition - i - 1] = tmp;
            }
        }
    }

    @Override
    protected Object parseString(String o) {
        return this.parse(o);
    }

    public boolean contains(long val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    @Override
    public boolean containsWithType(Long val) {
        if (this.withDummy) {
            if (val == null) {
                return false;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    @Override
    public boolean containsWithType(long val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    public long[] getElements() {
        return this._elements;
    }

    @Override
    public double getDoubleValue(int index) {
        return this._elements[index];
    }
}

