/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.api.BoboSegmentReader;
import com.browseengine.bobo.facets.data.MultiValueFacetDataCache;
import com.browseengine.bobo.facets.data.TermListFactory;
import com.browseengine.bobo.facets.data.TermStringList;
import com.browseengine.bobo.facets.data.TermValueList;
import com.browseengine.bobo.util.BigNestedIntArray;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.OpenBitSet;

public class MultiValueWithWeightFacetDataCache<T>
extends MultiValueFacetDataCache<T> {
    private static final long serialVersionUID = 1L;
    public final BigNestedIntArray _weightArray = new BigNestedIntArray();

    @Override
    public void load(String fieldName, AtomicReader reader, TermListFactory<T> listFactory, BoboSegmentReader.WorkArea workArea) throws IOException {
        int doc;
        String field = fieldName.intern();
        int maxdoc = reader.maxDoc();
        BigNestedIntArray.BufferedLoader loader = this.getBufferedLoader(maxdoc, workArea);
        BigNestedIntArray.BufferedLoader weightLoader = this.getBufferedLoader(maxdoc, null);
        TermValueList list = listFactory == null ? new TermStringList() : listFactory.createTermList();
        IntArrayList minIDList = new IntArrayList();
        IntArrayList maxIDList = new IntArrayList();
        IntArrayList freqList = new IntArrayList();
        OpenBitSet bitset = new OpenBitSet((long)(maxdoc + 1));
        int negativeValueCount = this.getNegativeValueCount(reader, field);
        int t = 1;
        list.add(null);
        minIDList.add(-1);
        maxIDList.add(-1);
        freqList.add(0);
        this._overflow = false;
        String pre = null;
        int df = 0;
        int minID = -1;
        int maxID = -1;
        int docID = -1;
        int valId = 0;
        Terms terms = reader.terms(field);
        if (terms != null) {
            BytesRef text;
            TermsEnum termsEnum = terms.iterator(null);
            while ((text = termsEnum.next()) != null) {
                Term term;
                DocsEnum docsEnum;
                String strText = text.utf8ToString();
                String val = null;
                int weight = 0;
                String[] split = strText.split("\u0000");
                if (split.length <= 1) continue;
                val = split[0];
                weight = Integer.parseInt(split[split.length - 1]);
                if (pre == null || !val.equals(pre)) {
                    if (pre != null) {
                        freqList.add(df);
                        minIDList.add(minID);
                        maxIDList.add(maxID);
                    }
                    list.add(val);
                    df = 0;
                    minID = -1;
                    maxID = -1;
                    valId = t - 1 < negativeValueCount ? negativeValueCount - t + 1 : t;
                    ++t;
                }
                if ((docsEnum = reader.termDocsEnum(term = new Term(field, strText))) != null) {
                    while ((docID = docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                        ++df;
                        if (!loader.add(docID, valId)) {
                            this.logOverflow(fieldName);
                        } else {
                            weightLoader.add(docID, weight);
                        }
                        if (docID < minID) {
                            minID = docID;
                        }
                        bitset.fastSet(docID);
                        while (docsEnum.nextDoc() != Integer.MAX_VALUE) {
                            docID = docsEnum.docID();
                            ++df;
                            if (!loader.add(docID, valId)) {
                                this.logOverflow(fieldName);
                            } else {
                                weightLoader.add(docID, weight);
                            }
                            bitset.fastSet(docID);
                        }
                        if (docID <= maxID) continue;
                        maxID = docID;
                    }
                }
                pre = val;
            }
            if (pre != null) {
                freqList.add(df);
                minIDList.add(minID);
                maxIDList.add(maxID);
            }
        }
        list.seal();
        try {
            this._nestedArray.load(maxdoc + 1, loader);
            this._weightArray.load(maxdoc + 1, weightLoader);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load due to " + e.toString(), e);
        }
        this.valArray = list;
        this.freqs = freqList.toIntArray();
        this.minIDs = minIDList.toIntArray();
        this.maxIDs = maxIDList.toIntArray();
        for (doc = 0; doc < maxdoc && !this._nestedArray.contains(doc, 0, true); ++doc) {
        }
        if (doc < maxdoc) {
            this.minIDs[0] = doc;
            for (doc = maxdoc - 1; doc >= 0 && !this._nestedArray.contains(doc, 0, true); --doc) {
            }
            this.maxIDs[0] = doc;
        }
        this.freqs[0] = maxdoc - (int)bitset.cardinality();
    }
}

