/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.docidset;

import java.io.Serializable;
import java.lang.reflect.Array;

public abstract class PrimitiveArray<T>
implements Serializable {
    private static final long serialVersionUID = 4564518164881690599L;
    protected Object _array;
    protected int _count;
    protected int _growth;
    protected int _len;
    private static final int DEFAULT_SIZE = 1000;

    protected abstract Object buildArray(int var1);

    protected PrimitiveArray(int len) {
        if (len <= 0) {
            throw new IllegalArgumentException("len must be greater than 0: " + len);
        }
        this._array = this.buildArray(len);
        this._count = 0;
        this._growth = 10;
        this._len = len;
    }

    protected PrimitiveArray() {
        this(1000);
    }

    public void clear() {
        this._count = 0;
        this._growth = 10;
    }

    protected synchronized void expand() {
        this.expand(this._len + 100);
    }

    protected synchronized void expand(int idx) {
        if (idx <= this._len) {
            return;
        }
        int oldLen = this._len;
        this._len = idx + this._growth;
        Object newArray = this.buildArray(this._len);
        System.arraycopy(this._array, 0, newArray, 0, oldLen);
        this._growth += this._len;
        this._array = newArray;
    }

    public synchronized void ensureCapacity(int idx) {
        this.expand(idx);
    }

    public int size() {
        return this._count;
    }

    public synchronized void seal() {
        if (this._len > this._count) {
            Object newArray = this.buildArray(this._count);
            System.arraycopy(this._array, 0, newArray, 0, this._count);
            this._array = newArray;
            this._len = this._count;
        }
        this._growth = 10;
    }

    public synchronized T[] toArray(T[] array) {
        System.arraycopy(this._array, 0, array, 0, this._count);
        return array;
    }

    public synchronized Object toArray() {
        Object array = this.buildArray(this._count);
        System.arraycopy(this._array, 0, array, 0, this._count);
        return array;
    }

    public PrimitiveArray<T> clone() {
        try {
            PrimitiveArray obj = (PrimitiveArray)this.getClass().newInstance();
            obj._count = this._count;
            obj._growth = this._growth;
            obj._len = this._len;
            Object newArray = this.buildArray(this._len);
            System.arraycopy(this._array, 0, newArray, 0, this._count);
            obj._array = newArray;
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[");
        for (int i = 0; i < this._count; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(Array.get(this._array, i));
        }
        buffer.append(']');
        return buffer.toString();
    }

    public int length() {
        return this._len;
    }
}

