/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.docidset;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;

public class OrDocIdSetIterator
extends DocIdSetIterator {
    private int _curDoc = -1;
    private final Item[] _heap;
    private int _size;

    OrDocIdSetIterator(List<DocIdSet> sets) throws IOException {
        this._heap = new Item[sets.size()];
        this._size = 0;
        for (DocIdSet set : sets) {
            this._heap[this._size++] = new Item(set.iterator() == null ? DocIdSet.EMPTY_DOCIDSET.iterator() : set.iterator());
        }
        if (this._size == 0) {
            this._curDoc = Integer.MAX_VALUE;
        }
    }

    public final int docID() {
        return this._curDoc;
    }

    public final int nextDoc() throws IOException {
        int topDoc;
        if (this._curDoc == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        Item top = this._heap[0];
        do {
            DocIdSetIterator topIter;
            int docid;
            if ((docid = (topIter = top.iter).nextDoc()) != Integer.MAX_VALUE) {
                top.doc = docid;
                this.heapAdjust();
            } else {
                this.heapRemoveRoot();
                if (this._size == 0) {
                    this._curDoc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
            }
            top = this._heap[0];
        } while ((topDoc = top.doc) <= this._curDoc);
        this._curDoc = topDoc;
        return this._curDoc;
    }

    public final int advance(int target) throws IOException {
        int topDoc;
        if (this._curDoc == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (target <= this._curDoc) {
            target = this._curDoc + 1;
        }
        Item top = this._heap[0];
        do {
            DocIdSetIterator topIter;
            int docid;
            if ((docid = (topIter = top.iter).advance(target)) != Integer.MAX_VALUE) {
                top.doc = docid;
                this.heapAdjust();
            } else {
                this.heapRemoveRoot();
                if (this._size == 0) {
                    this._curDoc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
            }
            top = this._heap[0];
        } while ((topDoc = top.doc) < target);
        this._curDoc = topDoc;
        return this._curDoc;
    }

    private final void heapAdjust() {
        int lchild;
        Item[] heap = this._heap;
        Item top = heap[0];
        int doc = top.doc;
        int size = this._size;
        int i = 0;
        while ((lchild = (i << 1) + 1) < size) {
            Item left = heap[lchild];
            int ldoc = left.doc;
            int rchild = lchild + 1;
            if (rchild < size) {
                Item right = heap[rchild];
                int rdoc = right.doc;
                if (rdoc <= ldoc) {
                    if (doc <= rdoc) break;
                    heap[i] = right;
                    i = rchild;
                    continue;
                }
            }
            if (doc <= ldoc) break;
            heap[i] = left;
            i = lchild;
        }
        heap[i] = top;
    }

    private final void heapRemoveRoot() {
        --this._size;
        if (this._size > 0) {
            Item tmp = this._heap[0];
            this._heap[0] = this._heap[this._size];
            this._heap[this._size] = tmp;
            this.heapAdjust();
        }
    }

    public long cost() {
        return 0L;
    }

    private final class Item {
        public final DocIdSetIterator iter;
        public int doc;

        public Item(DocIdSetIterator iter) {
            this.iter = iter;
            this.doc = -1;
        }
    }
}

