/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.docidset;

import com.browseengine.bobo.docidset.ImmutableDocSet;
import com.browseengine.bobo.docidset.StatefulDSIterator;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;

public class AndDocIdSet
extends ImmutableDocSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ArrayList<Integer> _interSectionResult = new ArrayList();
    private List<DocIdSet> sets = null;
    private final int nonNullSize;

    public AndDocIdSet(List<DocIdSet> docSets) {
        this.sets = docSets;
        int size = 0;
        if (this.sets != null) {
            for (DocIdSet set : this.sets) {
                if (set == null) continue;
                ++size;
            }
        }
        this.nonNullSize = size;
    }

    public ArrayList<Integer> getIntersection() {
        return this._interSectionResult;
    }

    public final DocIdSetIterator iterator() throws IOException {
        return new AndDocIdSetIterator();
    }

    @Override
    public final int findWithIndex(int val) throws IOException {
        AndDocIdSetIterator finder = new AndDocIdSetIterator();
        int cursor = -1;
        try {
            int docid;
            while ((docid = finder.nextDoc()) != Integer.MAX_VALUE) {
                if (docid > val) {
                    return -1;
                }
                if (docid == val) {
                    return ++cursor;
                }
                ++cursor;
            }
        }
        catch (IOException e) {
            return -1;
        }
        return -1;
    }

    @Override
    public final boolean find(int val) throws IOException {
        AndDocIdSetIterator finder = new AndDocIdSetIterator();
        try {
            int docid = finder.advance(val);
            return docid != Integer.MAX_VALUE && docid == val;
        }
        catch (IOException e) {
            return false;
        }
    }

    class AndDocIdSetIterator
    extends DocIdSetIterator {
        int lastReturn = -1;
        private DocIdSetIterator[] iterators = null;

        AndDocIdSetIterator() throws IOException {
            if (AndDocIdSet.this.nonNullSize < 1) {
                throw new IllegalArgumentException("Minimum one iterator required");
            }
            this.iterators = new DocIdSetIterator[AndDocIdSet.this.nonNullSize];
            int j = 0;
            for (DocIdSet set : AndDocIdSet.this.sets) {
                if (set == null) continue;
                DocIdSetIterator dcit = set.iterator();
                if (dcit == null) {
                    dcit = DocIdSet.EMPTY_DOCIDSET.iterator();
                }
                this.iterators[j++] = dcit;
            }
            this.lastReturn = this.iterators.length > 0 ? -1 : Integer.MAX_VALUE;
        }

        public final int docID() {
            return this.lastReturn;
        }

        public final int nextDoc() throws IOException {
            if (this.lastReturn == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            DocIdSetIterator dcit = this.iterators[0];
            int target = dcit.nextDoc();
            int size = this.iterators.length;
            int skip = 0;
            int i = 1;
            while (i < size) {
                int docid;
                if (i != skip && (docid = (dcit = this.iterators[i]).advance(target)) > target) {
                    target = docid;
                    if (i != 0) {
                        skip = i;
                        i = 0;
                        continue;
                    }
                    skip = 0;
                }
                ++i;
            }
            this.lastReturn = target;
            return this.lastReturn;
        }

        public final int advance(int target) throws IOException {
            if (this.lastReturn == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            DocIdSetIterator dcit = this.iterators[0];
            target = dcit.advance(target);
            int size = this.iterators.length;
            int skip = 0;
            int i = 1;
            while (i < size) {
                int docid;
                if (i != skip && (docid = (dcit = this.iterators[i]).advance(target)) > target) {
                    target = docid;
                    if (i != 0) {
                        skip = i;
                        i = 0;
                        continue;
                    }
                    skip = 0;
                }
                ++i;
            }
            this.lastReturn = target;
            return this.lastReturn;
        }

        public long cost() {
            return 0L;
        }
    }

    public class DescDocIdSetComparator
    implements Comparator<StatefulDSIterator>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(StatefulDSIterator o1, StatefulDSIterator o2) {
            return o2.docID() - o1.docID();
        }
    }
}

