/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.api;

import com.browseengine.bobo.api.Browsable;
import com.browseengine.bobo.api.BrowseException;
import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseHit;
import com.browseengine.bobo.api.BrowseRequest;
import com.browseengine.bobo.api.BrowseResult;
import com.browseengine.bobo.api.FacetAccessible;
import com.browseengine.bobo.api.QueriesSupport;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.sort.SortCollector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.similarities.Similarity;

public class MultiBoboBrowser
extends MultiReader
implements Browsable {
    private static Logger logger = Logger.getLogger(MultiBoboBrowser.class);
    protected final Browsable[] _subBrowsers;

    public MultiBoboBrowser(Browsable[] browsers) throws IOException {
        super(MultiBoboBrowser.getSegmentReaders(browsers), false);
        this._subBrowsers = browsers;
    }

    private static IndexReader[] getSegmentReaders(Browsable[] browsers) {
        IndexReader[] readers = new IndexReader[browsers.length];
        for (int i = 0; i < browsers.length; ++i) {
            readers[i] = browsers[i].getIndexReader();
        }
        return readers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void browse(BrowseRequest req, Collector hc, Map<String, FacetAccessible> facetMap, int start) throws BrowseException {
        if (this._subBrowsers == null || this._subBrowsers.length == 0) {
            return;
        }
        try {
            Query q = req.getQuery();
            MatchAllDocsQuery matchAllDocsQuery = new MatchAllDocsQuery();
            if (q == null) {
                q = matchAllDocsQuery;
            } else if (!(q instanceof MatchAllDocsQuery)) {
                matchAllDocsQuery.setBoost(0.0f);
                q = QueriesSupport.combineAnd(new Query[]{matchAllDocsQuery, q});
            }
            req.setQuery(q);
        }
        catch (Exception ioe) {
            throw new BrowseException(ioe.getMessage(), ioe);
        }
        HashMap<String, ArrayList<FacetAccessible>> mergedMap = new HashMap<String, ArrayList<FacetAccessible>>();
        try {
            HashMap<String, FacetAccessible> facetColMap = new HashMap<String, FacetAccessible>();
            for (int i = 0; i < this._subBrowsers.length; ++i) {
                try {
                    this._subBrowsers[i].browse(req, hc, facetColMap, start + this.readerBase(i));
                    continue;
                }
                finally {
                    Set entries = facetColMap.entrySet();
                    for (Map.Entry entry : entries) {
                        String name = (String)entry.getKey();
                        FacetAccessible facetAccessor = (FacetAccessible)entry.getValue();
                        ArrayList<FacetAccessible> list = (ArrayList<FacetAccessible>)mergedMap.get(name);
                        if (list == null) {
                            list = new ArrayList<FacetAccessible>(this._subBrowsers.length);
                            mergedMap.put(name, list);
                        }
                        list.add(facetAccessor);
                    }
                    facetColMap.clear();
                }
            }
        }
        finally {
            if (req.getMapReduceWrapper() != null) {
                req.getMapReduceWrapper().finalizePartition();
            }
            Set entries = mergedMap.entrySet();
            for (Map.Entry entry : entries) {
                String name = (String)entry.getKey();
                FacetHandler<?> handler = this.getFacetHandler(name);
                try {
                    List subList = (List)entry.getValue();
                    if (subList == null) continue;
                    FacetAccessible merged = handler.merge(req.getFacetSpec(name), subList);
                    facetMap.put(name, merged);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public BrowseResult browse(BrowseRequest req) throws BrowseException {
        BrowseResult result = new BrowseResult();
        if (this._subBrowsers == null || this._subBrowsers.length == 0) {
            return result;
        }
        long start = System.currentTimeMillis();
        int offset = req.getOffset();
        int count = req.getCount();
        if (offset < 0 || count < 0) {
            throw new IllegalArgumentException("both offset and count must be > 0: " + offset + "/" + count);
        }
        SortCollector collector = this.getSortCollector(req.getSort(), req.getQuery(), offset, count, req.isFetchStoredFields(), req.getTermVectorsToFetch(), req.getGroupBy(), req.getMaxPerGroup(), req.getCollectDocIdCache());
        HashMap<String, FacetAccessible> facetCollectors = new HashMap<String, FacetAccessible>();
        this.browse(req, collector, facetCollectors, 0);
        if (req.getMapReduceWrapper() != null) {
            result.setMapReduceResult(req.getMapReduceWrapper().getResult());
        }
        BrowseHit[] hits = null;
        try {
            hits = collector.topDocs();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.addError(e.getMessage());
            hits = new BrowseHit[]{};
        }
        Query q = req.getQuery();
        if (req.isShowExplanation()) {
            for (BrowseHit hit : hits) {
                try {
                    int doc = hit.getDocid();
                    int idx = this.readerIndex(doc);
                    int deBasedDoc = doc - this.readerBase(idx);
                    Explanation expl = this._subBrowsers[idx].explain(q, deBasedDoc);
                    hit.setExplanation(expl);
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    result.addError(e.getMessage());
                }
            }
        }
        result.setHits(hits);
        result.setNumHits(collector.getTotalHits());
        result.setNumGroups(collector.getTotalGroups());
        result.setGroupAccessibles(collector.getGroupAccessibles());
        result.setSortCollector(collector);
        result.setTotalDocs(this.numDocs());
        result.addAll(facetCollectors);
        long end = System.currentTimeMillis();
        result.setTime(end - start);
        result.setTid(req.getTid());
        return result;
    }

    @Override
    public String[] getFieldVal(int docid, String fieldname) throws IOException {
        int i = this.readerIndex(docid);
        Browsable browser = this._subBrowsers[i];
        return browser.getFieldVal(docid - this.readerBase(i), fieldname);
    }

    @Override
    public Object[] getRawFieldVal(int docid, String fieldname) throws IOException {
        int i = this.readerIndex(docid);
        Browsable browser = this._subBrowsers[i];
        return browser.getRawFieldVal(docid - this.readerBase(i), fieldname);
    }

    public Browsable subBrowser(int docid) {
        int i = this.readerIndex(docid);
        return this._subBrowsers[i];
    }

    @Override
    public void setSimilarity(Similarity similarity) {
        for (Browsable subBrowser : this._subBrowsers) {
            subBrowser.setSimilarity(similarity);
        }
    }

    @Override
    public Set<String> getFacetNames() {
        HashSet<String> names = new HashSet<String>();
        for (Browsable subBrowser : this._subBrowsers) {
            names.addAll(subBrowser.getFacetNames());
        }
        return names;
    }

    @Override
    public FacetHandler<?> getFacetHandler(String name) {
        for (Browsable subBrowser : this._subBrowsers) {
            FacetHandler<?> subHandler = subBrowser.getFacetHandler(name);
            if (subHandler == null) continue;
            return subHandler;
        }
        return null;
    }

    @Override
    public Map<String, FacetHandler<?>> getFacetHandlerMap() {
        HashMap map = new HashMap();
        for (Browsable subBrowser : this._subBrowsers) {
            map.putAll(subBrowser.getFacetHandlerMap());
        }
        return map;
    }

    @Override
    public void setFacetHandler(FacetHandler<?> facetHandler) throws IOException {
        for (Browsable subBrowser : this._subBrowsers) {
            subBrowser.setFacetHandler(facetHandler);
        }
    }

    @Override
    public SortCollector getSortCollector(SortField[] sort, Query q, int offset, int count, boolean fetchStoredFields, Set<String> termVectorsToFetch, String[] groupBy, int maxPerGroup, boolean collectDocIdCache) {
        if (this._subBrowsers.length == 1) {
            return this._subBrowsers[0].getSortCollector(sort, q, offset, count, fetchStoredFields, termVectorsToFetch, groupBy, maxPerGroup, collectDocIdCache);
        }
        return SortCollector.buildSortCollector(this, q, sort, offset, count, fetchStoredFields, termVectorsToFetch, groupBy, maxPerGroup, collectDocIdCache);
    }

    @Override
    public void doClose() throws IOException {
        super.doClose();
        for (Browsable subBrowser : this._subBrowsers) {
            subBrowser.doClose();
        }
    }

    @Override
    public IndexReader getIndexReader() {
        return this;
    }

    @Override
    public Explanation explain(Query q, int deBasedDoc) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static class BrowseFacetValueComparator
    implements Comparator<BrowseFacet> {
        @Override
        public int compare(BrowseFacet o1, BrowseFacet o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    }
}

