/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Explanation;

public class BrowseHit
implements Serializable {
    private static final long serialVersionUID = 1L;
    private float score;
    private int docid;
    private Map<String, String[]> _fieldValues;
    private Map<String, Object[]> _rawFieldValues;
    private transient Comparable<?> _comparable;
    private List<SerializableField> _storedFields;
    private int _groupPosition;
    private String _groupField;
    private String _groupValue;
    private Object _rawGroupValue;
    private int _groupHitsCount;
    private BrowseHit[] _groupHits;
    private SerializableExplanation _explanation;
    private Map<String, List<BoboTerm>> _termVectorMap = new HashMap<String, List<BoboTerm>>();

    public float getScore() {
        return this.score;
    }

    public String[] getFields(String field) {
        return this._fieldValues != null ? this._fieldValues.get(field) : null;
    }

    public Object[] getRawFields(String field) {
        return this._rawFieldValues != null ? this._rawFieldValues.get(field) : null;
    }

    public String getField(String field) {
        String[] fields = this.getFields(field);
        if (fields != null && fields.length > 0) {
            return fields[0];
        }
        return null;
    }

    public Object getRawField(String field) {
        Object[] fields = this.getRawFields(field);
        if (fields != null && fields.length > 0) {
            return fields[0];
        }
        return null;
    }

    public Map<String, List<BoboTerm>> getTermVectorMap() {
        return this._termVectorMap;
    }

    public BrowseHit setTermVectorMap(Map<String, List<BoboTerm>> termVectorMap) {
        this._termVectorMap = termVectorMap;
        return this;
    }

    public int getGroupPosition() {
        return this._groupPosition;
    }

    public BrowseHit setGroupPosition(int pos) {
        this._groupPosition = pos;
        return this;
    }

    public String getGroupField() {
        return this._groupField;
    }

    public BrowseHit setGroupField(String field) {
        this._groupField = field;
        return this;
    }

    public String getGroupValue() {
        return this._groupValue;
    }

    public BrowseHit setGroupValue(String group) {
        this._groupValue = group;
        return this;
    }

    public Object getRawGroupValue() {
        return this._rawGroupValue;
    }

    public BrowseHit setRawGroupValue(Object group) {
        this._rawGroupValue = group;
        return this;
    }

    public int getGroupHitsCount() {
        return this._groupHitsCount;
    }

    public BrowseHit setGroupHitsCount(int count) {
        this._groupHitsCount = count;
        return this;
    }

    public BrowseHit[] getGroupHits() {
        return this._groupHits;
    }

    public BrowseHit setGroupHits(BrowseHit[] hits) {
        this._groupHits = hits;
        return this;
    }

    public SerializableExplanation getExplanation() {
        return this._explanation;
    }

    public BrowseHit setExplanation(SerializableExplanation explanation) {
        this._explanation = explanation;
        return this;
    }

    public BrowseHit setExplanation(Explanation explanation) {
        this._explanation = new SerializableExplanation(explanation);
        return this;
    }

    public BrowseHit setComparable(Comparable<?> comparable) {
        this._comparable = comparable;
        return this;
    }

    public Comparable<?> getComparable() {
        return this._comparable;
    }

    public int getDocid() {
        return this.docid;
    }

    public BrowseHit setDocid(int docid) {
        this.docid = docid;
        return this;
    }

    public Map<String, String[]> getFieldValues() {
        return this._fieldValues;
    }

    public BrowseHit setRawFieldValues(Map<String, Object[]> rawFieldValues) {
        this._rawFieldValues = rawFieldValues;
        return this;
    }

    public Map<String, Object[]> getRawFieldValues() {
        return this._rawFieldValues;
    }

    public BrowseHit setFieldValues(Map<String, String[]> fieldValues) {
        this._fieldValues = fieldValues;
        return this;
    }

    public BrowseHit setScore(float score) {
        this.score = score;
        return this;
    }

    public BrowseHit setStoredFields(Document doc) {
        if (doc == null) {
            this._storedFields = null;
            return this;
        }
        this._storedFields = new ArrayList<SerializableField>();
        Iterator it = doc.iterator();
        while (it.hasNext()) {
            this._storedFields.add(new SerializableField((IndexableField)it.next()));
        }
        return this;
    }

    public BrowseHit setStoredFields(List<SerializableField> fields) {
        this._storedFields = fields;
        return this;
    }

    public List<SerializableField> getStoredFields() {
        return this._storedFields;
    }

    public byte[] getFieldBinaryValue(String fieldName) {
        if (this._storedFields == null) {
            return null;
        }
        for (SerializableField field : this._storedFields) {
            if (!fieldName.equals(field.name())) continue;
            return field.binaryValue();
        }
        return null;
    }

    public String getFieldStringValue(String fieldName) {
        if (this._storedFields == null) {
            return null;
        }
        for (SerializableField field : this._storedFields) {
            if (!fieldName.equals(field.name())) continue;
            return field.stringValue();
        }
        return null;
    }

    public String toString(Map<String, String[]> map) {
        StringBuilder buffer = new StringBuilder();
        Set<Map.Entry<String, String[]>> set = map.entrySet();
        Iterator<Map.Entry<String, String[]>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String[]> e = iterator.next();
            buffer.append(e.getKey());
            buffer.append(":");
            Object[] vals = e.getValue();
            buffer.append(vals == null ? null : Arrays.toString(vals));
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("docid: ").append(this.docid).append('\n');
        buffer.append("score: ").append(this.score).append('\n');
        buffer.append("field values: ").append(this.toString(this._fieldValues)).append('\n');
        return buffer.toString();
    }

    public static class SerializableExplanation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private float value;
        private String description;
        private ArrayList<SerializableExplanation> details;

        public SerializableExplanation(Explanation explanation) {
            this.setValue(explanation.getValue());
            this.setDescription(explanation.getDescription());
            Explanation[] details = explanation.getDetails();
            if (details == null) {
                return;
            }
            for (Explanation exp : details) {
                this.addDetail(new SerializableExplanation(exp));
            }
        }

        public float getValue() {
            return this.value;
        }

        public void setValue(float value) {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public SerializableExplanation[] getDetails() {
            if (this.details == null) {
                return null;
            }
            return this.details.toArray(new SerializableExplanation[0]);
        }

        public void addDetail(SerializableExplanation detail) {
            if (this.details == null) {
                this.details = new ArrayList();
            }
            this.details.add(detail);
        }

        public String toString() {
            return this.toString(0);
        }

        protected String toString(int depth) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                buffer.append("  ");
            }
            buffer.append(this.getValue() + " = " + this.getDescription());
            buffer.append("\n");
            SerializableExplanation[] details = this.getDetails();
            if (details != null) {
                for (int i = 0; i < details.length; ++i) {
                    buffer.append(details[i].toString(depth + 1));
                }
            }
            return buffer.toString();
        }
    }

    public static class SerializableField
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private Object fieldsData;

        public SerializableField(IndexableField field) {
            this.name = field.name();
            if (field.numericValue() != null) {
                this.fieldsData = field.numericValue();
            } else if (field.stringValue() != null) {
                this.fieldsData = field.stringValue();
            } else if (field.binaryValue() != null) {
                this.fieldsData = field.binaryValue().bytes;
            } else {
                throw new UnsupportedOperationException("Doesn't support this field type so far");
            }
        }

        public String name() {
            return this.name;
        }

        public String stringValue() {
            if (this.fieldsData instanceof String || this.fieldsData instanceof Number) {
                return this.fieldsData.toString();
            }
            return null;
        }

        public Number numericValue() {
            if (this.fieldsData instanceof Number) {
                return (Number)this.fieldsData;
            }
            return null;
        }

        public byte[] binaryValue() {
            if (this.fieldsData instanceof byte[]) {
                return (byte[])this.fieldsData;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SerializableField)) {
                return false;
            }
            SerializableField other = (SerializableField)o;
            if (!this.name.equals(other.name())) {
                return false;
            }
            String value = this.stringValue();
            if (value != null) {
                return value.equals(other.stringValue());
            }
            byte[] binValue = this.binaryValue();
            if (binValue != null) {
                return Arrays.equals(binValue, other.binaryValue());
            }
            return false;
        }
    }

    public static class BoboTerm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String term;
        public Integer freq;
        public List<Integer> positions;
        public List<Integer> startOffsets;
        public List<Integer> endOffsets;
    }
}

