/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.api.IntFacetIterator;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.facets.FacetHandler;
import com.browseengine.bobo.facets.RuntimeFacetHandler;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.TermIntList;
import com.browseengine.bobo.facets.data.TermLongList;
import com.browseengine.bobo.facets.data.TermValueList;
import com.browseengine.bobo.facets.filter.RandomAccessFilter;
import com.browseengine.bobo.facets.impl.RangeFacetHandler;
import com.browseengine.bobo.sort.DocComparatorSource;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class HistogramFacetHandler<T extends Number>
extends RuntimeFacetHandler<FacetHandler.FacetDataNone> {
    private final String _dataHandlerName;
    private final T _start;
    private final T _end;
    private final T _unit;
    private FacetHandler<?> _dataFacetHandler;

    public HistogramFacetHandler(String name, String dataHandlerName, T start, T end, T unit) {
        super(name, new HashSet<String>(Arrays.asList(dataHandlerName)));
        this._dataHandlerName = dataHandlerName;
        this._start = start;
        this._end = end;
        this._unit = unit;
    }

    @Override
    public FacetHandler.FacetDataNone load(BoboIndexReader reader) throws IOException {
        this._dataFacetHandler = reader.getFacetHandler(this._dataHandlerName);
        if (this._dataFacetHandler instanceof RangeFacetHandler && ((RangeFacetHandler)this._dataFacetHandler).hasPredefinedRanges()) {
            throw new UnsupportedOperationException("underlying range facet handler should not have the predefined ranges");
        }
        return FacetHandler.FacetDataNone.instance;
    }

    @Override
    public DocComparatorSource getDocComparatorSource() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getFieldValues(BoboIndexReader reader, int id) {
        return null;
    }

    @Override
    public Object[] getRawFieldValues(BoboIndexReader reader, int id) {
        return null;
    }

    @Override
    public RandomAccessFilter buildRandomAccessFilter(String value, Properties prop) throws IOException {
        return this._dataFacetHandler.buildRandomAccessFilter(value, prop);
    }

    @Override
    public RandomAccessFilter buildRandomAccessAndFilter(String[] vals, Properties prop) throws IOException {
        return this._dataFacetHandler.buildRandomAccessAndFilter(vals, prop);
    }

    @Override
    public RandomAccessFilter buildRandomAccessOrFilter(String[] vals, Properties prop, boolean isNot) throws IOException {
        return this._dataFacetHandler.buildRandomAccessOrFilter(vals, prop, isNot);
    }

    @Override
    public FacetCountCollectorSource getFacetCountCollectorSource(BrowseSelection sel, final FacetSpec ospec) {
        final FacetCountCollectorSource baseCollectorSrc = this._dataFacetHandler.getFacetCountCollectorSource(sel, ospec);
        return new FacetCountCollectorSource(){

            @Override
            public FacetCountCollector getFacetCountCollector(BoboIndexReader reader, int docBase) {
                FacetDataCache dataCache = (FacetDataCache)reader.getFacetData(HistogramFacetHandler.this._dataHandlerName);
                FacetCountCollector baseCollector = baseCollectorSrc.getFacetCountCollector(reader, docBase);
                return new HistogramCollector<Number>(HistogramFacetHandler.this.getName(), baseCollector, dataCache, ospec, HistogramFacetHandler.this._start, HistogramFacetHandler.this._end, HistogramFacetHandler.this._unit);
            }
        };
    }

    public static class HistogramFacetIterator
    extends IntFacetIterator {
        private final DecimalFormat _formatter;
        private final int[] _count;
        private final int _maxMinusOne;
        private int _idx = -1;

        public HistogramFacetIterator(int[] count, DecimalFormat formatter) {
            this._count = count;
            this._maxMinusOne = count.length - 1;
            this._formatter = formatter;
        }

        @Override
        public Integer next() {
            if (this.hasNext()) {
                this.count = this._count[++this._idx];
                this.facet = this._idx;
                return this.facet;
            }
            return null;
        }

        @Override
        public Integer next(int minHits) {
            while (this._idx < this._maxMinusOne) {
                if (this._count[++this._idx] < minHits) continue;
                this.count = this._count[this._idx];
                this.facet = this._idx;
                return this.facet;
            }
            return null;
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                this.count = this._count[++this._idx];
                this.facet = this._idx;
                return this.facet;
            }
            return -1;
        }

        @Override
        public int nextInt(int minHits) {
            while (this._idx < this._maxMinusOne) {
                if (this._count[++this._idx] < minHits) continue;
                this.count = this._count[this._idx];
                this.facet = this._idx;
                return this.facet;
            }
            return -1;
        }

        @Override
        public boolean hasNext() {
            return this._idx < this._maxMinusOne;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String format(Object val) {
            return this._formatter.format(val);
        }

        @Override
        public String format(int val) {
            return this._formatter.format(val);
        }
    }

    public static class HistogramCollector<T extends Number>
    implements FacetCountCollector {
        private final DecimalFormat _formatter = new DecimalFormat("0000000000");
        private final FacetSpec _ospec;
        private final T _start;
        private final T _end;
        private final T _unit;
        private final int[] _count;
        private final TermValueList<?> _valArray;
        private final FacetCountCollector _baseCollector;
        private final String _facetName;
        private boolean _isAggregated;

        protected HistogramCollector(String facetName, FacetCountCollector baseCollector, FacetDataCache<?> dataCache, FacetSpec ospec, T start, T end, T unit) {
            this._facetName = facetName;
            this._baseCollector = baseCollector;
            this._valArray = dataCache.valArray;
            this._ospec = ospec;
            this._isAggregated = false;
            this._start = start;
            this._end = end;
            this._unit = unit;
            this._count = new int[this.countArraySize()];
        }

        private int countArraySize() {
            if (this._start instanceof Long) {
                long range = ((Number)this._end).longValue() - ((Number)this._start).longValue();
                return (int)(range / ((Number)this._unit).longValue()) + 1;
            }
            if (this._start instanceof Integer) {
                int range = ((Number)this._end).intValue() - ((Number)this._start).intValue();
                return range / ((Number)this._unit).intValue() + 1;
            }
            double range = ((Number)this._end).doubleValue() - ((Number)this._start).doubleValue();
            return (int)(range / ((Number)this._unit).doubleValue()) + 1;
        }

        @Override
        public int[] getCountDistribution() {
            if (!this._isAggregated) {
                this.aggregate();
            }
            return this._count;
        }

        @Override
        public BrowseFacet getFacet(String value) {
            int idx;
            if (!this._isAggregated) {
                this.aggregate();
            }
            if ((idx = Integer.parseInt(value)) >= 0 && idx < this._count.length) {
                return new BrowseFacet(value, this._count[idx]);
            }
            return null;
        }

        @Override
        public final void collect(int docid) {
            this._baseCollector.collect(docid);
        }

        @Override
        public final void collectAll() {
            this._baseCollector.collectAll();
        }

        private void aggregate() {
            int endIdx;
            if (this._isAggregated) {
                return;
            }
            this._isAggregated = true;
            int startIdx = this._valArray.indexOf(this._start);
            if (startIdx < 0) {
                startIdx = -(startIdx + 1);
            }
            if ((endIdx = this._valArray.indexOf(this._end)) < 0) {
                endIdx = -(endIdx + 1);
            }
            int[] baseCounts = this._baseCollector.getCountDistribution();
            if (this._start instanceof Long) {
                long start = ((Number)this._start).longValue();
                long unit = ((Number)this._unit).longValue();
                TermLongList valArray = (TermLongList)this._valArray;
                for (int i = startIdx; i < endIdx; ++i) {
                    long val = valArray.getPrimitiveValue(i);
                    int idx = (int)((val - start) / unit);
                    if (idx < 0 || idx >= this._count.length) continue;
                    int n = idx;
                    this._count[n] = this._count[n] + baseCounts[i];
                }
            } else if (this._start instanceof Integer) {
                int start = ((Number)this._start).intValue();
                int unit = ((Number)this._unit).intValue();
                TermIntList valArray = (TermIntList)this._valArray;
                for (int i = startIdx; i < endIdx; ++i) {
                    int val = valArray.getPrimitiveValue(i);
                    int idx = (val - start) / unit;
                    if (idx < 0 || idx >= this._count.length) continue;
                    int n = idx;
                    this._count[n] = this._count[n] + baseCounts[i];
                }
            } else {
                double start = ((Number)this._start).doubleValue();
                double unit = ((Number)this._unit).doubleValue();
                for (int i = startIdx; i < endIdx; ++i) {
                    Number val = (Number)this._valArray.getRawValue(i);
                    int idx = (int)((val.doubleValue() - start) / unit);
                    if (idx < 0 || idx >= this._count.length) continue;
                    int n = idx;
                    this._count[n] = this._count[n] + baseCounts[i];
                }
            }
        }

        @Override
        public List<BrowseFacet> getFacets() {
            if (this._ospec != null) {
                FacetSpec.FacetSortSpec sortspec;
                int minCount = this._ospec.getMinHitCount();
                int max = this._ospec.getMaxCount();
                if (max <= 0) {
                    max = this._count.length;
                }
                if ((sortspec = this._ospec.getOrderBy()) == FacetSpec.FacetSortSpec.OrderValueAsc) {
                    ArrayList<BrowseFacet> facetColl = new ArrayList<BrowseFacet>(max);
                    for (int i = 0; i < this._count.length; ++i) {
                        int hits = this._count[i];
                        if (hits >= minCount) {
                            BrowseFacet facet = new BrowseFacet(this._formatter.format(i), hits);
                            facetColl.add(facet);
                        }
                        if (facetColl.size() >= max) break;
                    }
                    return facetColl;
                }
                return FacetCountCollector.EMPTY_FACET_LIST;
            }
            return FacetCountCollector.EMPTY_FACET_LIST;
        }

        @Override
        public FacetIterator iterator() {
            if (!this._isAggregated) {
                this.aggregate();
            }
            return new HistogramFacetIterator(this._count, this._formatter);
        }

        @Override
        public String getName() {
            return this._facetName;
        }

        @Override
        public void close() {
        }
    }
}

