/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.impl;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.FacetIterator;
import com.browseengine.bobo.api.FacetSpec;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.data.FacetDataCache;
import com.browseengine.bobo.facets.data.TermStringList;
import com.browseengine.bobo.facets.data.TermValueList;
import com.browseengine.bobo.facets.impl.DefaultFacetCountCollector;
import com.browseengine.bobo.facets.impl.DefaultFacetIterator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BitVector;

public class BucketFacetCountCollector
implements FacetCountCollector {
    private final String _name;
    private final DefaultFacetCountCollector _subCollector;
    private final FacetSpec _ospec;
    private final Map<String, String[]> _predefinedBuckets;
    private int[] _collapsedCounts;
    private TermStringList _bucketValues;
    private final int _numdocs;

    protected BucketFacetCountCollector(String name, DefaultFacetCountCollector subCollector, FacetSpec ospec, Map<String, String[]> predefinedBuckets, int numdocs) {
        this._name = name;
        this._subCollector = subCollector;
        this._ospec = ospec;
        this._numdocs = numdocs;
        this._predefinedBuckets = predefinedBuckets;
        this._collapsedCounts = null;
        this._bucketValues = new TermStringList();
        this._bucketValues.add("");
        Object[] bucketArray = this._predefinedBuckets.keySet().toArray(new String[0]);
        Arrays.sort(bucketArray);
        for (Object bucket : bucketArray) {
            this._bucketValues.add((String)bucket);
        }
        this._bucketValues.seal();
    }

    private int[] getCollapsedCounts() {
        if (this._collapsedCounts == null) {
            this._collapsedCounts = new int[this._bucketValues.size()];
            FacetDataCache dataCache = this._subCollector._dataCache;
            TermValueList subList = dataCache.valArray;
            int[] subcounts = this._subCollector._count;
            BitVector indexSet = new BitVector(subcounts.length);
            int c = 0;
            int i = 0;
            for (String val : this._bucketValues) {
                if (val.length() > 0) {
                    String[] subVals = this._predefinedBuckets.get(val);
                    int count = 0;
                    for (String subVal : subVals) {
                        int index = subList.indexOf(subVal);
                        if (index <= 0) continue;
                        int subcount = subcounts[index];
                        count += subcount;
                        if (indexSet.get(index)) continue;
                        indexSet.set(index);
                        c += dataCache.freqs[index];
                    }
                    this._collapsedCounts[i] = count;
                }
                ++i;
            }
            this._collapsedCounts[0] = this._numdocs - c;
        }
        return this._collapsedCounts;
    }

    @Override
    public int[] getCountDistribution() {
        return this.getCollapsedCounts();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public BrowseFacet getFacet(String bucketValue) {
        int index = this._bucketValues.indexOf(bucketValue);
        if (index < 0) {
            return new BrowseFacet(bucketValue, 0);
        }
        int[] counts = this.getCollapsedCounts();
        return new BrowseFacet(bucketValue, counts[index]);
    }

    @Override
    public final void collect(int docid) {
        this._subCollector.collect(docid);
    }

    @Override
    public final void collectAll() {
        this._subCollector.collectAll();
    }

    @Override
    public List<BrowseFacet> getFacets() {
        int[] counts = this.getCollapsedCounts();
        return DefaultFacetCountCollector.getFacets(this._ospec, counts, counts.length, this._bucketValues);
    }

    @Override
    public void close() {
        this._subCollector.close();
    }

    @Override
    public FacetIterator iterator() {
        int[] counts = this.getCollapsedCounts();
        return new DefaultFacetIterator(this._bucketValues, counts, counts.length, true);
    }
}

