/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.resourcemanager.appservice.models.AttributeCollection;
import com.azure.resourcemanager.appservice.models.SkuDescription;
import com.azure.resourcemanager.appservice.models.SkuName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collection;

public final class PricingTier {
    private static final AttributeCollection<PricingTier> COLLECTION = new AttributeCollection();
    public static final PricingTier BASIC_B1 = COLLECTION.addValue(new PricingTier(SkuName.BASIC.toString(), "B1"));
    public static final PricingTier BASIC_B2 = COLLECTION.addValue(new PricingTier(SkuName.BASIC.toString(), "B2"));
    public static final PricingTier BASIC_B3 = COLLECTION.addValue(new PricingTier(SkuName.BASIC.toString(), "B3"));
    public static final PricingTier STANDARD_S1 = COLLECTION.addValue(new PricingTier(SkuName.STANDARD.toString(), "S1"));
    public static final PricingTier STANDARD_S2 = COLLECTION.addValue(new PricingTier(SkuName.STANDARD.toString(), "S2"));
    public static final PricingTier STANDARD_S3 = COLLECTION.addValue(new PricingTier(SkuName.STANDARD.toString(), "S3"));
    public static final PricingTier PREMIUM_P1 = COLLECTION.addValue(new PricingTier(SkuName.PREMIUM.toString(), "P1"));
    public static final PricingTier PREMIUM_P2 = COLLECTION.addValue(new PricingTier(SkuName.PREMIUM.toString(), "P2"));
    public static final PricingTier PREMIUM_P3 = COLLECTION.addValue(new PricingTier(SkuName.PREMIUM.toString(), "P3"));
    public static final PricingTier PREMIUM_P1V2 = COLLECTION.addValue(new PricingTier(SkuName.PREMIUM_V2.toString(), "P1v2"));
    public static final PricingTier PREMIUM_P2V2 = COLLECTION.addValue(new PricingTier(SkuName.PREMIUM_V2.toString(), "P2v2"));
    public static final PricingTier PREMIUM_P3V2 = COLLECTION.addValue(new PricingTier(SkuName.PREMIUM_V2.toString(), "P3v2"));
    public static final PricingTier PREMIUM_P1V3 = COLLECTION.addValue(new PricingTier("PremiumV3", "P1v3"));
    public static final PricingTier PREMIUM_P2V3 = COLLECTION.addValue(new PricingTier("PremiumV3", "P2v3"));
    public static final PricingTier PREMIUM_P3V3 = COLLECTION.addValue(new PricingTier("PremiumV3", "P3v3"));
    public static final PricingTier FREE_F1 = COLLECTION.addValue(new PricingTier(SkuName.FREE.toString(), "F1"));
    public static final PricingTier SHARED_D1 = COLLECTION.addValue(new PricingTier(SkuName.SHARED.toString(), "D1"));
    private final SkuDescription skuDescription;

    public PricingTier(String tier, String size) {
        this.skuDescription = new SkuDescription().withName(size).withTier(tier).withSize(size);
    }

    public static PricingTier fromSkuDescription(SkuDescription skuDescription) {
        if (skuDescription == null) {
            return null;
        }
        return new PricingTier(skuDescription.tier(), skuDescription.size());
    }

    public static Collection<PricingTier> getAll() {
        return COLLECTION.getAllValues();
    }

    public String toString() {
        return this.skuDescription.tier() + "_" + this.skuDescription.size();
    }

    @JsonValue
    public SkuDescription toSkuDescription() {
        return this.skuDescription;
    }

    public int hashCode() {
        return this.skuDescription.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PricingTier)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PricingTier rhs = (PricingTier)obj;
        return this.toString().equalsIgnoreCase(rhs.toString());
    }
}

