/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.implementation.ServicesImpl;
import com.azure.data.tables.implementation.TablesImpl;

public final class AzureTableImpl {
    private final String url;
    private final String version;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final TablesImpl tables;
    private final ServicesImpl services;

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public TablesImpl getTables() {
        return this.tables;
    }

    public ServicesImpl getServices() {
        return this.services;
    }

    public AzureTableImpl(String url, String version) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), url, version);
    }

    public AzureTableImpl(HttpPipeline httpPipeline, String url, String version) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), url, version);
    }

    public AzureTableImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String url, String version) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.url = url;
        this.version = version;
        this.tables = new TablesImpl(this);
        this.services = new ServicesImpl(this);
    }
}

