/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.MessageConsumerSession;
import com.atomikos.jms.TopicConnectionFactoryBean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Topic;

public class TopicSubscriberSession
extends MessageConsumerSession {
    private boolean noLocal;
    private String subscriberName;

    public void setTopicConnectionFactoryBean(TopicConnectionFactoryBean factory) {
        this.setAbstractConnectionFactoryBean(factory);
    }

    public TopicConnectionFactoryBean getTopicConnectionFactoryBean() {
        return (TopicConnectionFactoryBean)this.getAbstractConnectionFactoryBean();
    }

    public void setTopic(Topic topic) {
        this.setDestination((Destination)topic);
    }

    public Topic getTopic() {
        return (Topic)this.getDestination();
    }

    protected String getDestinationName() {
        String ret = null;
        Topic topic = this.getTopic();
        if (topic != null) {
            try {
                ret = topic.getTopicName();
            }
            catch (JMSException e) {
                Configuration.logDebug((String)"TopicSubscriberSession: error retrieving topic name", (Throwable)e);
            }
        }
        return ret;
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    public String getSubscriberName() {
        return this.subscriberName;
    }

    public void setNoLocal(boolean value) {
        this.noLocal = value;
    }

    public void setSubscriberName(String name) {
        this.subscriberName = name;
    }
}

