/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.datasource.xa.jms.JmsTransactionalResource;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AbstractConnectionFactoryBean;
import com.atomikos.jms.JtaTopicConnectionFactory;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TopicConnectionFactoryBean
extends AbstractConnectionFactoryBean
implements TopicConnectionFactory {
    private transient JtaTopicConnectionFactory factory_;
    private XATopicConnectionFactory xaFactory_;

    protected synchronized void checkSetup() throws JMSException {
        this.factory_ = JtaTopicConnectionFactory.getInstance(this.resourceName_);
        if (this.factory_ != null) {
            return;
        }
        DefaultXidFactory xidFactory = null;
        xidFactory = new DefaultXidFactory();
        if (this.xaFactory_ == null && "".equals(this.xaFactoryJndiName_)) {
            throw new JMSException("TopicConnectionFactoryBean: XATopicConnectionFactory not set?");
        }
        if (!"".equals(this.xaFactoryJndiName_)) {
            try {
                InitialContext ctx = new InitialContext();
                Context env = (Context)ctx.lookup("java:comp/env");
                this.xaFactory_ = (XATopicConnectionFactory)env.lookup(this.xaFactoryJndiName_);
            }
            catch (NamingException ne) {
                throw new JMSException("TopicConnectionFactoryBean: error retrieving factory: " + ne.getMessage());
            }
        }
        this.factory_ = JtaTopicConnectionFactory.getOrCreate(this.resourceName_, this.xaFactory_, (XidFactory)xidFactory);
        JmsTransactionalResource res = this.factory_.getTransactionalResource();
        if (Configuration.getResource((String)res.getName()) == null) {
            Configuration.addResource((RecoverableResource)res);
        }
        StringBuffer msg = new StringBuffer();
        msg.append("TopicConnectionFactoryBean configured with [");
        msg.append("resourceName=").append(this.resourceName_).append(", ");
        msg.append("xaFactoryJndiName=").append(this.xaFactoryJndiName_);
        msg.append("]");
        Configuration.logDebug((String)msg.toString());
        Configuration.logWarning((String)("WARNING: class " + this.getClass().getName() + " is deprecated!"));
    }

    public void setXaTopicConnectionFactory(XATopicConnectionFactory factory) {
        this.xaFactory_ = factory;
    }

    public XATopicConnectionFactory getXaTopicConnectionFactory() {
        return this.xaFactory_;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        this.checkSetup();
        return this.factory_.createTopicConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        this.checkSetup();
        return this.factory_.createTopicConnection(userName, password);
    }

    public Connection createConnection() throws JMSException {
        return this.createTopicConnection();
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createTopicConnection(userName, password);
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof TopicConnectionFactoryBean) {
            TopicConnectionFactoryBean other = (TopicConnectionFactoryBean)o;
            ret = this.resourceName_ != null ? this.resourceName_.equals(other.resourceName_) : super.equals(o);
        }
        return ret;
    }

    public int hashCode() {
        int ret = 0;
        ret = this.resourceName_ != null ? this.resourceName_.hashCode() : super.hashCode();
        return ret;
    }
}

