/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.jms.DefaultJtaMessageProducer;
import com.atomikos.jms.HeuristicQueueSender;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.transaction.xa.XAResource;

class JtaQueueSender
extends DefaultJtaMessageProducer
implements HeuristicQueueSender {
    JtaQueueSender(QueueSender sender, TransactionalResource res, XAResource xares) {
        super((MessageProducer)sender, res, xares);
    }

    private QueueSender getQueueSender() {
        return (QueueSender)this.getMessageProducer();
    }

    public void send(Message msg, HeuristicMessage hmsg) throws JMSException {
        this.sendToDefaultDestination(msg, hmsg);
    }

    public void send(Message msg, int deliveryMode, int priority, long timeToLive, HeuristicMessage hmsg) throws JMSException {
        this.sendToDefaultDestination(msg, deliveryMode, priority, timeToLive, hmsg);
    }

    public void send(Queue q, Message msg, HeuristicMessage hmsg) throws JMSException {
        this.sendToDestination((Destination)q, msg, hmsg);
    }

    public void send(Queue q, Message msg, int deliveryMode, int priority, long timeToLive, HeuristicMessage hmsg) throws JMSException {
        this.sendToDestination((Destination)q, msg, deliveryMode, priority, timeToLive, hmsg);
    }

    public void send(Queue q, Message msg) throws JMSException {
        StringHeuristicMessage hmsg = new StringHeuristicMessage("Sending of JMS Message with ID: " + msg.getJMSMessageID());
        this.sendToDestination((Destination)q, msg, (HeuristicMessage)hmsg);
    }

    public void send(Queue q, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        StringHeuristicMessage hmsg = new StringHeuristicMessage("Sending of JMS Message with ID: " + msg.getJMSMessageID());
        this.sendToDestination((Destination)q, msg, deliveryMode, priority, timeToLive, (HeuristicMessage)hmsg);
    }

    public Queue getQueue() throws JMSException {
        return this.getQueueSender().getQueue();
    }

    public void send(Message msg, String hmsg) throws JMSException {
        StringHeuristicMessage heurmsg = new StringHeuristicMessage(hmsg);
        this.send(msg, (HeuristicMessage)heurmsg);
    }

    public void send(Message msg, int deliveryMode, int priority, long timeToLive, String hmsg) throws JMSException {
        StringHeuristicMessage heurmsg = new StringHeuristicMessage(hmsg);
        this.send(msg, deliveryMode, priority, timeToLive, (HeuristicMessage)heurmsg);
    }

    public void send(Queue q, Message msg, String hmsg) throws JMSException {
        StringHeuristicMessage heurmsg = new StringHeuristicMessage(hmsg);
        this.send(q, msg, (HeuristicMessage)heurmsg);
    }

    public void send(Queue q, Message msg, int deliveryMode, int priority, long timeToLive, String hmsg) throws JMSException {
        StringHeuristicMessage heurmsg = new StringHeuristicMessage(hmsg);
        this.send(q, msg, deliveryMode, priority, timeToLive, (HeuristicMessage)heurmsg);
    }
}

