/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.DefaultJtaSession;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

class DefaultJtaConnection
implements Connection {
    private XAConnection conn_;
    private TransactionalResource res_;

    protected static void forceConnectionIntoXaMode(Connection c) {
        try {
            Session s = c.createSession(true, 1);
            s.rollback();
            s.close();
        }
        catch (Exception e) {
            Configuration.logDebug((String)"JMS: driver complains while enforcing XA mode - ignore if no later errors:", (Throwable)e);
        }
    }

    protected static boolean inJtaTransaction() throws JMSException {
        boolean ret = false;
        TransactionManager tm = TransactionManagerImp.getTransactionManager();
        if (tm != null) {
            try {
                ret = tm.getStatus() == 0;
            }
            catch (SystemException e) {
                Configuration.logWarning((String)"Could not determine transaction status: ", (Throwable)e);
                JMSException error = new JMSException("Could not determine transaction status - see linked exception for more info");
                error.setLinkedException((Exception)((Object)e));
                throw error;
            }
        }
        return ret;
    }

    protected DefaultJtaConnection(XAConnection c, TransactionalResource res) {
        this.conn_ = c;
        this.res_ = res;
    }

    protected TransactionalResource getTransactionalResource() {
        return this.res_;
    }

    protected Connection getConnection() {
        return this.conn_;
    }

    public void close() throws JMSException {
        this.conn_.close();
    }

    public void start() throws JMSException {
        this.conn_.start();
    }

    public void setExceptionListener(ExceptionListener l) throws JMSException {
        this.conn_.setExceptionListener(l);
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.conn_.getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.conn_.getMetaData();
    }

    public void setClientID(String id) throws JMSException {
        this.conn_.setClientID(id);
    }

    public String getClientID() throws JMSException {
        return this.conn_.getClientID();
    }

    public void stop() throws JMSException {
        this.conn_.stop();
    }

    public ConnectionConsumer createConnectionConsumer(Destination dest, String string, ServerSessionPool arg2, int arg3) throws JMSException {
        throw new JMSException("Not supported");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic arg0, String arg1, String arg2, ServerSessionPool arg3, int arg4) throws JMSException {
        throw new JMSException("Not supported");
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        Session ret = null;
        if (!transacted && !DefaultJtaConnection.inJtaTransaction()) {
            ret = this.conn_.createSession(false, ackMode);
        } else {
            DefaultJtaConnection.forceConnectionIntoXaMode((Connection)this.conn_);
            XASession xasession = this.conn_.createXASession();
            ret = new DefaultJtaSession(xasession, this.res_, xasession.getXAResource());
        }
        return ret;
    }
}

