/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.SdkConstants;
import com.android.annotations.Nullable;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.FullRevisionPackage;
import com.android.sdklib.internal.repository.packages.IMinPlatformToolsDependency;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.SdkRepoConstants;
import com.android.sdklib.util.GrabProcessOutput;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class ToolPackage
extends FullRevisionPackage
implements IMinPlatformToolsDependency {
    public static final String INSTALL_ID = "tools";
    private static final String INSTALL_ID_PREVIEW = "tools-preview";
    private final FullRevision mMinPlatformToolsRevision;

    public ToolPackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        this.mMinPlatformToolsRevision = PackageParserUtils.parseFullRevisionElement(PackageParserUtils.findChildElement(packageNode, "min-platform-tools-rev"));
        if (this.mMinPlatformToolsRevision.equals(MIN_PLATFORM_TOOLS_REV_INVALID) && SdkRepoConstants.versionGreaterOrEqualThan(nsUri, 3)) {
            throw new IllegalArgumentException(String.format("Missing %1$s element in %2$s package", "min-platform-tools-rev", "platform-tool"));
        }
    }

    public static Package create(SdkSource source, Properties props, int revision, String license, String description, String descUrl, Archive.Os archiveOs, Archive.Arch archiveArch, String archiveOsPath) {
        return new ToolPackage(source, props, revision, license, description, descUrl, archiveOs, archiveArch, archiveOsPath);
    }

    protected ToolPackage(SdkSource source, Properties props, int revision, String license, String description, String descUrl, Archive.Os archiveOs, Archive.Arch archiveArch, String archiveOsPath) {
        super(source, props, revision, license, description, descUrl, archiveOs, archiveArch, archiveOsPath);
        String revStr = ToolPackage.getProperty(props, "Platform.MinPlatformToolsRev", null);
        FullRevision rev = MIN_PLATFORM_TOOLS_REV_INVALID;
        if (revStr != null) {
            try {
                rev = FullRevision.parseRevision(revStr);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        this.mMinPlatformToolsRevision = rev;
    }

    @Override
    public FullRevision getMinPlatformToolsRevision() {
        return this.mMinPlatformToolsRevision;
    }

    @Override
    public String installId() {
        if (this.getRevision().isPreview()) {
            return INSTALL_ID_PREVIEW;
        }
        return INSTALL_ID;
    }

    @Override
    public String getListDescription() {
        return String.format("Android SDK Tools%1$s", this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        return String.format("Android SDK Tools, revision %1$s%2$s", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = this.getShortDescription();
        }
        if (s.indexOf("revision") == -1) {
            s = s + String.format("\nRevision %1$s%2$s", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        return new File(osSdkRoot, INSTALL_ID);
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        return this.sameItemAs(pkg, FullRevision.PreviewComparison.COMPARE_TYPE);
    }

    @Override
    public boolean sameItemAs(Package pkg, FullRevision.PreviewComparison comparePreview) {
        if (pkg instanceof ToolPackage) {
            switch (comparePreview) {
                case IGNORE: {
                    return true;
                }
                case COMPARE_NUMBER: 
                case COMPARE_TYPE: {
                    return pkg.getRevision().isPreview() == this.getRevision().isPreview();
                }
            }
        }
        return false;
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        if (!this.getMinPlatformToolsRevision().equals(MIN_PLATFORM_TOOLS_REV_INVALID)) {
            props.setProperty("Platform.MinPlatformToolsRev", this.getMinPlatformToolsRevision().toShortString());
        }
    }

    @Override
    public void postInstallHook(Archive archive, final ITaskMonitor monitor, File installFolder) {
        super.postInstallHook(archive, monitor, installFolder);
        if (installFolder == null) {
            return;
        }
        File libDir = new File(installFolder, "lib");
        if (!libDir.isDirectory()) {
            return;
        }
        String scriptName = "post_tools_install";
        String shell = "";
        if (SdkConstants.currentPlatform() == 2) {
            shell = "cmd.exe /c ";
            scriptName = scriptName + ".bat";
        } else {
            scriptName = scriptName + ".sh";
        }
        File scriptFile = new File(libDir, scriptName);
        if (!scriptFile.isFile()) {
            return;
        }
        int status = -1;
        try {
            Process proc = Runtime.getRuntime().exec(shell + scriptName, null, libDir);
            final String tag = scriptName;
            status = GrabProcessOutput.grabProcessOutput(proc, GrabProcessOutput.Wait.WAIT_FOR_PROCESS, new GrabProcessOutput.IProcessOutput(){

                @Override
                public void out(@Nullable String line) {
                    if (line != null) {
                        monitor.log("[%1$s] %2$s", tag, line);
                    }
                }

                @Override
                public void err(@Nullable String line) {
                    if (line != null) {
                        monitor.logError("[%1$s] Error: %2$s", tag, line);
                    }
                }
            });
        }
        catch (Exception e) {
            monitor.logError("Exception: %s", e.toString());
        }
        if (status != 0) {
            monitor.logError("Failed to execute %s", scriptName);
            return;
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mMinPlatformToolsRevision == null ? 0 : this.mMinPlatformToolsRevision.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ToolPackage)) {
            return false;
        }
        ToolPackage other = (ToolPackage)obj;
        return !(this.mMinPlatformToolsRevision == null ? other.mMinPlatformToolsRevision != null : !this.mMinPlatformToolsRevision.equals(other.mMinPlatformToolsRevision));
    }
}

