/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.IMinToolsDependency;
import com.android.sdklib.internal.repository.packages.MajorRevisionPackage;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.repository.FullRevision;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public abstract class MinToolsPackage
extends MajorRevisionPackage
implements IMinToolsDependency {
    private final FullRevision mMinToolsRevision;

    MinToolsPackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        this.mMinToolsRevision = PackageParserUtils.parseFullRevisionElement(PackageParserUtils.findChildElement(packageNode, "min-tools-rev"));
    }

    public MinToolsPackage(SdkSource source, Properties props, int revision, String license, String description, String descUrl, Archive.Os archiveOs, Archive.Arch archiveArch, String archiveOsPath) {
        super(source, props, revision, license, description, descUrl, archiveOs, archiveArch, archiveOsPath);
        String revStr = MinToolsPackage.getProperty(props, "Platform.MinToolsRev", null);
        FullRevision rev = MIN_TOOLS_REV_NOT_SPECIFIED;
        if (revStr != null) {
            try {
                rev = FullRevision.parseRevision(revStr);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        this.mMinToolsRevision = rev;
    }

    @Override
    public FullRevision getMinToolsRevision() {
        return this.mMinToolsRevision;
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        if (!this.getMinToolsRevision().equals(MIN_TOOLS_REV_NOT_SPECIFIED)) {
            props.setProperty("Platform.MinToolsRev", this.getMinToolsRevision().toShortString());
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mMinToolsRevision == null ? 0 : this.mMinToolsRevision.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MinToolsPackage)) {
            return false;
        }
        MinToolsPackage other = (MinToolsPackage)obj;
        return !(this.mMinToolsRevision == null ? other.mMinToolsRevision != null : !this.mMinToolsRevision.equals(other.mMinToolsRevision));
    }
}

