/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public abstract class MajorRevisionPackage
extends Package {
    private final MajorRevision mRevision;

    MajorRevisionPackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        this.mRevision = new MajorRevision(PackageParserUtils.getXmlInt(packageNode, "revision", 0));
    }

    public MajorRevisionPackage(SdkSource source, Properties props, int revision, String license, String description, String descUrl, Archive.Os archiveOs, Archive.Arch archiveArch, String archiveOsPath) {
        super(source, props, revision, license, description, descUrl, archiveOs, archiveArch, archiveOsPath);
        String revStr = MajorRevisionPackage.getProperty(props, "Pkg.Revision", null);
        MajorRevision rev = null;
        if (revStr != null) {
            try {
                rev = MajorRevision.parseRevision(revStr);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        if (rev == null) {
            rev = new MajorRevision(revision);
        }
        this.mRevision = rev;
    }

    @Override
    public FullRevision getRevision() {
        return this.mRevision;
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        props.setProperty("Pkg.Revision", this.mRevision.toString());
    }

    @Override
    public Package.UpdateInfo canBeUpdatedBy(Package replacementPackage) {
        if (replacementPackage == null) {
            return Package.UpdateInfo.INCOMPATIBLE;
        }
        if (!this.sameItemAs(replacementPackage)) {
            return Package.UpdateInfo.INCOMPATIBLE;
        }
        if (replacementPackage.getRevision().compareTo(this.getRevision()) > 0) {
            return Package.UpdateInfo.UPDATE;
        }
        return Package.UpdateInfo.NOT_UPDATE;
    }
}

