/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;

public class BuildToolInfo {
    private final FullRevision mRevision;
    private final File mPath;
    private final Map<PathId, String> mPaths = Maps.newEnumMap(PathId.class);

    public BuildToolInfo(@NonNull FullRevision revision, @NonNull File path) {
        this.mRevision = revision;
        this.mPath = path;
        this.add(PathId.AAPT, SdkConstants.FN_AAPT);
        this.add(PathId.AIDL, SdkConstants.FN_AIDL);
        this.add(PathId.DX, SdkConstants.FN_DX);
        this.add(PathId.DX_JAR, "lib" + File.separator + "dx.jar");
        this.add(PathId.LLVM_RS_CC, SdkConstants.FN_RENDERSCRIPT);
        this.add(PathId.ANDROID_RS, SdkConstants.OS_FRAMEWORK_RS);
        this.add(PathId.ANDROID_RS_CLANG, SdkConstants.OS_FRAMEWORK_RS_CLANG);
    }

    public BuildToolInfo(FullRevision revision, @NonNull File mainPath, @NonNull File aapt, @NonNull File aidl, @NonNull File dx, @NonNull File dxJar, @NonNull File llmvRsCc, @NonNull File androidRs, @NonNull File androidRsClang) {
        this.mRevision = revision;
        this.mPath = mainPath;
        this.add(PathId.AAPT, aapt);
        this.add(PathId.AIDL, aidl);
        this.add(PathId.DX, dx);
        this.add(PathId.DX_JAR, dxJar);
        this.add(PathId.LLVM_RS_CC, llmvRsCc);
        this.add(PathId.ANDROID_RS, androidRs);
        this.add(PathId.ANDROID_RS_CLANG, androidRsClang);
    }

    private void add(PathId id, String leaf) {
        this.add(id, new File(this.mPath, leaf));
    }

    private void add(PathId id, File path) {
        String str = path.getAbsolutePath();
        if (path.isDirectory() && str.charAt(str.length() - 1) != File.separatorChar) {
            str = str + File.separatorChar;
        }
        this.mPaths.put(id, str);
    }

    @NonNull
    public FullRevision getRevision() {
        return this.mRevision;
    }

    @NonNull
    public File getLocation() {
        return this.mPath;
    }

    public String getPath(PathId pathId) {
        return this.mPaths.get((Object)pathId);
    }

    public boolean isValid(@Nullable ILogger log) {
        for (Map.Entry<PathId, String> entry : this.mPaths.entrySet()) {
            File f = new File(entry.getValue());
            if (f.exists()) continue;
            if (log != null) {
                log.warning("Build-tool %1$s is missing %2$s at %3$s", new Object[]{this.mRevision.toString(), entry.getKey(), f.getAbsolutePath()});
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<BuildToolInfo rev=").append(this.mRevision);
        builder.append(", mPath=").append(this.mPath);
        builder.append(", mPaths=").append(this.mPaths);
        builder.append(">");
        return builder.toString();
    }

    public static enum PathId {
        AAPT,
        AIDL,
        DX,
        DX_JAR,
        LLVM_RS_CC,
        ANDROID_RS,
        ANDROID_RS_CLANG;

    }
}

