/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.output;

import com.android.annotations.NonNull;
import com.android.ide.common.blame.SourceFragmentPositionRange;
import com.android.ide.common.blame.output.GradleMessage;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;

public class GradleMessageRewriter {
    public static final String STDOUT_ERROR_TAG = "AGPBI: ";
    private final ToolOutputParser mParser;
    private final Gson mGson;
    private final ErrorFormatMode mErrorFormatMode;

    public GradleMessageRewriter(ToolOutputParser parser, ErrorFormatMode errorFormatMode) {
        this.mParser = parser;
        this.mErrorFormatMode = errorFormatMode;
        this.mGson = GradleMessageRewriter.createGson();
    }

    public String rewriteMessages(@NonNull String originalMessage) {
        List<GradleMessage> messages = this.mParser.parseToolOutput(originalMessage);
        if (messages.isEmpty()) {
            return originalMessage;
        }
        StringBuilder errorStringBuilder = new StringBuilder();
        for (GradleMessage message : messages) {
            if (this.mErrorFormatMode == ErrorFormatMode.HUMAN_READABLE) {
                if (message.getPosition() != null && message.getPosition().getStartLine() != -1) {
                    errorStringBuilder.append(" Position ");
                    errorStringBuilder.append(message.getPosition().toString());
                    errorStringBuilder.append(" : ");
                }
                errorStringBuilder.append(message.getText()).append("\n");
                continue;
            }
            errorStringBuilder.append(STDOUT_ERROR_TAG).append(this.mGson.toJson((Object)message)).append("\n");
        }
        return errorStringBuilder.toString();
    }

    private static Gson createGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(SourceFragmentPositionRange.class, (Object)new SourceFragmentPositionRange.Serializer());
        return gsonBuilder.create();
    }

    public static enum ErrorFormatMode {
        MACHINE_PARSABLE,
        HUMAN_READABLE;

    }
}

