/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NodeUtils {
    NodeUtils() {
    }

    static Node adoptNode(Document document, Node node) {
        Node newNode = document.adoptNode(node);
        NodeUtils.updateNamespace(newNode, document);
        return newNode;
    }

    static void addAttribute(Document document, Node node, String namespaceUri, String attrName, String attrValue) {
        Attr attr = namespaceUri != null ? document.createAttributeNS(namespaceUri, attrName) : document.createAttribute(attrName);
        attr.setValue(attrValue);
        if (namespaceUri != null) {
            node.getAttributes().setNamedItemNS(attr);
        } else {
            node.getAttributes().setNamedItem(attr);
        }
    }

    private static void updateNamespace(Node node, Document document) {
        NodeList children;
        NodeUtils.processSingleNodeNamespace(node, document);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                NodeUtils.processSingleNodeNamespace(attributes.item(i), document);
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                Node child = children.item(i);
                if (child == null) continue;
                NodeUtils.updateNamespace(child, document);
            }
        }
    }

    private static void processSingleNodeNamespace(Node node, Document document) {
        String ns = node.getNamespaceURI();
        if (ns != null) {
            NamedNodeMap docAttributes = document.getAttributes();
            String prefix = NodeUtils.getPrefixForNs(docAttributes, ns);
            if (prefix == null) {
                prefix = NodeUtils.getUniqueNsAttribute(docAttributes);
                Attr nsAttr = document.createAttribute(prefix);
                nsAttr.setValue(ns);
                document.getChildNodes().item(0).getAttributes().setNamedItem(nsAttr);
            }
            prefix = prefix.substring(6);
            node.setPrefix(prefix);
        }
    }

    private static String getPrefixForNs(NamedNodeMap attributes, String ns) {
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attribute = (Attr)attributes.item(i);
                if (!ns.equals(attribute.getValue()) || !ns.startsWith("xmlns:")) continue;
                return attribute.getName();
            }
        }
        return null;
    }

    private static String getUniqueNsAttribute(NamedNodeMap attributes) {
        String name;
        if (attributes == null) {
            return "xmlns:ns1";
        }
        int i = 2;
        while (attributes.getNamedItem(name = String.format("xmlns:ns%d", i++)) != null) {
        }
        return name;
    }

    static boolean compareElementNode(Node node1, Node node2) {
        NamedNodeMap attr2;
        if (!node1.getNodeName().equals(node2.getNodeName())) {
            return false;
        }
        NamedNodeMap attr1 = node1.getAttributes();
        return NodeUtils.compareAttributes(attr1, attr2 = node2.getAttributes()) && NodeUtils.compareChildren(node1.getChildNodes(), node2.getChildNodes());
    }

    private static boolean compareChildren(NodeList children1, NodeList children2) {
        if (children1.getLength() != children2.getLength()) {
            return false;
        }
        int n = children1.getLength();
        block4: for (int i = 0; i < n; ++i) {
            Node child1 = children1.item(i);
            Node child2 = children2.item(i);
            short nodeType = child1.getNodeType();
            if (nodeType != child2.getNodeType()) {
                return false;
            }
            switch (nodeType) {
                case 1: {
                    if (NodeUtils.compareElementNode(child1, child2)) continue block4;
                    return false;
                }
                case 3: 
                case 4: 
                case 8: {
                    if (child1.getNodeValue().trim().equals(child2.getNodeValue().trim())) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    static boolean compareAttributes(NamedNodeMap attrMap1, NamedNodeMap attrMap2) {
        if (attrMap1.getLength() != attrMap2.getLength()) {
            return false;
        }
        int n = attrMap1.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr1 = (Attr)attrMap1.item(i);
            String ns1 = attr1.getNamespaceURI();
            Attr attr2 = ns1 != null ? (Attr)attrMap2.getNamedItemNS(ns1, attr1.getLocalName()) : (Attr)attrMap2.getNamedItem(attr1.getName());
            if (attr2 != null && attr2.getValue().equals(attr1.getValue())) continue;
            return false;
        }
        return true;
    }
}

