/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.javac;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import lombok.ast.AbstractNode;
import lombok.ast.AlternateConstructorInvocation;
import lombok.ast.Annotation;
import lombok.ast.AnnotationDeclaration;
import lombok.ast.AnnotationElement;
import lombok.ast.AnnotationMethodDeclaration;
import lombok.ast.ArrayAccess;
import lombok.ast.ArrayCreation;
import lombok.ast.ArrayDimension;
import lombok.ast.ArrayInitializer;
import lombok.ast.Assert;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.Block;
import lombok.ast.BooleanLiteral;
import lombok.ast.Break;
import lombok.ast.Case;
import lombok.ast.Cast;
import lombok.ast.Catch;
import lombok.ast.CharLiteral;
import lombok.ast.ClassDeclaration;
import lombok.ast.ClassLiteral;
import lombok.ast.Comment;
import lombok.ast.CompilationUnit;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Continue;
import lombok.ast.ConversionPositionInfo;
import lombok.ast.Default;
import lombok.ast.DoWhile;
import lombok.ast.EmptyDeclaration;
import lombok.ast.EmptyStatement;
import lombok.ast.EnumConstant;
import lombok.ast.EnumDeclaration;
import lombok.ast.EnumTypeBody;
import lombok.ast.Expression;
import lombok.ast.ExpressionStatement;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.For;
import lombok.ast.ForEach;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Identifier;
import lombok.ast.If;
import lombok.ast.ImportDeclaration;
import lombok.ast.InlineIfExpression;
import lombok.ast.InstanceInitializer;
import lombok.ast.InstanceOf;
import lombok.ast.IntegralLiteral;
import lombok.ast.InterfaceDeclaration;
import lombok.ast.JavadocContainer;
import lombok.ast.KeywordModifier;
import lombok.ast.LabelledStatement;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.NullLiteral;
import lombok.ast.PackageDeclaration;
import lombok.ast.Position;
import lombok.ast.RawListAccessor;
import lombok.ast.Return;
import lombok.ast.Select;
import lombok.ast.StaticInitializer;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.Super;
import lombok.ast.SuperConstructorInvocation;
import lombok.ast.Switch;
import lombok.ast.Synchronized;
import lombok.ast.This;
import lombok.ast.Throw;
import lombok.ast.Try;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.TypeVariable;
import lombok.ast.UnaryExpression;
import lombok.ast.UnaryOperator;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import lombok.ast.While;
import lombok.ast.WildcardKind;
import lombok.ast.javac.JcTreeBuilder;
import lombok.javac.CommentInfo;

public class JcTreeConverter {
    private java.util.List<? extends Node> result;
    private Map<JCTree, Integer> endPosTable;
    private ConvertingVisitor visitor = new ConvertingVisitor();
    private Map<FlagKey, Object> params;
    private static final Field JCWILDCARD_KIND;
    private static final Field JCTREE_TAG;
    private static final Method JCTREE_GETTAG;

    public JcTreeConverter() {
        this(null, null);
    }

    public JcTreeConverter(Map<JCTree, Integer> endPosTable, Map<FlagKey, Object> params) {
        this.endPosTable = endPosTable;
        this.params = params == null ? ImmutableMap.of() : params;
    }

    private boolean hasFlag(FlagKey key) {
        return this.params.containsKey((Object)key);
    }

    private Object getFlag(FlagKey key) {
        return this.params.get((Object)key);
    }

    java.util.List<? extends Node> getAll() {
        return this.result;
    }

    Node get() {
        if (this.result.isEmpty()) {
            return null;
        }
        if (this.result.size() == 1) {
            return this.result.get(0);
        }
        throw new RuntimeException("Expected only one result but got " + this.result.size());
    }

    private void set(JCTree node, Node value) {
        if (this.result != null) {
            throw new IllegalStateException("result is already set");
        }
        if (value != null && value.getPosition().isUnplaced()) {
            this.setPos(node, value);
        }
        ArrayList result = Lists.newArrayList();
        if (value != null) {
            result.add(value);
        }
        this.result = result;
    }

    private Node toTree(JCTree node, FlagKey ... keys) {
        EnumMap map = Maps.newEnumMap(FlagKey.class);
        for (FlagKey key : keys) {
            map.put(key, key);
        }
        return this.toTree(node, map);
    }

    private Node toTree(JCTree node, Map<FlagKey, Object> params) {
        if (node == null) {
            return null;
        }
        JcTreeConverter newConverter = new JcTreeConverter(this.endPosTable, params);
        node.accept(newConverter.visitor);
        try {
            return newConverter.get();
        }
        catch (RuntimeException e) {
            System.err.printf("Node '%s' (%s) did not produce any results\n", node, node.getClass().getSimpleName());
            throw e;
        }
    }

    private void addJavadoc(JavadocContainer container, JCTree.JCModifiers mods) {
        if ((mods.flags & 0x20000L) != 0L) {
            container.astJavadoc(new Comment().astBlockComment(true).astContent("*\n * @deprecated\n "));
        }
    }

    private Node toVariableDefinition(java.util.List<JCTree.JCVariableDecl> decls, FlagKey ... keys) {
        EnumMap map = Maps.newEnumMap(FlagKey.class);
        for (FlagKey key : keys) {
            map.put(key, key);
        }
        return this.toVariableDefinition(decls, map);
    }

    private Position getPosition(JCTree node) {
        if (node == null) {
            return Position.UNPLACED;
        }
        int start = node.pos;
        Integer end_ = null;
        if (this.endPosTable != null) {
            end_ = this.endPosTable.get(node);
        }
        int end = end_ == null ? node.getEndPosition(this.endPosTable) : end_.intValue();
        return new Position(start, end);
    }

    private Node toVariableDefinition(java.util.List<JCTree.JCVariableDecl> decls, Map<FlagKey, Object> keys) {
        int endPosType;
        boolean createDeclaration;
        boolean bl = createDeclaration = !keys.containsKey((Object)FlagKey.VARDEF_IS_DEFINITION);
        if (decls == null || decls.isEmpty()) {
            VariableDefinition def = new VariableDefinition();
            return createDeclaration ? new VariableDeclaration().astDefinition(def) : def;
        }
        JCTree.JCVariableDecl first = decls.get(0);
        int startPosFirst = first.pos;
        JCTree.JCExpression baseType = first.vartype;
        while (baseType instanceof JCTree.JCArrayTypeTree && (endPosType = baseType.getEndPosition(this.endPosTable)) != -1 && startPosFirst != -1 && endPosType > startPosFirst) {
            baseType = ((JCTree.JCArrayTypeTree)baseType).elemtype;
        }
        VariableDefinition def = new VariableDefinition();
        def.astModifiers((Modifiers)this.toTree((JCTree)first.mods, new FlagKey[0]));
        this.setPos(decls.get(decls.size() - 1), def);
        if (decls.size() > 1) {
            def.setPosition(new Position(startPosFirst, def.getPosition().getEnd()));
        }
        int baseDims = JcTreeConverter.countDims(baseType);
        if ((first.mods.flags & 0x400000000L) != 0L) {
            def.astVarargs(true);
            ConversionPositionInfo.setConversionPositionInfo(def, "...", this.getPosition(baseType));
            if (baseType instanceof JCTree.JCArrayTypeTree) {
                baseType = ((JCTree.JCArrayTypeTree)baseType).elemtype;
            }
        }
        def.rawTypeReference(this.toTree((JCTree)baseType, FlagKey.TYPE_REFERENCE));
        def.astVarargs((first.mods.flags & 0x400000000L) != 0L);
        for (JCTree.JCVariableDecl varDecl : decls) {
            int extraDims = JcTreeConverter.countDims(varDecl.vartype) - baseDims;
            VariableDefinitionEntry entry = new VariableDefinitionEntry();
            entry.astArrayDimensions(extraDims);
            entry.astName(this.setPos(varDecl, new Identifier().astValue(varDecl.name.toString())));
            entry.rawInitializer(this.toTree((JCTree)varDecl.init, new FlagKey[0]));
            this.setPos(varDecl, entry);
            if (extraDims > 0) {
                JCTree.JCArrayTypeTree arrayType = (JCTree.JCArrayTypeTree)varDecl.vartype;
                for (int i = 0; i < extraDims; ++i) {
                    if (arrayType != null) {
                        ConversionPositionInfo.setConversionPositionInfo(entry, "[]" + (extraDims - i - 1), this.getPosition(arrayType));
                    }
                    arrayType = arrayType.elemtype instanceof JCTree.JCArrayTypeTree ? (JCTree.JCArrayTypeTree)arrayType.elemtype : null;
                }
            }
            def.astVariables().addToEnd(new VariableDefinitionEntry[]{entry});
        }
        if (createDeclaration) {
            VariableDeclaration decl = new VariableDeclaration().astDefinition(def);
            decl.setPosition(def.getPosition());
            this.addJavadoc(decl, first.mods);
            return decl;
        }
        return def;
    }

    private static int countDims(JCTree.JCExpression type) {
        int dims = 0;
        while (type instanceof JCTree.JCArrayTypeTree) {
            type = ((JCTree.JCArrayTypeTree)type).elemtype;
            ++dims;
        }
        return dims;
    }

    private void fillList(java.util.List<? extends JCTree> nodes, RawListAccessor<?, ?> list, FlagKey ... keys) {
        EnumMap map = Maps.newEnumMap(FlagKey.class);
        for (FlagKey key : keys) {
            map.put(key, key);
        }
        this.fillList(nodes, list, map);
    }

    private void fillList(java.util.List<? extends JCTree> nodes, RawListAccessor<?, ?> list, Map<FlagKey, Object> keys) {
        if (nodes == null) {
            return;
        }
        ArrayList<JCTree.JCVariableDecl> varDeclQueue = new ArrayList<JCTree.JCVariableDecl>();
        boolean fold = !keys.containsKey((Object)FlagKey.NO_VARDECL_FOLDING);
        for (JCTree jCTree : nodes) {
            if (jCTree instanceof JCTree.JCVariableDecl) {
                if (fold && (varDeclQueue.isEmpty() || ((JCTree.JCVariableDecl)varDeclQueue.get((int)0)).mods == ((JCTree.JCVariableDecl)jCTree).mods)) {
                    varDeclQueue.add((JCTree.JCVariableDecl)jCTree);
                    continue;
                }
                if (!varDeclQueue.isEmpty()) {
                    list.addToEnd(this.toVariableDefinition(varDeclQueue, keys));
                }
                varDeclQueue.clear();
                varDeclQueue.add((JCTree.JCVariableDecl)jCTree);
                continue;
            }
            if (!varDeclQueue.isEmpty()) {
                list.addToEnd(this.toVariableDefinition(varDeclQueue, keys));
            }
            varDeclQueue.clear();
            list.addToEnd(this.toTree(jCTree, keys));
        }
        if (!varDeclQueue.isEmpty()) {
            list.addToEnd(this.toVariableDefinition(varDeclQueue, keys));
        }
    }

    private static JCTree removeParens(JCTree node) {
        if (!(node instanceof JCTree.JCParens)) {
            return node;
        }
        return ((JCTree.JCParens)node).getExpression();
    }

    public void visit(JCTree.JCCompilationUnit cu) {
        this.visit(cu, (Map<JCTree, Integer>)((Object)cu.endPositions));
    }

    public void visit(JCTree node, Map<JCTree, Integer> endPosTable) {
        this.endPosTable = endPosTable;
        node.accept(this.visitor);
    }

    public Node getResult() {
        return this.get();
    }

    public Node getResultWithJavadoc(java.util.List<CommentInfo> comments) {
        ListBuffer javadocs = ListBuffer.lb();
        for (CommentInfo commentInfo : comments) {
            if (!commentInfo.isJavadoc()) continue;
            javadocs.append(commentInfo);
        }
        Node result = this.getResult();
        if (javadocs.isEmpty()) {
            return result;
        }
        final TreeMap nodePositions = new TreeMap();
        result.accept(new ForwardingAstVisitor(){

            private void addToMap(Node positionNode, Node linked) {
                if (positionNode == null) {
                    return;
                }
                int start = positionNode.getPosition().getStart();
                if (start == -1) {
                    return;
                }
                if (linked instanceof JavadocContainer || !nodePositions.containsKey(start)) {
                    nodePositions.put(start, linked);
                }
            }

            private void addToMap(StrictListAccessor<?, ?> nodes, Node linked) {
                if (nodes == null) {
                    return;
                }
                for (Node node : nodes) {
                    this.addToMap(node, linked);
                }
            }

            @Override
            public boolean visitNode(Node node) {
                int start = node.getPosition().getStart();
                this.addToMap(node, node);
                try {
                    if (node instanceof VariableDeclaration) {
                        this.addToMap(((VariableDeclaration)node).astDefinition().astModifiers(), node);
                        this.addToMap(((VariableDeclaration)node).astDefinition().astModifiers().astAnnotations(), node);
                        this.addToMap(((VariableDeclaration)node).astDefinition().astTypeReference(), node);
                        this.addToMap(((VariableDeclaration)node).astDefinition().astVariables().first().astName(), node);
                    } else if (node instanceof TypeDeclaration) {
                        this.addToMap(((TypeDeclaration)node).astModifiers(), node);
                        this.addToMap(((TypeDeclaration)node).astModifiers().astAnnotations(), node);
                    } else if (node instanceof MethodDeclaration) {
                        this.addToMap(((MethodDeclaration)node).astModifiers(), node);
                        this.addToMap(((MethodDeclaration)node).astModifiers().astAnnotations(), node);
                        this.addToMap(((MethodDeclaration)node).astTypeVariables().first(), node);
                        this.addToMap(((MethodDeclaration)node).astReturnTypeReference(), node);
                        this.addToMap(((MethodDeclaration)node).astMethodName(), node);
                    } else if (node instanceof ConstructorDeclaration) {
                        this.addToMap(((ConstructorDeclaration)node).astModifiers(), node);
                        this.addToMap(((ConstructorDeclaration)node).astModifiers().astAnnotations(), node);
                        this.addToMap(((ConstructorDeclaration)node).astTypeVariables().first(), node);
                        this.addToMap(((ConstructorDeclaration)node).astTypeName(), node);
                    } else if (node instanceof EnumConstant) {
                        this.addToMap(((EnumConstant)node).astName(), node);
                        this.addToMap(((EnumConstant)node).astAnnotations(), node);
                    } else if (node instanceof AnnotationMethodDeclaration) {
                        this.addToMap(((AnnotationMethodDeclaration)node).astModifiers(), node);
                        this.addToMap(((AnnotationMethodDeclaration)node).astModifiers().astAnnotations(), node);
                        this.addToMap(((AnnotationMethodDeclaration)node).astReturnTypeReference(), node);
                        this.addToMap(((AnnotationMethodDeclaration)node).astMethodName(), node);
                    } else if (node instanceof PackageDeclaration) {
                        this.addToMap(((PackageDeclaration)node).astAnnotations(), node);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (node instanceof JavadocContainer || !nodePositions.containsKey(start)) {
                    nodePositions.put(start, node);
                }
                return false;
            }
        });
        for (CommentInfo javadoc : javadocs) {
            try {
                Integer key = nodePositions.tailMap(javadoc.endPos).firstKey();
                Node node = (Node)nodePositions.get(key);
                if (!(node instanceof JavadocContainer)) continue;
                this.attachJavadocToNode(javadoc, (JavadocContainer)node);
            }
            catch (NoSuchElementException e) {}
        }
        return result;
    }

    private void attachJavadocToNode(CommentInfo javadoc, JavadocContainer node) {
        int oldStart;
        String content = javadoc.content;
        if (content.startsWith("/*") && content.endsWith("*/")) {
            content = content.substring(2, content.length() - 2);
        }
        Comment comment = new Comment().astBlockComment(true).astContent(content);
        comment.setPosition(new Position(javadoc.pos, javadoc.endPos));
        node.astJavadoc(comment);
        if (!(node.getPosition().isUnplaced() || (oldStart = node.getPosition().getStart()) != -1 && comment.getPosition().getStart() >= oldStart)) {
            node.setPosition(new Position(comment.getPosition().getStart(), node.getPosition().getEnd()));
        }
    }

    private <N extends Node> N setPos(JCTree node, N astNode) {
        if (astNode != null && node != null) {
            int end;
            int start = node.pos;
            Integer end_ = this.endPosTable.get(node);
            if (node instanceof JCTree.JCUnary) {
                end_ = node.getEndPosition(this.endPosTable);
            }
            int n = end = end_ == null ? node.getEndPosition(this.endPosTable) : end_.intValue();
            if (start != -1 && end != -1) {
                astNode.setPosition(new Position(start, end));
            }
        }
        return astNode;
    }

    private void fillWithIdentifiers(JCTree node, StrictListAccessor<Identifier, ?> list) {
        if (node instanceof JCTree.JCIdent) {
            JCTree.JCIdent id = (JCTree.JCIdent)node;
            list.addToEnd(new Identifier[]{this.setPos(node, new Identifier().astValue(id.name.toString()))});
        } else if (node instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess sel = (JCTree.JCFieldAccess)node;
            this.fillWithIdentifiers(sel.selected, list);
            list.addToEnd(new Identifier[]{this.setPos(node, new Identifier().astValue(sel.name.toString()))});
        }
    }

    private static void setConversionStructureInfo(Node node, String key) {
        ConversionPositionInfo.setConversionPositionInfo(node, key, Position.UNPLACED);
    }

    static {
        Field f = null;
        try {
            f = JCTree.JCWildcard.class.getDeclaredField("kind");
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        JCWILDCARD_KIND = f;
        f = null;
        try {
            f = JCTree.class.getDeclaredField("tag");
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        JCTREE_TAG = f;
        Method m = null;
        try {
            m = JCTree.class.getDeclaredMethod("getTag", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        JCTREE_GETTAG = m;
    }

    private class ConvertingVisitor
    extends JCTree.Visitor {
        private static final long ENUM_CONSTANT_FLAGS = 16409L;

        private ConvertingVisitor() {
        }

        @Override
        public void visitTree(JCTree node) {
            throw new UnsupportedOperationException("visit" + node.getClass().getSimpleName() + " not implemented");
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit node) {
            CompilationUnit unit = new CompilationUnit();
            if (node.pid != null) {
                PackageDeclaration pkg = new PackageDeclaration();
                JcTreeConverter.this.fillWithIdentifiers(node.pid, pkg.astParts());
                unit.astPackageDeclaration((PackageDeclaration)JcTreeConverter.this.setPos(node.pid, pkg));
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.packageAnnotations, pkg.rawAnnotations(), new FlagKey[0]);
            }
            for (JCTree def : node.defs) {
                if (def instanceof JCTree.JCImport) {
                    unit.rawImportDeclarations().addToEnd(JcTreeConverter.this.toTree(def, new FlagKey[0]));
                    continue;
                }
                unit.rawTypeDeclarations().addToEnd(JcTreeConverter.this.toTree(def, new FlagKey[]{FlagKey.SKIP_IS_DECL}));
            }
            JcTreeConverter.setConversionStructureInfo(unit, "converted");
            JcTreeConverter.this.set(node, unit);
        }

        @Override
        public void visitImport(JCTree.JCImport node) {
            ImportDeclaration imp = new ImportDeclaration();
            JcTreeConverter.this.fillWithIdentifiers((JCTree)node.getQualifiedIdentifier(), imp.astParts());
            Identifier last = imp.astParts().last();
            if (last != null && "*".equals(last.astValue())) {
                imp.astParts().remove(last);
                imp.astStarImport(true);
                ConversionPositionInfo.setConversionPositionInfo(imp, ".*", last.getPosition());
            }
            imp.astStaticImport(node.isStatic());
            JcTreeConverter.this.set(node, imp);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl node) {
            AbstractNode typeDecl;
            long flags = node.mods.flags;
            String name = node.getSimpleName().toString();
            HashMap flagKeyMap = Maps.newHashMap();
            flagKeyMap.put(FlagKey.CONTAINING_TYPE_NAME, name);
            flagKeyMap.put(FlagKey.BLOCKS_ARE_INITIALIZERS, FlagKey.BLOCKS_ARE_INITIALIZERS);
            flagKeyMap.put(FlagKey.SKIP_IS_DECL, FlagKey.SKIP_IS_DECL);
            if ((flags & 0x4200L) == 0L) {
                ClassDeclaration classDecl = new ClassDeclaration();
                typeDecl = classDecl;
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.implementing, classDecl.rawImplementing(), new FlagKey[]{FlagKey.TYPE_REFERENCE});
                classDecl.rawExtending(JcTreeConverter.this.toTree(node.extending, new FlagKey[]{FlagKey.TYPE_REFERENCE}));
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.typarams, classDecl.rawTypeVariables(), new FlagKey[0]);
                NormalTypeBody body = new NormalTypeBody();
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.defs, body.rawMembers(), flagKeyMap);
                classDecl.astBody(body);
            } else if ((flags & 0x2000L) != 0L) {
                AnnotationDeclaration annDecl = new AnnotationDeclaration();
                typeDecl = annDecl;
                NormalTypeBody body = new NormalTypeBody();
                flagKeyMap.put(FlagKey.METHODS_ARE_ANNMETHODS, FlagKey.METHODS_ARE_ANNMETHODS);
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.defs, body.rawMembers(), flagKeyMap);
                annDecl.astBody(body);
            } else if ((flags & 0x200L) != 0L) {
                InterfaceDeclaration itfDecl = new InterfaceDeclaration();
                typeDecl = itfDecl;
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.typarams, itfDecl.rawTypeVariables(), new FlagKey[0]);
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.implementing, itfDecl.rawExtending(), new FlagKey[]{FlagKey.TYPE_REFERENCE});
                NormalTypeBody body = new NormalTypeBody();
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.defs, body.rawMembers(), flagKeyMap);
                itfDecl.astBody(body);
            } else if ((flags & 0x4000L) != 0L) {
                EnumDeclaration enumDecl = new EnumDeclaration();
                typeDecl = enumDecl;
                EnumTypeBody body = new EnumTypeBody();
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.implementing, enumDecl.rawImplementing(), new FlagKey[]{FlagKey.TYPE_REFERENCE});
                ArrayList<JCTree> defs = new ArrayList<JCTree>();
                for (JCTree def : node.defs) {
                    if (def instanceof JCTree.JCVariableDecl) {
                        JCTree.JCVariableDecl vd = (JCTree.JCVariableDecl)def;
                        if (vd.mods != null && (vd.mods.flags & 0x4019L) == 16409L) {
                            EnumConstant ec = new EnumConstant();
                            JcTreeConverter.this.setPos(def, ec);
                            ec.astName(new Identifier().astValue(vd.getName().toString()));
                            JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)vd.mods.annotations, ec.rawAnnotations(), new FlagKey[0]);
                            if (vd.init instanceof JCTree.JCNewClass) {
                                JCTree.JCNewClass init = (JCTree.JCNewClass)vd.init;
                                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)init.getArguments(), ec.rawArguments(), new FlagKey[0]);
                                if (init.getClassBody() != null) {
                                    NormalTypeBody constantBody = (NormalTypeBody)JcTreeConverter.this.setPos(init, new NormalTypeBody());
                                    JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)init.getClassBody().getMembers(), constantBody.rawMembers(), new FlagKey[0]);
                                    ec.astBody(constantBody);
                                }
                                ConversionPositionInfo.setConversionPositionInfo(ec, "newClass", JcTreeConverter.this.getPosition(init));
                            }
                            body.astConstants().addToEnd(new EnumConstant[]{ec});
                            continue;
                        }
                    }
                    defs.add(def);
                }
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)defs, body.rawMembers(), flagKeyMap);
                enumDecl.astBody(body);
            } else {
                throw new IllegalStateException("Unknown type declaration: " + node);
            }
            typeDecl.astName(new Identifier().astValue(name));
            typeDecl.astModifiers((Modifiers)JcTreeConverter.this.toTree(node.mods, new FlagKey[0]));
            JcTreeConverter.this.addJavadoc((JavadocContainer)((Object)typeDecl), node.mods);
            JcTreeConverter.this.set(node, typeDecl);
        }

        @Override
        public void visitModifiers(JCTree.JCModifiers node) {
            Modifiers m = new Modifiers();
            JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.annotations, m.rawAnnotations(), new FlagKey[0]);
            for (KeywordModifier mod : KeywordModifier.fromReflectModifiers((int)node.flags)) {
                m.astKeywords().addToEnd(new KeywordModifier[]{mod});
            }
            JcTreeConverter.setConversionStructureInfo(m, "converted");
            JcTreeConverter.this.set(node, m);
        }

        @Override
        public void visitBlock(JCTree.JCBlock node) {
            Block b = new Block();
            JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.stats, b.rawContents(), new FlagKey[0]);
            JcTreeConverter.this.setPos(node, b);
            Node n = JcTreeConverter.this.hasFlag(FlagKey.BLOCKS_ARE_INITIALIZERS) ? ((node.flags & 8L) != 0L ? JcTreeConverter.this.setPos(node, new StaticInitializer().astBody(b)) : (b.rawContents().isEmpty() && node.endpos == -1 ? JcTreeConverter.this.setPos(node, new EmptyDeclaration()) : JcTreeConverter.this.setPos(node, new InstanceInitializer().astBody(b)))) : b;
            JcTreeConverter.this.set(node, n);
        }

        @Override
        public void visitSkip(JCTree.JCSkip node) {
            if (JcTreeConverter.this.hasFlag(FlagKey.SKIP_IS_DECL)) {
                JcTreeConverter.this.set(node, new EmptyDeclaration());
            } else {
                JcTreeConverter.this.set(node, new EmptyStatement());
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl node) {
            if (JcTreeConverter.this.hasFlag(FlagKey.VARDEF_IS_DEFINITION)) {
                JcTreeConverter.this.set(node, JcTreeConverter.this.toVariableDefinition((java.util.List<JCTree.JCVariableDecl>)Collections.singletonList(node), new FlagKey[]{FlagKey.VARDEF_IS_DEFINITION}));
            } else {
                JcTreeConverter.this.set(node, JcTreeConverter.this.toVariableDefinition((java.util.List<JCTree.JCVariableDecl>)Collections.singletonList(node), new FlagKey[0]));
            }
        }

        @Override
        public void visitTypeIdent(JCTree.JCPrimitiveTypeTree node) {
            String primitiveType = (String)JcTreeBuilder.PRIMITIVES.inverse().get((Object)((int)node.typetag));
            if (primitiveType == null) {
                throw new IllegalArgumentException("Uknown primitive type tag: " + (int)node.typetag);
            }
            TypeReferencePart part = (TypeReferencePart)JcTreeConverter.this.setPos(node, new TypeReferencePart().astIdentifier((Identifier)JcTreeConverter.this.setPos(node, new Identifier().astValue(primitiveType))));
            JcTreeConverter.this.set(node, new TypeReference().astParts().addToEnd(new TypeReferencePart[]{part}));
        }

        @Override
        public void visitIdent(JCTree.JCIdent node) {
            String name = node.getName().toString();
            if ("this".equals(name)) {
                This t = new This();
                JcTreeConverter.this.set(node, t);
                ConversionPositionInfo.setConversionPositionInfo(t, "this", JcTreeConverter.this.getPosition(node));
                return;
            }
            if ("super".equals(name)) {
                Super s = new Super();
                JcTreeConverter.this.set(node, s);
                ConversionPositionInfo.setConversionPositionInfo(s, "super", JcTreeConverter.this.getPosition(node));
                return;
            }
            Identifier id = (Identifier)JcTreeConverter.this.setPos(node, new Identifier().astValue(name));
            if (JcTreeConverter.this.hasFlag(FlagKey.TYPE_REFERENCE)) {
                TypeReferencePart part = (TypeReferencePart)JcTreeConverter.this.setPos(node, new TypeReferencePart().astIdentifier(id));
                JcTreeConverter.this.set(node, new TypeReference().astParts().addToEnd(new TypeReferencePart[]{part}));
                return;
            }
            JcTreeConverter.this.set(node, new VariableReference().astIdentifier(id));
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess node) {
            String name = node.getIdentifier().toString();
            Identifier id = (Identifier)JcTreeConverter.this.setPos(node, new Identifier().astValue(name));
            Node selected = JcTreeConverter.this.toTree(node.selected, JcTreeConverter.this.params);
            if (JcTreeConverter.this.hasFlag(FlagKey.TYPE_REFERENCE)) {
                TypeReference parent = (TypeReference)selected;
                parent.astParts().addToEnd(new TypeReferencePart[]{(TypeReferencePart)JcTreeConverter.this.setPos(node, new TypeReferencePart().astIdentifier(id))});
                JcTreeConverter.this.set(node, parent);
                return;
            }
            if ("this".equals(name)) {
                This t = new This();
                ConversionPositionInfo.setConversionPositionInfo(t, "this", JcTreeConverter.this.getPosition(node));
                JcTreeConverter.this.set(node, t.rawQualifier(JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[]{FlagKey.TYPE_REFERENCE})));
                return;
            }
            if ("super".equals(name)) {
                Super s = new Super();
                ConversionPositionInfo.setConversionPositionInfo(s, "super", JcTreeConverter.this.getPosition(node));
                JcTreeConverter.this.set(node, s.rawQualifier(JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[]{FlagKey.TYPE_REFERENCE})));
                return;
            }
            if ("class".equals(name)) {
                ClassLiteral c = new ClassLiteral();
                ConversionPositionInfo.setConversionPositionInfo(c, "class", JcTreeConverter.this.getPosition(node));
                JcTreeConverter.this.set(node, c.rawTypeReference(JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[]{FlagKey.TYPE_REFERENCE})));
                return;
            }
            JcTreeConverter.this.set(node, new Select().astIdentifier(id).rawOperand(JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[0])));
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply node) {
            TypeReference ref = (TypeReference)JcTreeConverter.this.toTree(node.clazz, new FlagKey[]{FlagKey.TYPE_REFERENCE});
            TypeReferencePart last = ref.astParts().last();
            JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.arguments, last.rawTypeArguments(), new FlagKey[]{FlagKey.TYPE_REFERENCE});
            JcTreeConverter.this.setPos(node, ref);
            ConversionPositionInfo.setConversionPositionInfo(last, "<", JcTreeConverter.this.getPosition(node));
            JcTreeConverter.this.set(node, ref);
        }

        @Override
        public void visitWildcard(JCTree.JCWildcard node) {
            TypeReference ref = (TypeReference)JcTreeConverter.this.toTree(node.getBound(), new FlagKey[]{FlagKey.TYPE_REFERENCE});
            if (ref == null) {
                ref = new TypeReference();
            }
            switch (node.getKind()) {
                case UNBOUNDED_WILDCARD: {
                    ref.astWildcard(WildcardKind.UNBOUND);
                    break;
                }
                case EXTENDS_WILDCARD: {
                    ref.astWildcard(WildcardKind.EXTENDS);
                    ConversionPositionInfo.setConversionPositionInfo(ref, "extends", this.getTypeBoundKindPosition(node));
                    break;
                }
                case SUPER_WILDCARD: {
                    ref.astWildcard(WildcardKind.SUPER);
                    ConversionPositionInfo.setConversionPositionInfo(ref, "super", this.getTypeBoundKindPosition(node));
                }
            }
            JcTreeConverter.this.set(node, ref);
        }

        private Position getTypeBoundKindPosition(JCTree.JCWildcard node) {
            try {
                Object o = JCWILDCARD_KIND.get(node);
                if (o instanceof JCTree.TypeBoundKind) {
                    return JcTreeConverter.this.getPosition((JCTree.TypeBoundKind)o);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Position.UNPLACED;
        }

        private int getTag(JCTree node) {
            if (JCTREE_GETTAG != null) {
                try {
                    return (Integer)JCTREE_GETTAG.invoke((Object)node, new Object[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                return (Integer)JCTREE_TAG.get(node);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't get node tag");
            }
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter node) {
            TypeVariable var = new TypeVariable();
            var.astName((Identifier)JcTreeConverter.this.setPos(node, new Identifier().astValue(node.name.toString())));
            JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.bounds, var.rawExtending(), new FlagKey[]{FlagKey.TYPE_REFERENCE});
            JcTreeConverter.this.set(node, var);
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree node) {
            TypeReference ref = (TypeReference)JcTreeConverter.this.toTree(node.getType(), new FlagKey[]{FlagKey.TYPE_REFERENCE});
            int currentDim = ref.astArrayDimensions();
            ref.astArrayDimensions(currentDim + 1);
            ConversionPositionInfo.setConversionPositionInfo(ref, "[]" + currentDim, JcTreeConverter.this.getPosition(node));
            JcTreeConverter.this.set(node, ref);
        }

        @Override
        public void visitLiteral(JCTree.JCLiteral node) {
            Object val = node.getValue();
            boolean negative = false;
            IntegralLiteral literal = null;
            switch (node.getKind()) {
                case INT_LITERAL: {
                    int intValue = ((Number)val).intValue();
                    boolean bl = negative = intValue < 0;
                    if (intValue == Integer.MIN_VALUE) {
                        literal = new IntegralLiteral().astIntValue(Integer.MIN_VALUE);
                        break;
                    }
                    if (negative) {
                        literal = new IntegralLiteral().astIntValue(-intValue);
                        break;
                    }
                    literal = new IntegralLiteral().astIntValue(intValue);
                    break;
                }
                case LONG_LITERAL: {
                    long longValue = ((Number)val).longValue();
                    boolean bl = negative = longValue < 0L;
                    if (longValue == Long.MIN_VALUE) {
                        literal = new IntegralLiteral().astLongValue(Long.MIN_VALUE);
                        break;
                    }
                    if (negative) {
                        literal = new IntegralLiteral().astLongValue(-longValue);
                        break;
                    }
                    literal = new IntegralLiteral().astLongValue(longValue);
                    break;
                }
                case FLOAT_LITERAL: {
                    JcTreeConverter.this.set(node, new FloatingPointLiteral().astFloatValue(((Number)val).floatValue()));
                    return;
                }
                case DOUBLE_LITERAL: {
                    JcTreeConverter.this.set(node, new FloatingPointLiteral().astDoubleValue(((Number)val).doubleValue()));
                    return;
                }
                case BOOLEAN_LITERAL: {
                    JcTreeConverter.this.set(node, new BooleanLiteral().astValue((Boolean)val));
                    return;
                }
                case CHAR_LITERAL: {
                    JcTreeConverter.this.set(node, new CharLiteral().astValue((Character)val));
                    return;
                }
                case STRING_LITERAL: {
                    JcTreeConverter.this.set(node, new StringLiteral().astValue(val == null ? "" : val.toString()));
                    return;
                }
                case NULL_LITERAL: {
                    JcTreeConverter.this.set(node, new NullLiteral());
                    return;
                }
            }
            if (literal != null) {
                if (negative) {
                    JcTreeConverter.this.set(node, new UnaryExpression().astOperand((Expression)JcTreeConverter.this.setPos(node, literal)).astOperator(UnaryOperator.UNARY_MINUS));
                } else {
                    JcTreeConverter.this.set(node, literal);
                }
            } else {
                throw new IllegalArgumentException("Unknown JCLiteral type tag:" + (int)node.typetag);
            }
        }

        @Override
        public void visitParens(JCTree.JCParens node) {
            Expression expr = (Expression)JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[0]);
            expr.astParensPositions().add(JcTreeConverter.this.getPosition(node));
            JcTreeConverter.this.set(node, expr);
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast node) {
            Cast cast = new Cast();
            cast.rawOperand(JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[0]));
            cast.rawTypeReference(JcTreeConverter.this.toTree(node.getType(), new FlagKey[]{FlagKey.TYPE_REFERENCE}));
            JcTreeConverter.this.set(node, cast);
        }

        @Override
        public void visitUnary(JCTree.JCUnary node) {
            UnaryExpression expr = new UnaryExpression();
            expr.rawOperand(JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[0]));
            expr.astOperator((UnaryOperator)((Object)JcTreeBuilder.UNARY_OPERATORS.inverse().get((Object)this.getTag(node))));
            JcTreeConverter.this.set(node, expr);
        }

        @Override
        public void visitBinary(JCTree.JCBinary node) {
            BinaryExpression expr = new BinaryExpression();
            expr.rawLeft(JcTreeConverter.this.toTree(node.getLeftOperand(), new FlagKey[0]));
            expr.rawRight(JcTreeConverter.this.toTree(node.getRightOperand(), new FlagKey[0]));
            expr.astOperator((BinaryOperator)((Object)JcTreeBuilder.BINARY_OPERATORS.inverse().get((Object)this.getTag(node))));
            JcTreeConverter.this.set(node, expr);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass node) {
            ConstructorInvocation inv = new ConstructorInvocation();
            JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getArguments(), inv.rawArguments(), new FlagKey[0]);
            JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getTypeArguments(), inv.rawConstructorTypeArguments(), new FlagKey[]{FlagKey.TYPE_REFERENCE});
            inv.rawTypeReference(JcTreeConverter.this.toTree(node.getIdentifier(), new FlagKey[]{FlagKey.TYPE_REFERENCE}));
            inv.rawQualifier(JcTreeConverter.this.toTree(node.getEnclosingExpression(), new FlagKey[0]));
            Node n = JcTreeConverter.this.toTree(node.getClassBody(), new FlagKey[0]);
            if (n instanceof TypeDeclaration) {
                NormalTypeBody body = ((ClassDeclaration)n).astBody();
                if (body != null) {
                    body.unparent();
                }
                inv.rawAnonymousClassBody(JcTreeConverter.this.setPos(node.getClassBody(), body));
            }
            JcTreeConverter.this.set(node, inv);
        }

        @Override
        public void visitTypeTest(JCTree.JCInstanceOf node) {
            InstanceOf io = new InstanceOf();
            io.rawTypeReference(JcTreeConverter.this.toTree(node.getType(), new FlagKey[]{FlagKey.TYPE_REFERENCE}));
            io.rawObjectReference(JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[0]));
            JcTreeConverter.this.set(node, io);
        }

        @Override
        public void visitConditional(JCTree.JCConditional node) {
            InlineIfExpression iie = new InlineIfExpression();
            iie.rawCondition(JcTreeConverter.this.toTree(node.getCondition(), new FlagKey[0]));
            iie.rawIfTrue(JcTreeConverter.this.toTree(node.getTrueExpression(), new FlagKey[0]));
            iie.rawIfFalse(JcTreeConverter.this.toTree(node.getFalseExpression(), new FlagKey[0]));
            JcTreeConverter.this.set(node, iie);
        }

        @Override
        public void visitAssign(JCTree.JCAssign node) {
            BinaryExpression expr = new BinaryExpression();
            expr.rawRight(JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[0]));
            expr.rawLeft(JcTreeConverter.this.toTree(node.getVariable(), new FlagKey[0]));
            expr.astOperator(BinaryOperator.ASSIGN);
            JcTreeConverter.this.set(node, expr);
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp node) {
            BinaryExpression expr = new BinaryExpression();
            expr.rawRight(JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[0]));
            expr.rawLeft(JcTreeConverter.this.toTree(node.getVariable(), new FlagKey[0]));
            expr.astOperator((BinaryOperator)((Object)JcTreeBuilder.BINARY_OPERATORS.inverse().get((Object)this.getTag(node))));
            JcTreeConverter.this.set(node, expr);
        }

        @Override
        public void visitExec(JCTree.JCExpressionStatement node) {
            Node expr = JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[0]);
            if (expr instanceof SuperConstructorInvocation || expr instanceof AlternateConstructorInvocation) {
                ConversionPositionInfo.setConversionPositionInfo(expr, "exec", JcTreeConverter.this.getPosition(node));
                JcTreeConverter.this.set(node, expr);
                return;
            }
            ExpressionStatement exec = new ExpressionStatement();
            exec.rawExpression(expr);
            JcTreeConverter.this.set(node, exec);
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation node) {
            MethodInvocation inv = new MethodInvocation();
            JCTree.JCExpression sel = node.getMethodSelect();
            Identifier id = new Identifier();
            if (sel instanceof JCTree.JCIdent) {
                String name = ((JCTree.JCIdent)sel).getName().toString();
                if ("this".equals(name)) {
                    AlternateConstructorInvocation aci = new AlternateConstructorInvocation();
                    JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getTypeArguments(), aci.rawConstructorTypeArguments(), new FlagKey[]{FlagKey.TYPE_REFERENCE});
                    JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getArguments(), aci.rawArguments(), new FlagKey[0]);
                    JcTreeConverter.this.set(node, aci);
                    ConversionPositionInfo.setConversionPositionInfo(aci, "this", JcTreeConverter.this.getPosition(sel));
                    return;
                }
                if ("super".equals(name)) {
                    SuperConstructorInvocation sci = new SuperConstructorInvocation();
                    JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getTypeArguments(), sci.rawConstructorTypeArguments(), new FlagKey[]{FlagKey.TYPE_REFERENCE});
                    JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getArguments(), sci.rawArguments(), new FlagKey[0]);
                    JcTreeConverter.this.set(node, sci);
                    ConversionPositionInfo.setConversionPositionInfo(sci, "super", JcTreeConverter.this.getPosition(sel));
                    return;
                }
                JcTreeConverter.this.setPos(sel, id.astValue(name));
                sel = null;
            } else if (sel instanceof JCTree.JCFieldAccess) {
                String name = ((JCTree.JCFieldAccess)sel).getIdentifier().toString();
                if ("super".equals(name)) {
                    SuperConstructorInvocation sci = new SuperConstructorInvocation();
                    JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getTypeArguments(), sci.rawConstructorTypeArguments(), new FlagKey[]{FlagKey.TYPE_REFERENCE});
                    JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getArguments(), sci.rawArguments(), new FlagKey[0]);
                    sci.rawQualifier(JcTreeConverter.this.toTree(((JCTree.JCFieldAccess)sel).getExpression(), new FlagKey[0]));
                    JcTreeConverter.this.set(node, sci);
                    ConversionPositionInfo.setConversionPositionInfo(sci, "super", JcTreeConverter.this.getPosition(sel));
                    return;
                }
                JcTreeConverter.this.setPos(sel, id.astValue(name));
                sel = ((JCTree.JCFieldAccess)sel).getExpression();
            }
            inv.astName(id).rawOperand(JcTreeConverter.this.toTree(sel, new FlagKey[0]));
            JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getTypeArguments(), inv.rawMethodTypeArguments(), new FlagKey[]{FlagKey.TYPE_REFERENCE});
            JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getArguments(), inv.rawArguments(), new FlagKey[0]);
            JcTreeConverter.this.set(node, inv);
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray node) {
            ArrayInitializer init = null;
            if (node.getInitializers() != null) {
                init = (ArrayInitializer)JcTreeConverter.this.setPos(node, new ArrayInitializer());
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getInitializers(), init.rawExpressions(), new FlagKey[0]);
            }
            if (node.getType() == null) {
                JcTreeConverter.this.set(node, init == null ? new ArrayInitializer() : init);
                return;
            }
            ArrayCreation crea = new ArrayCreation();
            JCTree type = node.getType();
            ArrayList inits = Lists.newArrayList();
            while (type instanceof JCTree.JCArrayTypeTree) {
                inits.add(JcTreeConverter.this.getPosition(type));
                type = ((JCTree.JCArrayTypeTree)type).getType();
            }
            crea.rawComponentTypeReference(JcTreeConverter.this.toTree(type, new FlagKey[]{FlagKey.TYPE_REFERENCE}));
            if (node.getDimensions() != null) {
                for (JCTree.JCExpression dim : node.getDimensions()) {
                    crea.astDimensions().addToEnd(new ArrayDimension[]{(ArrayDimension)JcTreeConverter.this.setPos(dim, new ArrayDimension().rawDimension(JcTreeConverter.this.toTree(dim, new FlagKey[0])))});
                }
            }
            if (init != null) {
                crea.astDimensions().addToEnd(new ArrayDimension[]{new ArrayDimension()});
            }
            for (Position i : inits) {
                ArrayDimension dim = new ArrayDimension();
                dim.setPosition(i);
                crea.astDimensions().addToEnd(new ArrayDimension[]{dim});
            }
            crea.astInitializer(init);
            JcTreeConverter.this.set(node, crea);
        }

        @Override
        public void visitIndexed(JCTree.JCArrayAccess node) {
            ArrayAccess aa = new ArrayAccess();
            aa.rawIndexExpression(JcTreeConverter.this.toTree(node.getIndex(), new FlagKey[0]));
            aa.rawOperand(JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[0]));
            JcTreeConverter.this.set(node, aa);
        }

        @Override
        public void visitAssert(JCTree.JCAssert node) {
            JcTreeConverter.this.set(node, new Assert().rawAssertion(JcTreeConverter.this.toTree(node.getCondition(), new FlagKey[0])).rawMessage(JcTreeConverter.this.toTree(node.getDetail(), new FlagKey[0])));
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop node) {
            DoWhile dw = new DoWhile();
            JCTree.JCExpression cond = node.getCondition();
            ConversionPositionInfo.setConversionPositionInfo(dw, "()", JcTreeConverter.this.getPosition(cond));
            JcTreeConverter.this.set(node, dw.rawCondition(JcTreeConverter.this.toTree(JcTreeConverter.removeParens(cond), new FlagKey[0])).rawStatement(JcTreeConverter.this.toTree(node.getStatement(), new FlagKey[0])));
        }

        @Override
        public void visitContinue(JCTree.JCContinue node) {
            Continue c = new Continue();
            if (node.getLabel() != null) {
                c.astLabel(new Identifier().astValue(node.getLabel().toString()));
            }
            JcTreeConverter.this.set(node, c);
        }

        @Override
        public void visitBreak(JCTree.JCBreak node) {
            Break b = new Break();
            if (node.getLabel() != null) {
                b.astLabel(new Identifier().astValue(node.getLabel().toString()));
            }
            JcTreeConverter.this.set(node, b);
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop node) {
            ForEach fe = new ForEach();
            fe.rawIterable(JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[0]));
            fe.rawStatement(JcTreeConverter.this.toTree(node.getStatement(), new FlagKey[0]));
            fe.rawVariable(JcTreeConverter.this.toTree(node.getVariable(), new FlagKey[]{FlagKey.VARDEF_IS_DEFINITION}));
            JcTreeConverter.this.set(node, fe);
        }

        @Override
        public void visitIf(JCTree.JCIf node) {
            If i = new If();
            JCTree.JCExpression cond = node.getCondition();
            ConversionPositionInfo.setConversionPositionInfo(i, "()", JcTreeConverter.this.getPosition(cond));
            i.rawCondition(JcTreeConverter.this.toTree(JcTreeConverter.removeParens(cond), new FlagKey[0]));
            i.rawStatement(JcTreeConverter.this.toTree(node.getThenStatement(), new FlagKey[0]));
            i.rawElseStatement(JcTreeConverter.this.toTree(node.getElseStatement(), new FlagKey[0]));
            JcTreeConverter.this.set(node, i);
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement node) {
            Identifier lbl = new Identifier().astValue(node.getLabel().toString());
            JcTreeConverter.this.set(node, new LabelledStatement().rawStatement(JcTreeConverter.this.toTree(node.getStatement(), new FlagKey[0])).astLabel(lbl));
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop node) {
            For f = new For();
            f.rawCondition(JcTreeConverter.this.toTree(node.getCondition(), new FlagKey[0]));
            f.rawStatement(JcTreeConverter.this.toTree(node.getStatement(), new FlagKey[0]));
            for (JCTree.JCExpressionStatement upd : node.getUpdate()) {
                Node updateNode = JcTreeConverter.this.toTree(upd.getExpression(), new FlagKey[0]);
                ConversionPositionInfo.setConversionPositionInfo(updateNode, "exec", JcTreeConverter.this.getPosition(upd));
                f.rawUpdates().addToEnd(updateNode);
            }
            java.util.List initializers = node.getInitializer();
            if (!((List)initializers).isEmpty() && ((List)initializers).get(0) instanceof JCTree.JCVariableDecl) {
                Block tmp = new Block();
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)initializers, tmp.rawContents(), new FlagKey[]{FlagKey.VARDEF_IS_DEFINITION});
                Node varDecl = tmp.rawContents().first();
                if (varDecl != null) {
                    varDecl.unparent();
                }
                f.rawVariableDeclaration(varDecl);
            } else {
                for (JCTree.JCStatement init : initializers) {
                    if (init instanceof JCTree.JCExpressionStatement) {
                        Node initNode = JcTreeConverter.this.toTree(((JCTree.JCExpressionStatement)init).getExpression(), new FlagKey[0]);
                        ConversionPositionInfo.setConversionPositionInfo(initNode, "exec", JcTreeConverter.this.getPosition(init));
                        f.rawExpressionInits().addToEnd(initNode);
                        continue;
                    }
                    f.rawExpressionInits().addToEnd(JcTreeConverter.this.toTree(init, new FlagKey[0]));
                }
            }
            JcTreeConverter.this.set(node, f);
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch node) {
            Switch s = new Switch();
            JCTree.JCExpression cond = node.getExpression();
            ConversionPositionInfo.setConversionPositionInfo(s, "()", JcTreeConverter.this.getPosition(cond));
            s.rawCondition(JcTreeConverter.this.toTree(JcTreeConverter.removeParens(cond), new FlagKey[0]));
            Block b = new Block();
            s.astBody(b);
            for (JCTree.JCCase c : node.getCases()) {
                JCTree.JCExpression rawExpr = c.getExpression();
                if (rawExpr == null) {
                    b.rawContents().addToEnd(JcTreeConverter.this.setPos(c, new Default()));
                } else {
                    b.rawContents().addToEnd(JcTreeConverter.this.setPos(c, new Case().rawCondition(JcTreeConverter.this.toTree(rawExpr, new FlagKey[0]))));
                }
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)c.getStatements(), b.rawContents(), new FlagKey[0]);
            }
            JcTreeConverter.this.set(node, s);
        }

        @Override
        public void visitSynchronized(JCTree.JCSynchronized node) {
            Synchronized s = new Synchronized();
            JCTree.JCExpression cond = node.getExpression();
            ConversionPositionInfo.setConversionPositionInfo(s, "()", JcTreeConverter.this.getPosition(cond));
            JcTreeConverter.this.set(node, s.rawLock(JcTreeConverter.this.toTree(JcTreeConverter.removeParens(cond), new FlagKey[0])).rawBody(JcTreeConverter.this.toTree(node.getBlock(), new FlagKey[0])));
        }

        @Override
        public void visitTry(JCTree.JCTry node) {
            Try t = new Try();
            t.rawBody(JcTreeConverter.this.toTree(node.getBlock(), new FlagKey[0]));
            t.rawFinally(JcTreeConverter.this.toTree(node.getFinallyBlock(), new FlagKey[0]));
            JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getCatches(), t.rawCatches(), new FlagKey[0]);
            JcTreeConverter.this.set(node, t);
        }

        @Override
        public void visitCatch(JCTree.JCCatch node) {
            JcTreeConverter.this.set(node, new Catch().rawExceptionDeclaration(JcTreeConverter.this.toTree(node.getParameter(), new FlagKey[]{FlagKey.VARDEF_IS_DEFINITION})).rawBody(JcTreeConverter.this.toTree(node.getBlock(), new FlagKey[0])));
        }

        @Override
        public void visitThrow(JCTree.JCThrow node) {
            JcTreeConverter.this.set(node, new Throw().rawThrowable(JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[0])));
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop node) {
            While w = new While();
            JCTree.JCExpression cond = node.getCondition();
            ConversionPositionInfo.setConversionPositionInfo(w, "()", JcTreeConverter.this.getPosition(cond));
            JcTreeConverter.this.set(node, w.rawCondition(JcTreeConverter.this.toTree(JcTreeConverter.removeParens(cond), new FlagKey[0])).rawStatement(JcTreeConverter.this.toTree(node.getStatement(), new FlagKey[0])));
        }

        @Override
        public void visitReturn(JCTree.JCReturn node) {
            JcTreeConverter.this.set(node, new Return().rawValue(JcTreeConverter.this.toTree(node.getExpression(), new FlagKey[0])));
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl node) {
            String name;
            String string = name = node.getName() == null ? null : node.getName().toString();
            if ("<init>".equals(name)) {
                ConstructorDeclaration cd = new ConstructorDeclaration();
                cd.astModifiers((Modifiers)JcTreeConverter.this.toTree(node.getModifiers(), new FlagKey[0]));
                cd.rawBody(JcTreeConverter.this.toTree(node.getBody(), new FlagKey[0]));
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getThrows(), cd.rawThrownTypeReferences(), new FlagKey[]{FlagKey.TYPE_REFERENCE});
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getTypeParameters(), cd.rawTypeVariables(), new FlagKey[0]);
                JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getParameters(), cd.rawParameters(), new FlagKey[]{FlagKey.NO_VARDECL_FOLDING, FlagKey.VARDEF_IS_DEFINITION});
                String typeName = (String)JcTreeConverter.this.getFlag(FlagKey.CONTAINING_TYPE_NAME);
                cd.astTypeName((Identifier)JcTreeConverter.this.setPos(node, new Identifier().astValue(typeName)));
                JcTreeConverter.this.addJavadoc(cd, node.mods);
                JcTreeConverter.this.set(node, cd);
                return;
            }
            if (JcTreeConverter.this.hasFlag(FlagKey.METHODS_ARE_ANNMETHODS)) {
                AnnotationMethodDeclaration md = new AnnotationMethodDeclaration();
                md.astModifiers((Modifiers)JcTreeConverter.this.toTree(node.getModifiers(), new FlagKey[0]));
                md.astMethodName((Identifier)JcTreeConverter.this.setPos(node, new Identifier().astValue(name)));
                md.rawReturnTypeReference(JcTreeConverter.this.toTree(node.getReturnType(), new FlagKey[]{FlagKey.TYPE_REFERENCE}));
                md.rawDefaultValue(JcTreeConverter.this.toTree(node.getDefaultValue(), new FlagKey[0]));
                JcTreeConverter.this.addJavadoc(md, node.mods);
                JcTreeConverter.this.set(node, md);
                return;
            }
            MethodDeclaration md = new MethodDeclaration();
            md.rawBody(JcTreeConverter.this.toTree(node.getBody(), new FlagKey[0]));
            md.astModifiers((Modifiers)JcTreeConverter.this.toTree(node.getModifiers(), new FlagKey[0]));
            md.astMethodName((Identifier)JcTreeConverter.this.setPos(node, new Identifier().astValue(name)));
            JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getThrows(), md.rawThrownTypeReferences(), new FlagKey[]{FlagKey.TYPE_REFERENCE});
            JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getTypeParameters(), md.rawTypeVariables(), new FlagKey[0]);
            JcTreeConverter.this.fillList((java.util.List<? extends JCTree>)node.getParameters(), md.rawParameters(), new FlagKey[]{FlagKey.NO_VARDECL_FOLDING, FlagKey.VARDEF_IS_DEFINITION});
            md.rawReturnTypeReference(JcTreeConverter.this.toTree(node.getReturnType(), new FlagKey[]{FlagKey.TYPE_REFERENCE}));
            JcTreeConverter.this.addJavadoc(md, node.mods);
            JcTreeConverter.this.set(node, md);
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation node) {
            Annotation a = new Annotation();
            a.rawAnnotationTypeReference(JcTreeConverter.this.toTree(node.getAnnotationType(), new FlagKey[]{FlagKey.TYPE_REFERENCE}));
            for (JCTree.JCExpression elem : node.getArguments()) {
                AnnotationElement e = new AnnotationElement();
                if (elem instanceof JCTree.JCAssign) {
                    JCTree.JCExpression rawName = ((JCTree.JCAssign)elem).getVariable();
                    if (rawName instanceof JCTree.JCIdent) {
                        e.astName((Identifier)JcTreeConverter.this.setPos(rawName, new Identifier().astValue(((JCTree.JCIdent)rawName).getName().toString())));
                    }
                    elem = ((JCTree.JCAssign)elem).getExpression();
                }
                e.rawValue(JcTreeConverter.this.toTree(elem, new FlagKey[0]));
                a.astElements().addToEnd(new AnnotationElement[]{e});
            }
            JcTreeConverter.this.set(node, a);
        }
    }

    private static enum FlagKey {
        BLOCKS_ARE_INITIALIZERS,
        SKIP_IS_DECL,
        VARDEF_IS_DEFINITION,
        NO_VARDECL_FOLDING,
        CONTAINING_TYPE_NAME,
        TYPE_REFERENCE,
        METHODS_ARE_ANNMETHODS;

    }
}

