/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wellarchitected.model.LensMetric;
import com.amazonaws.services.wellarchitected.model.MetricType;
import com.amazonaws.services.wellarchitected.model.transform.ConsolidatedReportMetricMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConsolidatedReportMetric
implements Serializable,
Cloneable,
StructuredPojo {
    private String metricType;
    private Map<String, Integer> riskCounts;
    private String workloadId;
    private String workloadName;
    private String workloadArn;
    private Date updatedAt;
    private List<LensMetric> lenses;
    private Integer lensesAppliedCount;

    public void setMetricType(String metricType) {
        this.metricType = metricType;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public ConsolidatedReportMetric withMetricType(String metricType) {
        this.setMetricType(metricType);
        return this;
    }

    public ConsolidatedReportMetric withMetricType(MetricType metricType) {
        this.metricType = metricType.toString();
        return this;
    }

    public Map<String, Integer> getRiskCounts() {
        return this.riskCounts;
    }

    public void setRiskCounts(Map<String, Integer> riskCounts) {
        this.riskCounts = riskCounts;
    }

    public ConsolidatedReportMetric withRiskCounts(Map<String, Integer> riskCounts) {
        this.setRiskCounts(riskCounts);
        return this;
    }

    public ConsolidatedReportMetric addRiskCountsEntry(String key, Integer value) {
        if (null == this.riskCounts) {
            this.riskCounts = new HashMap<String, Integer>();
        }
        if (this.riskCounts.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.riskCounts.put(key, value);
        return this;
    }

    public ConsolidatedReportMetric clearRiskCountsEntries() {
        this.riskCounts = null;
        return this;
    }

    public void setWorkloadId(String workloadId) {
        this.workloadId = workloadId;
    }

    public String getWorkloadId() {
        return this.workloadId;
    }

    public ConsolidatedReportMetric withWorkloadId(String workloadId) {
        this.setWorkloadId(workloadId);
        return this;
    }

    public void setWorkloadName(String workloadName) {
        this.workloadName = workloadName;
    }

    public String getWorkloadName() {
        return this.workloadName;
    }

    public ConsolidatedReportMetric withWorkloadName(String workloadName) {
        this.setWorkloadName(workloadName);
        return this;
    }

    public void setWorkloadArn(String workloadArn) {
        this.workloadArn = workloadArn;
    }

    public String getWorkloadArn() {
        return this.workloadArn;
    }

    public ConsolidatedReportMetric withWorkloadArn(String workloadArn) {
        this.setWorkloadArn(workloadArn);
        return this;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public ConsolidatedReportMetric withUpdatedAt(Date updatedAt) {
        this.setUpdatedAt(updatedAt);
        return this;
    }

    public List<LensMetric> getLenses() {
        return this.lenses;
    }

    public void setLenses(Collection<LensMetric> lenses) {
        if (lenses == null) {
            this.lenses = null;
            return;
        }
        this.lenses = new ArrayList<LensMetric>(lenses);
    }

    public ConsolidatedReportMetric withLenses(LensMetric ... lenses) {
        if (this.lenses == null) {
            this.setLenses(new ArrayList<LensMetric>(lenses.length));
        }
        for (LensMetric ele : lenses) {
            this.lenses.add(ele);
        }
        return this;
    }

    public ConsolidatedReportMetric withLenses(Collection<LensMetric> lenses) {
        this.setLenses(lenses);
        return this;
    }

    public void setLensesAppliedCount(Integer lensesAppliedCount) {
        this.lensesAppliedCount = lensesAppliedCount;
    }

    public Integer getLensesAppliedCount() {
        return this.lensesAppliedCount;
    }

    public ConsolidatedReportMetric withLensesAppliedCount(Integer lensesAppliedCount) {
        this.setLensesAppliedCount(lensesAppliedCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricType() != null) {
            sb.append("MetricType: ").append(this.getMetricType()).append(",");
        }
        if (this.getRiskCounts() != null) {
            sb.append("RiskCounts: ").append(this.getRiskCounts()).append(",");
        }
        if (this.getWorkloadId() != null) {
            sb.append("WorkloadId: ").append(this.getWorkloadId()).append(",");
        }
        if (this.getWorkloadName() != null) {
            sb.append("WorkloadName: ").append(this.getWorkloadName()).append(",");
        }
        if (this.getWorkloadArn() != null) {
            sb.append("WorkloadArn: ").append(this.getWorkloadArn()).append(",");
        }
        if (this.getUpdatedAt() != null) {
            sb.append("UpdatedAt: ").append(this.getUpdatedAt()).append(",");
        }
        if (this.getLenses() != null) {
            sb.append("Lenses: ").append(this.getLenses()).append(",");
        }
        if (this.getLensesAppliedCount() != null) {
            sb.append("LensesAppliedCount: ").append(this.getLensesAppliedCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsolidatedReportMetric)) {
            return false;
        }
        ConsolidatedReportMetric other = (ConsolidatedReportMetric)obj;
        if (other.getMetricType() == null ^ this.getMetricType() == null) {
            return false;
        }
        if (other.getMetricType() != null && !other.getMetricType().equals(this.getMetricType())) {
            return false;
        }
        if (other.getRiskCounts() == null ^ this.getRiskCounts() == null) {
            return false;
        }
        if (other.getRiskCounts() != null && !other.getRiskCounts().equals(this.getRiskCounts())) {
            return false;
        }
        if (other.getWorkloadId() == null ^ this.getWorkloadId() == null) {
            return false;
        }
        if (other.getWorkloadId() != null && !other.getWorkloadId().equals(this.getWorkloadId())) {
            return false;
        }
        if (other.getWorkloadName() == null ^ this.getWorkloadName() == null) {
            return false;
        }
        if (other.getWorkloadName() != null && !other.getWorkloadName().equals(this.getWorkloadName())) {
            return false;
        }
        if (other.getWorkloadArn() == null ^ this.getWorkloadArn() == null) {
            return false;
        }
        if (other.getWorkloadArn() != null && !other.getWorkloadArn().equals(this.getWorkloadArn())) {
            return false;
        }
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null) {
            return false;
        }
        if (other.getUpdatedAt() != null && !other.getUpdatedAt().equals(this.getUpdatedAt())) {
            return false;
        }
        if (other.getLenses() == null ^ this.getLenses() == null) {
            return false;
        }
        if (other.getLenses() != null && !other.getLenses().equals(this.getLenses())) {
            return false;
        }
        if (other.getLensesAppliedCount() == null ^ this.getLensesAppliedCount() == null) {
            return false;
        }
        return other.getLensesAppliedCount() == null || other.getLensesAppliedCount().equals(this.getLensesAppliedCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricType() == null ? 0 : this.getMetricType().hashCode());
        hashCode = 31 * hashCode + (this.getRiskCounts() == null ? 0 : this.getRiskCounts().hashCode());
        hashCode = 31 * hashCode + (this.getWorkloadId() == null ? 0 : this.getWorkloadId().hashCode());
        hashCode = 31 * hashCode + (this.getWorkloadName() == null ? 0 : this.getWorkloadName().hashCode());
        hashCode = 31 * hashCode + (this.getWorkloadArn() == null ? 0 : this.getWorkloadArn().hashCode());
        hashCode = 31 * hashCode + (this.getUpdatedAt() == null ? 0 : this.getUpdatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLenses() == null ? 0 : this.getLenses().hashCode());
        hashCode = 31 * hashCode + (this.getLensesAppliedCount() == null ? 0 : this.getLensesAppliedCount().hashCode());
        return hashCode;
    }

    public ConsolidatedReportMetric clone() {
        try {
            return (ConsolidatedReportMetric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConsolidatedReportMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

