/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.textract.model.Adapter;
import java.util.List;

@SdkInternalApi
public class AdapterMarshaller {
    private static final MarshallingInfo<String> ADAPTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdapterId").build();
    private static final MarshallingInfo<List> PAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pages").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").build();
    private static final AdapterMarshaller instance = new AdapterMarshaller();

    public static AdapterMarshaller getInstance() {
        return instance;
    }

    public void marshall(Adapter adapter, ProtocolMarshaller protocolMarshaller) {
        if (adapter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)adapter.getAdapterId(), ADAPTERID_BINDING);
            protocolMarshaller.marshall(adapter.getPages(), PAGES_BINDING);
            protocolMarshaller.marshall((Object)adapter.getVersion(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

